/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter;

import com.itextpdf.kernel.colors.DeviceRgb;
import java.awt.Color;
import java.util.List;
import org.ofdrw.converter.utils.CommonUtil;
import org.ofdrw.core.basicType.ST_Array;
import org.ofdrw.core.basicType.ST_RefID;
import org.ofdrw.core.pageDescription.color.color.CT_Color;
import org.ofdrw.core.pageDescription.color.colorSpace.CT_ColorSpace;
import org.ofdrw.core.pageDescription.color.colorSpace.CV;
import org.ofdrw.core.pageDescription.color.colorSpace.OFDColorSpaceType;
import org.ofdrw.core.pageDescription.color.colorSpace.Palette;
import org.ofdrw.reader.ResourceManage;

public final class ColorConvert {
    public static String convertOfdColorToHtml(ST_Array colorArray) {
        String color = null;
        String colorStr = colorArray.toString();
        if (colorStr.indexOf("#") != -1) {
            colorStr = colorStr.replaceAll("#", "");
            colorStr = colorStr.replaceAll(" ", "");
            color = String.format("#%s", colorStr);
        } else {
            float[] colors = CommonUtil.doubleArrayToFloatArray(colorArray.toDouble());
            if (colors.length == 3) {
                color = String.format("rgb(%d,%d,%d)", (int)colors[0], (int)colors[1], (int)colors[2]);
            } else if (colors.length == 1) {
                color = String.format("rgb(%d,%d,%d)", (int)colors[0], (int)colors[0], (int)colors[0]);
            }
        }
        return color;
    }

    public static com.itextpdf.kernel.colors.Color convertOfdColor(ST_Array colorArray) {
        DeviceRgb color = null;
        String colorStr = colorArray.toString();
        if (colorStr.indexOf("#") != -1) {
            String[] rgbStr = colorStr.split(" ");
            String r = rgbStr[0].replaceAll("#", "");
            String g = rgbStr[1].replaceAll("#", "");
            String b = rgbStr[2].replaceAll("#", "");
            if (r.length() == 1) {
                r = r + "0";
            }
            if (g.length() == 1) {
                g = g + "0";
            }
            if (b.length() == 1) {
                b = b + "0";
            }
            Color jColor = Color.decode(String.format("#%s%s%s", r, g, b));
            color = new DeviceRgb((float)jColor.getRed() / 255.0f, (float)jColor.getGreen() / 255.0f, (float)jColor.getBlue() / 255.0f);
        } else {
            float[] colors = CommonUtil.doubleArrayToFloatArray(colorArray.toDouble());
            if (colors.length == 3) {
                color = new DeviceRgb(colors[0] / 255.0f, (float)((int)colors[1]) / 255.0f, (float)((int)colors[2]) / 255.0f);
            }
        }
        return color;
    }

    public static com.itextpdf.kernel.colors.Color pdfRGB(ResourceManage resMgt, CT_Color ctColor) {
        int[] rgb = ColorConvert.rgb(resMgt, ctColor);
        return new DeviceRgb((float)rgb[0] / 255.0f, (float)rgb[1] / 255.0f, (float)rgb[2] / 255.0f);
    }

    public static int[] rgb(ResourceManage resMgt, CT_Color ctColor) {
        if (ctColor == null) {
            return new int[]{0, 0, 0};
        }
        ST_Array colorValues = ctColor.getValue();
        Integer index = ctColor.getIndex();
        if (colorValues == null && index == null) {
            return new int[]{0, 0, 0};
        }
        CT_ColorSpace cs = null;
        ST_RefID colorSpaceId = ctColor.getColorSpace();
        if (colorSpaceId != null && resMgt != null) {
            cs = resMgt.getColorSpace(colorSpaceId.toString());
        }
        if (cs == null) {
            if (colorValues == null) {
                return new int[]{0, 0, 0};
            }
            cs = new CT_ColorSpace(OFDColorSpaceType.RGB);
        }
        if (index != null) {
            Palette palette = cs.getPalette();
            if (palette == null) {
                return new int[]{0, 0, 0};
            }
            List cVs = palette.getCVs();
            colorValues = ((CV)cVs.get(index)).getColor();
        }
        if (colorValues == null) {
            return null;
        }
        int[] color = new int[colorValues.size()];
        for (int i = 0; i < colorValues.size(); ++i) {
            String s = (String)colorValues.getArray().get(i);
            color[i] = s.startsWith("#") ? Integer.parseInt(s.replaceAll("#", ""), 16) : (s.indexOf(46) != -1 ? (int)Float.parseFloat(s) : Integer.parseInt(s));
        }
        switch (cs.getType()) {
            case RGB: {
                return color;
            }
            case CMYK: {
                return ColorConvert.cmykToRgb(color[0], color[1], color[2], color[3]);
            }
            case GRAY: {
                return new int[]{color[0], color[0], color[0]};
            }
        }
        return new int[]{0, 0, 0};
    }

    public static int[] cmykToRgb(int c, int m, int y, int k) {
        c = Math.min(c, 100);
        c = Math.max(c, 0);
        m = Math.min(m, 100);
        m = Math.max(m, 0);
        y = Math.min(y, 100);
        y = Math.max(y, 0);
        k = Math.min(k, 100);
        k = Math.max(k, 0);
        int r = 255 * (1 - c / 100) * (1 - k / 100);
        int g = 255 * (1 - m / 100) * (1 - k / 100);
        int b = 255 * (1 - y / 100) * (1 - k / 100);
        return new int[]{r, g, b};
    }
}

