/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter.export;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.ofdrw.converter.GeneralConvertException;
import org.ofdrw.converter.SVGMaker;
import org.ofdrw.converter.export.OFDExporter;
import org.ofdrw.reader.OFDReader;

public class SVGExporter
implements OFDExporter {
    final OFDReader ofdReader;
    final SVGMaker svgMaker;
    final Path outDirPath;
    List<Path> svgFileArr;
    private boolean closed = false;

    public SVGExporter(Path ofdFilePath, Path imgDirPath) throws IOException {
        this(ofdFilePath, imgDirPath, 15.0);
    }

    public SVGExporter(InputStream ofdInput, Path imgDirPath) throws IOException {
        this(ofdInput, imgDirPath, 15.0);
    }

    public SVGExporter(Path ofdFilePath, Path imgDirPath, double ppm) throws IOException {
        this.ofdReader = new OFDReader(ofdFilePath);
        if (imgDirPath == null) {
            throw new IllegalArgumentException("\u5bfc\u51fa\u56fe\u7247\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        }
        if (Files.exists(imgDirPath = imgDirPath.toAbsolutePath(), new LinkOption[0]) && !Files.isDirectory(imgDirPath, new LinkOption[0])) {
            throw new IllegalArgumentException("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u6587\u4ef6");
        }
        if (!Files.exists(imgDirPath, new LinkOption[0])) {
            Files.createDirectories(imgDirPath, new FileAttribute[0]);
        }
        this.svgMaker = new SVGMaker(this.ofdReader, ppm);
        this.svgMaker.config.setDrawBoundary(false);
        this.svgMaker.config.setClip(false);
        this.svgFileArr = new ArrayList<Path>();
        this.outDirPath = imgDirPath;
    }

    public SVGExporter(InputStream ofdInput, Path imgDirPath, double ppm) throws IOException {
        this.ofdReader = new OFDReader(ofdInput);
        if (imgDirPath == null) {
            throw new IllegalArgumentException("\u5bfc\u51fa\u56fe\u7247\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        }
        if (Files.exists(imgDirPath = imgDirPath.toAbsolutePath(), new LinkOption[0]) && !Files.isDirectory(imgDirPath, new LinkOption[0])) {
            throw new IllegalArgumentException("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u6587\u4ef6");
        }
        if (!Files.exists(imgDirPath, new LinkOption[0])) {
            Files.createDirectories(imgDirPath, new FileAttribute[0]);
        }
        this.svgMaker = new SVGMaker(this.ofdReader, ppm);
        this.svgMaker.config.setDrawBoundary(false);
        this.svgMaker.config.setClip(false);
        this.svgFileArr = new ArrayList<Path>();
        this.outDirPath = imgDirPath;
    }

    @Override
    public void export(int ... indexes) throws GeneralConvertException {
        LinkedList<Integer> targetPages = new LinkedList<Integer>();
        if (indexes == null || indexes.length == 0) {
            for (int i = 0; i < this.ofdReader.getNumberOfPages(); ++i) {
                targetPages.add(i);
            }
        } else {
            int maxPageIndex = this.ofdReader.getNumberOfPages();
            for (int index : indexes) {
                if (index < 0 || index >= maxPageIndex) continue;
                targetPages.add(index);
            }
        }
        try {
            for (Integer index : targetPages) {
                String svg = this.svgMaker.makePage(index);
                Path dst = this.outDirPath.resolve(this.svgFileArr.size() + ".svg");
                Files.write(dst, svg.getBytes(), new OpenOption[0]);
                this.svgFileArr.add(dst);
            }
        }
        catch (IOException e) {
            throw new GeneralConvertException("SVG\u8f6c\u6362\u5f02\u5e38", e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.ofdReader != null) {
            this.ofdReader.close();
        }
    }

    public List<Path> getSvgFilePaths() {
        return this.svgFileArr;
    }

    public void setPPM(double ppm) {
        if (this.svgMaker == null) {
            return;
        }
        this.svgMaker.setPPM(ppm);
    }
}

