/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter.font;

import java.io.IOException;
import org.ofdrw.converter.font.TTFDataStream;

public class HorizontalMetricsTable {
    private int[] advanceWidth;
    private short[] leftSideBearing;
    private short[] nonHorizontalLeftSideBearing;
    private int numHMetrics;
    private long[] offset;

    public HorizontalMetricsTable(long[] offset) {
        this.offset = offset;
    }

    public HorizontalMetricsTable parse(int numHMetrics, int numGlyphs, TTFDataStream data) throws IOException {
        data.seek(this.offset[0]);
        this.numHMetrics = numHMetrics;
        int bytesRead = 0;
        this.advanceWidth = new int[numHMetrics];
        this.leftSideBearing = new short[numHMetrics];
        for (int i = 0; i < numHMetrics; ++i) {
            this.advanceWidth[i] = data.readUnsignedShort();
            this.leftSideBearing[i] = data.readSignedShort();
            bytesRead += 4;
        }
        int numberNonHorizontal = numGlyphs - numHMetrics;
        if (numberNonHorizontal < 0) {
            numberNonHorizontal = numGlyphs;
        }
        this.nonHorizontalLeftSideBearing = new short[numberNonHorizontal];
        if ((long)bytesRead < this.getLength()) {
            for (int i = 0; i < numberNonHorizontal; ++i) {
                if ((long)bytesRead >= this.getLength()) continue;
                this.nonHorizontalLeftSideBearing[i] = data.readSignedShort();
                bytesRead += 2;
            }
        }
        return this;
    }

    private long getLength() {
        return this.offset[1];
    }

    public int getAdvanceWidth(int gid) {
        if (gid < this.numHMetrics) {
            return this.advanceWidth[gid];
        }
        return this.advanceWidth[this.advanceWidth.length - 1];
    }

    public int getLeftSideBearing(int gid) {
        if (gid < this.numHMetrics) {
            return this.leftSideBearing[gid];
        }
        return this.nonHorizontalLeftSideBearing[gid - this.numHMetrics];
    }
}

