/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.font;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;

public final class EnvFont {
    private static volatile boolean isInitialized = false;
    private static Map<String, Font> fMap;
    private static FontRenderContext frCtx;
    private static Font defaultFont;

    public static Font getFont(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        EnvFont.initialize();
        name = name.toLowerCase();
        return fMap.get(name);
    }

    private static synchronized void initialize() {
        if (!isInitialized) {
            Font[] allFonts;
            defaultFont = null;
            fMap = new HashMap<String, Font>();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (Font font : allFonts = ge.getAllFonts()) {
                fMap.put(font.getFontName().toLowerCase(), font);
                fMap.put(font.getFamily().toLowerCase(), font);
                if (defaultFont != null) continue;
                defaultFont = font;
            }
            if (fMap.get("\u5b8b\u4f53") != null) {
                defaultFont = fMap.get("\u5b8b\u4f53");
            } else if (fMap.get("simsun") != null) {
                defaultFont = fMap.get("simsun");
            } else if (fMap.get("microsoftyahei") != null) {
                defaultFont = fMap.get("microsoftyahei");
            } else if (fMap.get("stheiti-light") != null) {
                defaultFont = fMap.get("stheiti-light");
            } else if (fMap.get("times new roman") != null) {
                defaultFont = fMap.get("times new roman");
            } else if (fMap.get("serif") != null) {
                defaultFont = fMap.get("serif");
            }
            isInitialized = true;
        }
    }

    public static Font getFont(String name, String family) {
        Font res = null;
        if (name != null) {
            res = EnvFont.getFont(name);
        }
        if (res != null) {
            return res;
        }
        if (family != null) {
            res = EnvFont.getFont(family);
        }
        return res;
    }

    public static synchronized void setMapping(String name, Font font) {
        if (name == null || name.equals("")) {
            return;
        }
        fMap.put(name, font);
    }

    public static Rectangle2D strBounds(String name, String family, String str, double size) {
        Font font = EnvFont.getFont(name, family);
        if (font == null) {
            font = defaultFont;
        }
        font = font.deriveFont((float)size);
        return font.getStringBounds(str, EnvFont.FRCtx());
    }

    public static Font getDefaultFont() {
        return defaultFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FontRenderContext FRCtx() {
        if (frCtx != null) return frCtx;
        Class<EnvFont> clazz = EnvFont.class;
        synchronized (EnvFont.class) {
            frCtx = new FontRenderContext(new AffineTransform(), true, true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return frCtx;
        }
    }
}

