/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.gm.ses.parse;

import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.ofdrw.gm.ses.parse.SESVersion;
import org.ofdrw.gm.ses.v1.SES_Signature;
import org.ofdrw.gm.ses.v1.SESeal;

public class SESVersionHolder {
    private SESVersion version;
    private ASN1Sequence objSeq;

    public SESVersionHolder(SESVersion version, ASN1Sequence objSeq) {
        this.version = version;
        this.objSeq = objSeq;
    }

    public SESVersion getVersion() {
        return this.version;
    }

    public ASN1Sequence getObjSeq() {
        return this.objSeq;
    }

    public <T extends ASN1Object> T SESObject() {
        ASN1Object obj = null;
        switch (this.version) {
            case v1: {
                if (this.objSeq.size() != 2) break;
                obj = new SES_Signature(this.objSeq);
                break;
            }
            case v4: {
                if (this.objSeq.size() < 4) break;
                obj = new org.ofdrw.gm.ses.v4.SES_Signature(this.objSeq);
            }
        }
        return (T)obj;
    }

    public <T extends ASN1Object> T SealObject() {
        ASN1Object obj = null;
        switch (this.version) {
            case v1: {
                if (this.objSeq.size() != 2) break;
                obj = new SESeal(this.objSeq);
                break;
            }
            case v4: {
                if (this.objSeq.size() != 4) break;
                obj = new org.ofdrw.gm.ses.v4.SESeal(this.objSeq);
            }
        }
        return (T)obj;
    }

    public SES_Signature getInstanceV1() {
        return (SES_Signature)((Object)this.SESObject());
    }

    public org.ofdrw.gm.ses.v4.SES_Signature getInstanceV4() {
        return (org.ofdrw.gm.ses.v4.SES_Signature)((Object)this.SESObject());
    }

    public SESeal getInstanceV1Seal() {
        return (SESeal)((Object)this.SealObject());
    }

    public org.ofdrw.gm.ses.v4.SESeal getInstanceV4Seal() {
        return (org.ofdrw.gm.ses.v4.SESeal)((Object)this.SealObject());
    }
}

