/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.graphics2d;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import org.ofdrw.core.basicType.ST_Array;
import org.ofdrw.core.basicType.ST_Pos;
import org.ofdrw.core.basicType.ST_RefID;
import org.ofdrw.core.graph.pathObj.CT_Path;
import org.ofdrw.core.pageDescription.CT_GraphicUnit;
import org.ofdrw.core.pageDescription.clips.Area;
import org.ofdrw.core.pageDescription.clips.CT_Clip;
import org.ofdrw.core.pageDescription.clips.ClipAble;
import org.ofdrw.core.pageDescription.clips.Clips;
import org.ofdrw.core.pageDescription.color.color.CT_AxialShd;
import org.ofdrw.core.pageDescription.color.color.CT_Color;
import org.ofdrw.core.pageDescription.color.color.CT_RadialShd;
import org.ofdrw.core.pageDescription.color.color.ColorClusterType;
import org.ofdrw.core.pageDescription.color.color.MapType;
import org.ofdrw.core.pageDescription.color.color.Segment;
import org.ofdrw.core.pageDescription.drawParam.CT_DrawParam;
import org.ofdrw.core.pageDescription.drawParam.LineCapType;
import org.ofdrw.core.pageDescription.drawParam.LineJoinType;
import org.ofdrw.graphics2d.OFDGraphicsDocument;
import org.ofdrw.graphics2d.OFDShapes;

public class OFDGraphics2DDrawParam {
    private final OFDGraphicsDocument ctx;
    Font font;
    CT_DrawParam pCache;
    ST_RefID ref;
    BasicStroke gStroke;
    Paint gColor;
    Shape gClip;
    Color gBackground;
    Color gForeground;
    ST_Array ctm;
    AffineTransform gCtm;
    RenderingHints hints;
    Composite composite;
    FontRenderContext fontRenderCtx;
    private static final ST_Array ONE = ST_Array.unitCTM();

    public OFDGraphics2DDrawParam(OFDGraphicsDocument ctx) {
        this.ctx = ctx;
        this.pCache = new CT_DrawParam();
        this.gStroke = new BasicStroke(0.353f);
        this.pCache.setStrokeColor(CT_Color.rgb((int)0, (int)0, (int)0));
        this.gColor = new Color(0, 0, 0);
        this.gBackground = new Color(255, 255, 255);
        this.gForeground = new Color(0, 0, 0);
        this.ctm = ST_Array.unitCTM();
        this.gCtm = new AffineTransform();
        this.ref = null;
        this.gClip = null;
        this.hints = new RenderingHints(null);
        this.composite = AlphaComposite.SrcOver;
        this.font = new Font("sanserif", 0, 3);
    }

    public void setStroke(Stroke s) {
        float[] dashArray;
        if (this.ref != null) {
            this.pCache = this.pCache.clone();
        }
        this.ref = null;
        if (s == null) {
            s = new BasicStroke(0.353f);
        }
        if (s instanceof BasicStroke) {
            this.gStroke = (BasicStroke)s;
        }
        switch (this.gStroke.getLineJoin()) {
            case 2: {
                this.pCache.setJoin(LineJoinType.Bevel);
                break;
            }
            case 0: {
                this.pCache.setJoin(LineJoinType.Miter);
                break;
            }
            case 1: {
                this.pCache.setJoin(LineJoinType.Round);
                break;
            }
            default: {
                this.pCache.setJoin(null);
            }
        }
        if (this.gStroke.getLineWidth() > 0.0f) {
            this.pCache.setLineWidth(Double.valueOf(this.gStroke.getLineWidth()));
        }
        if ((dashArray = this.gStroke.getDashArray()) != null && dashArray.length > 0) {
            ST_Array pattern = new ST_Array(new Serializable[0]);
            for (float v : dashArray) {
                pattern.add(Float.toString(v));
            }
            this.pCache.setDashPattern(pattern);
        } else {
            this.pCache.setDashPattern(null);
        }
        switch (this.gStroke.getEndCap()) {
            case 0: {
                this.pCache.setCap(LineCapType.Butt);
                break;
            }
            case 1: {
                this.pCache.setCap(LineCapType.Round);
                break;
            }
            case 2: {
                this.pCache.setCap(LineCapType.Square);
                break;
            }
            default: {
                this.pCache.setCap(null);
            }
        }
        float miterLimit = this.gStroke.getMiterLimit();
        if (miterLimit > 0.0f) {
            this.pCache.setMiterLimit(Double.valueOf(miterLimit));
        } else {
            this.pCache.setMiterLimit(null);
        }
    }

    public void setColor(Paint paint) {
        if (this.ref != null) {
            this.pCache = this.pCache.clone();
        }
        this.ref = null;
        if (paint == null) {
            paint = new Color(0, 0, 0);
        }
        this.gColor = paint;
        CT_Color ctColor = null;
        if (paint instanceof Color) {
            Color c = (Color)paint;
            ctColor = CT_Color.rgb((int)c.getRed(), (int)c.getGreen(), (int)c.getBlue());
            ctColor.setAlpha(Integer.valueOf(c.getAlpha()));
        } else if (paint instanceof LinearGradientPaint) {
            LinearGradientPaint lgp = (LinearGradientPaint)paint;
            ctColor = new CT_Color();
            CT_AxialShd axialShd = new CT_AxialShd();
            axialShd.setStartPoint(ST_Pos.getInstance((double)lgp.getStartPoint().getX(), (double)lgp.getStartPoint().getY()));
            axialShd.setEndPoint(ST_Pos.getInstance((double)lgp.getEndPoint().getX(), (double)lgp.getEndPoint().getY()));
            Color[] colors = lgp.getColors();
            float[] fractions = lgp.getFractions();
            for (int i = 0; i < colors.length; ++i) {
                CT_Color cc = CT_Color.rgb((int)colors[i].getRed(), (int)colors[i].getGreen(), (int)colors[i].getBlue());
                cc.setAlpha(Integer.valueOf(colors[i].getAlpha()));
                axialShd.addSegment(new Segment(Double.valueOf(fractions[i]), cc));
            }
            switch (lgp.getCycleMethod()) {
                case NO_CYCLE: {
                    axialShd.setMapType(MapType.Direct);
                    break;
                }
                case REPEAT: {
                    axialShd.setMapType(MapType.Repeat);
                    break;
                }
                case REFLECT: {
                    axialShd.setMapType(MapType.Reflect);
                }
            }
            ctColor.setColor((ColorClusterType)axialShd);
        } else if (paint instanceof RadialGradientPaint) {
            RadialGradientPaint rgp = (RadialGradientPaint)paint;
            ctColor = new CT_Color();
            CT_RadialShd radialShd = new CT_RadialShd();
            Color[] colors = rgp.getColors();
            float[] fractions = rgp.getFractions();
            for (int i = 0; i < colors.length; ++i) {
                CT_Color cc = CT_Color.rgb((int)colors[i].getRed(), (int)colors[i].getGreen(), (int)colors[i].getBlue());
                cc.setAlpha(Integer.valueOf(colors[i].getAlpha()));
                radialShd.addSegment(new Segment(Double.valueOf(fractions[i]), cc));
            }
            switch (rgp.getCycleMethod()) {
                case NO_CYCLE: {
                    radialShd.setMapType(MapType.Direct);
                    break;
                }
                case REFLECT: {
                    radialShd.setMapType(MapType.Reflect);
                    break;
                }
                case REPEAT: {
                    radialShd.setMapType(MapType.Repeat);
                }
            }
            radialShd.setEndRadius(Double.valueOf(rgp.getRadius()));
            ST_Pos startPoint = ST_Pos.getInstance((double)rgp.getCenterPoint().getX(), (double)rgp.getCenterPoint().getY());
            radialShd.setStartPoint(startPoint);
            ST_Pos endPoint = ST_Pos.getInstance((double)rgp.getFocusPoint().getX(), (double)rgp.getFocusPoint().getY());
            radialShd.setEndPoint(endPoint);
            ctColor.setColor((ColorClusterType)radialShd);
        } else if (paint instanceof GradientPaint) {
            GradientPaint gp = (GradientPaint)paint;
            ctColor = new CT_Color();
            CT_AxialShd axialShd = new CT_AxialShd();
            axialShd.setStartPoint(ST_Pos.getInstance((double)gp.getPoint1().getX(), (double)gp.getPoint1().getY()));
            axialShd.setEndPoint(ST_Pos.getInstance((double)gp.getPoint2().getX(), (double)gp.getPoint2().getY()));
            if (gp.isCyclic()) {
                axialShd.setMapType(MapType.Repeat);
            }
            axialShd.addSegment(new Segment(CT_Color.rgb((int)gp.getColor1().getRed(), (int)gp.getColor1().getGreen(), (int)gp.getColor1().getBlue())));
            axialShd.addSegment(new Segment(CT_Color.rgb((int)gp.getColor2().getRed(), (int)gp.getColor2().getGreen(), (int)gp.getColor2().getBlue())));
            ctColor.setColor((ColorClusterType)axialShd);
        }
        if (ctColor != null) {
            this.pCache.setFillColor(ctColor);
            this.pCache.setStrokeColor(ctColor);
        }
    }

    public void setForeground(Color c) {
        this.gForeground = c;
        this.setColor(c);
    }

    public void apply(CT_GraphicUnit<?> target) {
        if (this.ref == null) {
            this.ref = this.ctx.addDrawParam(this.pCache).ref();
        }
        target.setDrawParam(this.ref);
        ST_Array ctmApplied = target.getCTM();
        if (!this.ctm.equals((Object)ONE)) {
            ctmApplied = ctmApplied != null ? ctmApplied.mtxMul(this.ctm) : this.ctm;
            target.setCTM(ctmApplied);
        }
        if (this.gClip != null) {
            Clips clips = new Clips();
            Area area = new Area();
            if (!this.ctm.equals((Object)ONE)) {
                area.setCTM(ctmApplied);
            }
            area.setClipObj((ClipAble)new CT_Path().setAbbreviatedData(OFDShapes.path(this.gClip)));
            clips.addClip(new CT_Clip().addArea(area));
            target.setClips(clips);
        }
    }

    public FontRenderContext getFontRenderContext() {
        if (this.fontRenderCtx != null) {
            return this.fontRenderCtx;
        }
        Object antialiasingHint = this.hints.get(RenderingHints.KEY_TEXT_ANTIALIASING);
        boolean isAntialiased = true;
        if (antialiasingHint != RenderingHints.VALUE_TEXT_ANTIALIAS_ON && antialiasingHint != RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
            if (antialiasingHint != RenderingHints.VALUE_TEXT_ANTIALIAS_OFF) {
                antialiasingHint = this.hints.get(RenderingHints.KEY_ANTIALIASING);
                if (antialiasingHint != RenderingHints.VALUE_ANTIALIAS_ON && antialiasingHint != RenderingHints.VALUE_ANTIALIAS_DEFAULT && antialiasingHint == RenderingHints.VALUE_ANTIALIAS_OFF) {
                    isAntialiased = false;
                }
            } else {
                isAntialiased = false;
            }
        }
        boolean useFractionalMetrics = this.hints.get(RenderingHints.KEY_FRACTIONALMETRICS) != RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
        this.fontRenderCtx = new FontRenderContext(new AffineTransform(), isAntialiased, useFractionalMetrics);
        return this.fontRenderCtx;
    }

    public OFDGraphics2DDrawParam clone() {
        OFDGraphics2DDrawParam that = new OFDGraphics2DDrawParam(this.ctx);
        that.pCache = this.pCache.clone();
        that.gColor = this.gColor;
        that.gStroke = this.gStroke;
        that.gBackground = this.gBackground;
        that.gForeground = this.gForeground;
        that.ctm = this.ctm.clone();
        that.gCtm = new AffineTransform(this.gCtm);
        that.gClip = this.gClip;
        that.ref = this.ref;
        that.hints = (RenderingHints)this.hints.clone();
        that.composite = this.composite;
        that.font = this.font;
        return that;
    }
}

