/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.graphics2d;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import org.ofdrw.core.basicStructure.doc.CT_CommonData;
import org.ofdrw.core.basicStructure.doc.CT_PageArea;
import org.ofdrw.core.basicStructure.doc.Document;
import org.ofdrw.core.basicStructure.ofd.DocBody;
import org.ofdrw.core.basicStructure.ofd.OFD;
import org.ofdrw.core.basicStructure.ofd.docInfo.CT_DocInfo;
import org.ofdrw.core.basicStructure.pageObj.Page;
import org.ofdrw.core.basicStructure.pageTree.Pages;
import org.ofdrw.core.basicStructure.res.CT_MultiMedia;
import org.ofdrw.core.basicStructure.res.MediaType;
import org.ofdrw.core.basicStructure.res.OFDResource;
import org.ofdrw.core.basicStructure.res.Res;
import org.ofdrw.core.basicStructure.res.resources.DrawParams;
import org.ofdrw.core.basicStructure.res.resources.MultiMedias;
import org.ofdrw.core.basicType.ST_ID;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.core.pageDescription.drawParam.CT_DrawParam;
import org.ofdrw.graphics2d.OFDPageGraphics2D;
import org.ofdrw.pkg.container.DocDir;
import org.ofdrw.pkg.container.OFDDir;
import org.ofdrw.pkg.container.PageDir;
import org.ofdrw.pkg.container.PagesDir;
import org.ofdrw.pkg.container.ResDir;

public class OFDGraphicsDocument
implements Closeable {
    private Path outPath;
    private boolean closed = false;
    public final Res publicRes;
    private MultiMedias medias;
    private DrawParams drawParams;
    public final OFDDir ofdDir;
    public final AtomicInteger MaxUnitID = new AtomicInteger(0);
    public CT_CommonData cdata;
    public final Document document;
    public final DocDir docDir;

    public OFDGraphicsDocument(Path outPath) {
        this();
        if (outPath == null) {
            throw new IllegalArgumentException("OFD\u6587\u4ef6\u5b58\u50a8\u8def\u5f84(outPath)\u4e3a\u7a7a");
        }
        if (Files.isDirectory(outPath, new LinkOption[0])) {
            throw new IllegalArgumentException("OFD\u6587\u4ef6\u5b58\u50a8\u8def\u5f84(outPath)\u4e0d\u80fd\u662f\u76ee\u5f55");
        }
        if (!Files.exists(outPath.toAbsolutePath().getParent(), new LinkOption[0])) {
            throw new IllegalArgumentException("OFD\u6587\u4ef6\u5b58\u50a8\u8def\u5f84(outPath)\u4e0a\u7ea7\u76ee\u5f55 [" + outPath.getParent().toAbsolutePath() + "] \u4e0d\u5b58\u5728");
        }
        this.outPath = outPath;
    }

    private OFDGraphicsDocument() {
        DocDir docDir;
        CT_DocInfo docInfo = new CT_DocInfo().setDocID(UUID.randomUUID()).setCreationDate(LocalDate.now()).setCreator("OFD R&W").setCreatorVersion("2.0.0");
        DocBody docBody = new DocBody().setDocInfo(docInfo).setDocRoot(new ST_Loc("Doc_0/Document.xml"));
        OFD ofd = new OFD().addDocBody(docBody);
        this.document = new Document();
        this.cdata = new CT_CommonData();
        CT_PageArea defaultPageSize = new CT_PageArea().setPhysicalBox(0.0, 0.0, 210.0, 297.0).setApplicationBox(0.0, 0.0, 210.0, 297.0);
        this.cdata.setPageArea(defaultPageSize);
        this.document.setCommonData(this.cdata).setPages(new Pages());
        this.ofdDir = OFDDir.newOFD().setOfd(ofd);
        this.docDir = docDir = this.ofdDir.newDoc();
        docDir.setDocument(this.document);
        this.publicRes = new Res().setBaseLoc(ST_Loc.getInstance((String)"Res"));
        docDir.setPublicRes(this.publicRes);
        this.cdata.addPublicRes(ST_Loc.getInstance((String)"PublicRes.xml"));
    }

    private MultiMedias obtainMedias() {
        if (this.medias == null) {
            this.medias = new MultiMedias();
            this.publicRes.addResource((OFDResource)this.medias);
        }
        return this.medias;
    }

    private DrawParams obtainDrawParam() {
        if (this.drawParams == null) {
            this.drawParams = new DrawParams();
            this.publicRes.addResource((OFDResource)this.drawParams);
        }
        return this.drawParams;
    }

    public OFDPageGraphics2D newPage(double width, double height) {
        CT_PageArea size = new CT_PageArea().setPhysicalBox(0.0, 0.0, width, height).setApplicationBox(0.0, 0.0, width, height);
        return this.newPage(size);
    }

    public OFDPageGraphics2D newPage(CT_PageArea pageSize) {
        Pages pages = this.document.getPages();
        PagesDir pagesDir = this.docDir.obtainPages();
        PageDir pageDir = pagesDir.newPageDir();
        String pageLoc = String.format("Pages/Page_%d/Content.xml", pageDir.getIndex());
        org.ofdrw.core.basicStructure.pageTree.Page page = new org.ofdrw.core.basicStructure.pageTree.Page((long)this.MaxUnitID.incrementAndGet(), pageLoc);
        pages.addPage(page);
        Page pageObj = new Page();
        if (pageSize != null) {
            pageObj.setArea(pageSize);
        } else {
            pageSize = this.cdata.getPageArea();
        }
        pageDir.setContent(pageObj);
        return new OFDPageGraphics2D(this, pageDir, pageObj, pageSize.getBox());
    }

    public ST_ID addResImg(Image img) {
        File imgFile;
        if (img == null) {
            return null;
        }
        ResDir resDir = this.docDir.obtainRes();
        Path resDirPath = resDir.getContainerPath();
        try {
            BufferedImage bi;
            imgFile = File.createTempFile("res", ".png", resDirPath.toFile());
            if (img instanceof BufferedImage) {
                bi = (BufferedImage)img;
            } else {
                bi = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
                Graphics g2 = bi.getGraphics();
                g2.drawImage(img, 0, 0, null);
                g2.dispose();
            }
            ImageIO.write((RenderedImage)bi, "png", imgFile);
        }
        catch (IOException e) {
            throw new RuntimeException("graphics2d \u56fe\u7247\u5199\u5165IO\u5f02\u5e38", e);
        }
        ST_ID id = new ST_ID((long)this.MaxUnitID.incrementAndGet());
        CT_MultiMedia multiMedia = new CT_MultiMedia().setType(MediaType.Image).setFormat("PNG").setMediaFile(resDir.getAbsLoc().cat(imgFile.getName())).setID(id);
        this.obtainMedias().addMultiMedia(multiMedia);
        return id;
    }

    public ST_ID addDrawParam(CT_DrawParam drawParam) {
        if (drawParam == null) {
            return null;
        }
        ST_ID id = new ST_ID((long)this.MaxUnitID.incrementAndGet());
        drawParam.setObjID(id);
        this.obtainDrawParam().addDrawParam(drawParam);
        return id;
    }

    public ST_ID newID() {
        return new ST_ID((long)this.MaxUnitID.incrementAndGet());
    }

    @Override
    public void close() throws IOException {
        block6: {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                this.cdata.setMaxUnitID((long)this.MaxUnitID.get());
                if (this.outPath != null) {
                    this.ofdDir.jar(this.outPath.toAbsolutePath());
                    break block6;
                }
                throw new IllegalArgumentException("OFD\u6587\u6863\u8f93\u51fa\u5730\u5740\u9519\u8bef\u6216\u6ca1\u6709\u8bbe\u7f6e\u8f93\u51fa\u6d41");
            }
            finally {
                if (this.ofdDir != null) {
                    this.ofdDir.clean();
                }
            }
        }
    }
}

