/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.edit;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.ofdrw.core.annotation.Annotations;
import org.ofdrw.core.annotation.pageannot.AnnPage;
import org.ofdrw.core.annotation.pageannot.Annot;
import org.ofdrw.core.annotation.pageannot.Appearance;
import org.ofdrw.core.annotation.pageannot.PageAnnot;
import org.ofdrw.core.basicStructure.doc.Document;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CT_PageBlock;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.basicType.ST_ID;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.layout.edit.Annotation;
import org.ofdrw.layout.element.canvas.DrawContext;
import org.ofdrw.layout.element.canvas.Drawer;
import org.ofdrw.layout.engine.ResManager;
import org.ofdrw.layout.engine.render.RenderException;
import org.ofdrw.pkg.container.AnnotsDir;
import org.ofdrw.pkg.container.DocDir;
import org.ofdrw.pkg.container.PageDir;
import org.ofdrw.pkg.container.VirtualContainer;
import org.ofdrw.reader.BadOFDException;
import org.ofdrw.reader.PageInfo;
import org.ofdrw.reader.ResourceLocator;

public class AnnotationRender {
    private DocDir docDir;
    private AnnotsDir annotsDir;
    private Annotations annotations = null;
    private ResourceLocator rl;
    private ResManager prm;
    private AtomicInteger maxUnitID;

    public AnnotationRender(DocDir docDir, ResManager prm, AtomicInteger maxUnitID) {
        this.docDir = docDir;
        this.prm = prm;
        this.maxUnitID = maxUnitID;
    }

    private void init() {
        Document document;
        if (this.annotations != null) {
            return;
        }
        try {
            document = this.docDir.getDocument();
        }
        catch (FileNotFoundException | DocumentException e) {
            throw new BadOFDException("\u9519\u8bef\u7684OFD\u7ed3\u6784\u65e0\u6cd5\u83b7\u53d6\u5230Document.xml\u6587\u4ef6", e);
        }
        ST_Loc annListFileLoc = document.getAnnotations();
        this.rl = new ResourceLocator((VirtualContainer)this.docDir);
        if (annListFileLoc != null) {
            try {
                this.annotations = (Annotations)this.rl.get(annListFileLoc, Annotations::new);
                String parent = annListFileLoc.parent();
                this.annotsDir = parent.toLowerCase().endsWith("Annots".toLowerCase()) ? new AnnotsDir(this.rl.getFile(parent)) : null;
                this.rl.cd(parent);
            }
            catch (FileNotFoundException | DocumentException e) {
                System.err.println(e.getMessage());
            }
        }
        if (this.annotations == null) {
            this.annotsDir = this.docDir.obtainAnnots();
            this.annotations = new Annotations();
            this.annotsDir.putObj("Annotations.xml", (Element)this.annotations);
            document.setAnnotations(this.annotsDir.getAbsLoc().cat("Annotations.xml"));
        }
    }

    public void render(PageInfo pageInfo, Annotation build) throws RenderException, IOException {
        Drawer drawer = build.getDrawer();
        if (drawer == null) {
            return;
        }
        this.init();
        ST_ID id = pageInfo.getId();
        AnnPage record = this.annotations.getByPageId(id.toString());
        PageAnnot pageAnnot = null;
        if (record == null) {
            record = new AnnPage().setPageID(pageInfo.getId());
            this.annotations.addPage(record);
        } else {
            ST_Loc annPageFileLoc = record.getFileLoc();
            try {
                pageAnnot = (PageAnnot)this.rl.get(annPageFileLoc, PageAnnot::new);
            }
            catch (FileNotFoundException | DocumentException e) {
                pageAnnot = null;
            }
        }
        if (pageAnnot == null) {
            if (this.annotsDir == null) {
                this.annotsDir = this.docDir.obtainAnnots();
            }
            PageDir pageDir = this.annotsDir.obtainByIndex(pageInfo.getPageN().intValue());
            pageAnnot = new PageAnnot();
            ST_Loc pageAnnotLoc = pageDir.addAnnot(pageAnnot);
            record.setFileLoc(pageAnnotLoc);
        }
        Annot annot = build.build();
        annot.setObjID((long)this.maxUnitID.incrementAndGet());
        pageAnnot.addAnnot(annot);
        Appearance container = annot.getAppearance();
        ST_Box box = container.getBoundary().clone().setTopLeftX(Double.valueOf(0.0)).setTopLeftY(Double.valueOf(0.0));
        DrawContext ctx = new DrawContext((CT_PageBlock)container, box, this.maxUnitID, this.prm);
        drawer.draw(ctx);
    }
}

