/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.engine;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.ofdrw.layout.Rectangle;
import org.ofdrw.layout.element.AFloat;
import org.ofdrw.layout.element.Clear;
import org.ofdrw.layout.element.Div;
import org.ofdrw.layout.element.PageAreaFiller;

public class Segment
implements Iterable<Map.Entry<Div, Rectangle>>,
Iterator<Map.Entry<Div, Rectangle>> {
    private List<Div> content;
    private List<Rectangle> sizeList;
    private double height = 0.0;
    private double width;
    private double remainWidth;
    private boolean blockable = false;
    private boolean isRemainAreaFiller = false;
    private int cnt = 0;

    public Segment(double width) {
        this.width = width;
        this.remainWidth = width;
        this.content = new ArrayList<Div>(5);
        this.sizeList = new ArrayList<Rectangle>(5);
    }

    private Segment() {
    }

    public double getHeight() {
        return this.height;
    }

    public boolean tryAdd(Div div) {
        if (div == null) {
            return true;
        }
        if (this.remainWidth == 0.0) {
            return false;
        }
        Rectangle blockSize = div.doPrepare(this.width);
        if (blockSize.getWidth() > this.remainWidth) {
            return false;
        }
        if (div.isBlockElement()) {
            if (!this.isEmpty()) {
                return false;
            }
            this.remainWidth = 0.0;
            this.add(div, blockSize);
            return true;
        }
        if (!this.isEmpty()) {
            if (this.isCenterFloat()) {
                if (div.getFloat() != AFloat.center) {
                    return false;
                }
                if (Clear.left == div.getClear()) {
                    return false;
                }
                if (Clear.right == this.content.get(this.content.size() - 1).getClear()) {
                    return false;
                }
            } else {
                if (AFloat.left == div.getFloat() && Clear.left == div.getClear()) {
                    for (Div existDiv : this.content) {
                        if (existDiv.getFloat() != AFloat.left) continue;
                        return false;
                    }
                }
                if (AFloat.right == div.getFloat() && Clear.right == div.getClear()) {
                    for (Div existDiv : this.content) {
                        if (existDiv.getFloat() != AFloat.right) continue;
                        return false;
                    }
                }
                if (AFloat.center == div.getFloat()) {
                    return false;
                }
            }
        }
        this.remainWidth -= blockSize.getWidth();
        this.add(div, blockSize);
        return true;
    }

    private void add(Div div, Rectangle blockSize) {
        if (this.height < blockSize.getHeight()) {
            this.height = blockSize.getHeight();
        }
        if (!div.isIntegrity().booleanValue()) {
            this.blockable = true;
        }
        if (div instanceof PageAreaFiller) {
            this.isRemainAreaFiller = true;
        }
        this.content.add(div);
        this.sizeList.add(blockSize);
    }

    public boolean isBlockable() {
        return this.blockable;
    }

    boolean isCenterFloat() {
        if (this.isEmpty()) {
            return true;
        }
        for (Div d : this.content) {
            AFloat aFloat = d.getFloat();
            if (aFloat == AFloat.center) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public boolean isRemainAreaFiller() {
        return this.isRemainAreaFiller;
    }

    public List<Div> getContent() {
        return this.content;
    }

    public List<Rectangle> getSizeList() {
        return this.sizeList;
    }

    @Override
    public Iterator<Map.Entry<Div, Rectangle>> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.cnt < this.content.size()) {
            return true;
        }
        this.cnt = 0;
        return false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public double getWidth() {
        return this.width;
    }

    @Override
    public Map.Entry<Div, Rectangle> next() {
        if (this.cnt == this.content.size()) {
            throw new NoSuchElementException();
        }
        ++this.cnt;
        return new AbstractMap.SimpleEntry<Div, Rectangle>(this.content.get(this.cnt - 1), this.sizeList.get(this.cnt - 1));
    }
}

