/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.ofdrw.core.attachment.Attachments;
import org.ofdrw.core.attachment.CT_Attachment;
import org.ofdrw.core.basicStructure.doc.CT_CommonData;
import org.ofdrw.core.basicStructure.doc.Document;
import org.ofdrw.core.basicStructure.ofd.DocBody;
import org.ofdrw.core.basicStructure.ofd.OFD;
import org.ofdrw.core.basicStructure.ofd.docInfo.CT_DocInfo;
import org.ofdrw.core.basicStructure.pageObj.Page;
import org.ofdrw.core.basicStructure.pageTree.Pages;
import org.ofdrw.core.basicType.ST_ID;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.layout.PageLayout;
import org.ofdrw.layout.StreamCollect;
import org.ofdrw.layout.VirtualPage;
import org.ofdrw.layout.edit.AdditionVPage;
import org.ofdrw.layout.edit.Annotation;
import org.ofdrw.layout.edit.AnnotationRender;
import org.ofdrw.layout.edit.Attachment;
import org.ofdrw.layout.element.Div;
import org.ofdrw.layout.engine.ResManager;
import org.ofdrw.layout.engine.Segment;
import org.ofdrw.layout.engine.SegmentationEngine;
import org.ofdrw.layout.engine.StreamingLayoutAnalyzer;
import org.ofdrw.layout.engine.VPageParseEngine;
import org.ofdrw.layout.exception.DocReadException;
import org.ofdrw.layout.handler.RenderFinishHandler;
import org.ofdrw.pkg.container.DocDir;
import org.ofdrw.pkg.container.OFDDir;
import org.ofdrw.pkg.container.VirtualContainer;
import org.ofdrw.reader.OFDReader;
import org.ofdrw.reader.PageInfo;
import org.ofdrw.reader.ResourceLocator;

public class OFDDoc
implements Closeable {
    private OFDReader reader;
    private OFDDir ofdDir;
    private Path outPath;
    private OutputStream outStream;
    private AtomicInteger MaxUnitID = new AtomicInteger(0);
    ResManager prm;
    private AnnotationRender annotationRender;
    private LinkedList<Div> streamQueue = new LinkedList();
    private LinkedList<VirtualPage> vPageList = new LinkedList();
    private LinkedList<StreamCollect> sPageList = new LinkedList();
    private PageLayout pageLayout = PageLayout.A4();
    private CT_CommonData cdata;
    private boolean closed = false;
    private Document ofdDocument;
    private DocDir operateDocDir;
    private RenderFinishHandler renderingEndHandler;

    public OFDDoc(Path outPath) {
        this();
        if (outPath == null) {
            throw new IllegalArgumentException("OFD\u6587\u4ef6\u5b58\u50a8\u8def\u5f84(outPath)\u4e3a\u7a7a");
        }
        if (Files.isDirectory(outPath, new LinkOption[0])) {
            throw new IllegalArgumentException("OFD\u6587\u4ef6\u5b58\u50a8\u8def\u5f84(outPath)\u4e0d\u80fd\u662f\u76ee\u5f55");
        }
        if (!Files.exists(outPath.getParent(), new LinkOption[0])) {
            throw new IllegalArgumentException("OFD\u6587\u4ef6\u5b58\u50a8\u8def\u5f84(outPath)\u4e0a\u7ea7\u76ee\u5f55 [" + outPath.getParent().toAbsolutePath() + "] \u4e0d\u5b58\u5728");
        }
        this.outPath = outPath;
    }

    public OFDDoc(OutputStream outStream) {
        this();
        if (outStream == null) {
            throw new IllegalArgumentException("OFD\u6587\u4ef6\u8f93\u51fa\u6d41(outStream)\u4e3a\u7a7a");
        }
        this.outStream = outStream;
    }

    public OFDDoc(OFDReader reader, Path outPath) throws DocReadException {
        if (reader == null) {
            throw new IllegalArgumentException("OFD\u89e3\u6790\u5668(reader)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (outPath == null) {
            throw new IllegalArgumentException("OFD\u6587\u4ef6\u5b58\u50a8\u8def\u5f84(outPath)\u4e3a\u7a7a");
        }
        if (Files.isDirectory(outPath, new LinkOption[0])) {
            throw new IllegalArgumentException("OFD\u6587\u4ef6\u5b58\u50a8\u8def\u5f84(outPath)\u4e0d\u80fd\u662f\u76ee\u5f55");
        }
        this.outPath = outPath;
        this.reader = reader;
        try {
            this.containerInit(reader);
        }
        catch (FileNotFoundException | DocumentException e) {
            throw new DocReadException("OFD\u6587\u4ef6\u89e3\u6790\u5f02\u5e38", e);
        }
    }

    public OFDDoc(OFDReader reader, OutputStream outStream) throws DocReadException {
        if (reader == null) {
            throw new IllegalArgumentException("OFD\u89e3\u6790\u5668(reader)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (outStream == null) {
            throw new IllegalArgumentException("OFD\u6587\u4ef6\u8f93\u51fa\u6d41(outStream)\u4e3a\u7a7a");
        }
        this.outStream = outStream;
        this.reader = reader;
        try {
            this.containerInit(reader);
        }
        catch (FileNotFoundException | DocumentException e) {
            throw new DocReadException("OFD\u6587\u4ef6\u89e3\u6790\u5f02\u5e38", e);
        }
    }

    private OFDDoc() {
        this.containerInit();
    }

    public OFDDoc setDefaultPageLayout(PageLayout pageLayout) {
        if (pageLayout == null) {
            return this;
        }
        this.pageLayout = pageLayout;
        this.cdata.setPageArea(pageLayout.getPageArea());
        return this;
    }

    private void containerInit() {
        DocDir docDir;
        CT_DocInfo docInfo = new CT_DocInfo().setDocID(UUID.randomUUID()).setCreationDate(LocalDate.now()).setCreator("OFD R&W").setCreatorVersion("1.17.4");
        DocBody docBody = new DocBody().setDocInfo(docInfo).setDocRoot(new ST_Loc("Doc_0/Document.xml"));
        OFD ofd = new OFD().addDocBody(docBody);
        this.ofdDocument = new Document();
        this.cdata = new CT_CommonData();
        this.setDefaultPageLayout(this.pageLayout);
        this.ofdDocument.setCommonData(this.cdata).setPages(new Pages());
        this.ofdDir = OFDDir.newOFD().setOfd(ofd);
        this.operateDocDir = docDir = this.ofdDir.newDoc();
        docDir.setDocument(this.ofdDocument);
        this.prm = new ResManager(docDir, this.MaxUnitID);
    }

    private void containerInit(OFDReader reader) throws FileNotFoundException, DocumentException {
        this.ofdDir = reader.getOFDDir();
        OFD ofd = this.ofdDir.getOfd();
        DocBody docBody = ofd.getDocBody();
        CT_DocInfo docInfo = docBody.getDocInfo();
        docInfo.setModDate(LocalDate.now());
        ResourceLocator rl = reader.getResourceLocator();
        ST_Loc docRoot = docBody.getDocRoot();
        this.ofdDocument = (Document)rl.get(docRoot, Document::new);
        this.cdata = this.ofdDocument.getCommonData();
        ST_ID maxUnitID = this.cdata.getMaxUnitID();
        this.MaxUnitID = new AtomicInteger(maxUnitID.getId().intValue());
        this.operateDocDir = this.ofdDir.obtainDocDefault();
        this.prm = new ResManager(this.ofdDir.obtainDocDefault(), this.MaxUnitID);
    }

    public OFDDoc add(Div item) {
        if (this.streamQueue.contains(item)) {
            throw new IllegalArgumentException("\u5143\u7d20\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u590d\u653e\u5165");
        }
        this.streamQueue.add(item);
        return this;
    }

    public OFDDoc addVPage(VirtualPage virtualPage) {
        this.vPageList.add(virtualPage);
        return this;
    }

    public OFDDoc addStreamCollect(StreamCollect streamCollect) {
        this.sPageList.add(streamCollect);
        return this;
    }

    public AdditionVPage getAVPage(int pageNum) {
        if (this.reader == null) {
            throw new RuntimeException("\u4ec5\u5728\u4fee\u6539\u6a21\u5f0f\u4e0b\u5141\u8bb8\u83b7\u53d6\u8ffd\u52a0\u9875\u9762\u5bf9\u8c61\uff08AdditionVPage\uff09");
        }
        Page page = this.reader.getPage(pageNum);
        AdditionVPage avp = new AdditionVPage(page);
        this.addVPage(avp);
        return avp;
    }

    public OFDDoc addAnnotation(int pageNum, Annotation annotation) throws IOException {
        if (annotation == null) {
            return this;
        }
        if (this.reader == null) {
            throw new RuntimeException("\u4ec5\u5728\u4fee\u6539\u6a21\u5f0f\u4e0b\u5141\u8bb8\u83b7\u53d6\u8ffd\u52a0\u6ce8\u91ca\u5bf9\u8c61\uff0c\u8bf7\u4f7f\u7528reader\u6784\u9020");
        }
        if (this.annotationRender == null) {
            this.annotationRender = new AnnotationRender(this.reader.getOFDDir().obtainDocDefault(), this.prm, this.MaxUnitID);
        }
        PageInfo pageInfo = this.reader.getPageInfo(pageNum);
        this.annotationRender.render(pageInfo, annotation);
        return this;
    }

    public PageLayout getPageLayout() {
        return this.pageLayout.clone();
    }

    public OFDDoc addAttachment(Attachment attachment) throws IOException {
        if (attachment == null) {
            return this;
        }
        DocDir docDefault = this.ofdDir.obtainDocDefault();
        Path file = attachment.getFile();
        docDefault.addResource(file);
        ST_Loc loc = docDefault.getRes().getAbsLoc().cat(file.getFileName().toString());
        double size = (double)Files.size(file) / 1024.0;
        CT_Attachment ctAttachment = attachment.getAttachment().setID(String.valueOf(this.MaxUnitID.incrementAndGet())).setCreationDate(LocalDate.now()).setSize(Double.valueOf(size)).setFileLoc(loc);
        ResourceLocator rl = new ResourceLocator((VirtualContainer)docDefault);
        Attachments attachments = this.obtainAttachments(docDefault, rl);
        this.cleanOldAttachment(rl, attachments, attachment.getName());
        attachments.addAttachment(ctAttachment);
        return this;
    }

    private void cleanOldAttachment(ResourceLocator rl, Attachments attachments, String name) throws IOException {
        List list = attachments.getAttachments();
        for (CT_Attachment att : list) {
            if (!att.getAttachmentName().equals(name)) continue;
            attachments.remove((Element)att);
            ST_Loc fileLoc = att.getFileLoc();
            Path file = rl.getFile(fileLoc);
            if (file == null || !Files.exists(file, new LinkOption[0])) break;
            Files.delete(file);
            break;
        }
    }

    private Attachments obtainAttachments(DocDir docDir, ResourceLocator rl) {
        ST_Loc attLoc = this.ofdDocument.getAttachments();
        Attachments attachments = null;
        if (attLoc != null) {
            try {
                attachments = (Attachments)rl.get(attLoc, Attachments::new);
                rl.cd(attLoc.parent());
            }
            catch (FileNotFoundException | DocumentException e) {
                System.err.println(">> \u65e0\u6cd5\u89e3\u6790Attachments.xml\u6587\u4ef6\uff0c\u5c06\u91cd\u65b0\u521b\u5efa\u8be5\u6587\u4ef6");
                attachments = null;
            }
        }
        if (attachments == null) {
            attachments = new Attachments();
            docDir.putObj("Attachments.xml", (Element)attachments);
            this.ofdDocument.setAttachments(docDir.getAbsLoc().cat("Attachments.xml"));
        }
        return attachments;
    }

    public OFDDir getOfdDir() {
        return this.ofdDir;
    }

    public Document getOfdDocument() {
        return this.ofdDocument;
    }

    public OFDDoc onRenderFinish(RenderFinishHandler renderFinishHandler) {
        this.renderingEndHandler = renderFinishHandler;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block15: {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                if (!this.streamQueue.isEmpty()) {
                    SegmentationEngine sgmEngine = new SegmentationEngine(this.pageLayout);
                    StreamingLayoutAnalyzer analyzer = new StreamingLayoutAnalyzer(this.pageLayout);
                    List<Segment> sgmQueue = sgmEngine.process(this.streamQueue);
                    List<VirtualPage> virtualPageList = analyzer.analyze(sgmQueue);
                    this.vPageList.addAll(virtualPageList);
                }
                if (!this.sPageList.isEmpty()) {
                    for (StreamCollect sCollect : this.sPageList) {
                        List<VirtualPage> pageList = sCollect.analyze(this.pageLayout);
                        this.vPageList.addAll(pageList);
                    }
                }
                if (!this.vPageList.isEmpty()) {
                    DocDir docDefault = this.ofdDir.obtainDocDefault();
                    VPageParseEngine parseEngine = new VPageParseEngine(this.pageLayout, docDefault, this.prm, this.MaxUnitID);
                    parseEngine.process(this.vPageList);
                }
                if (this.vPageList.isEmpty() && this.annotationRender == null && this.reader == null) {
                    throw new IllegalStateException("OFD\u6587\u6863\u4e2d\u6ca1\u6709\u9875\u9762\uff0c\u65e0\u6cd5\u751f\u6210OFD\u6587\u6863");
                }
                if (this.renderingEndHandler != null) {
                    this.renderingEndHandler.handle(this.MaxUnitID, this.ofdDir, this.operateDocDir.getIndex());
                }
                this.cdata.setMaxUnitID((long)this.MaxUnitID.get());
                if (this.outPath != null) {
                    this.ofdDir.jar(this.outPath.toAbsolutePath());
                    break block15;
                }
                if (this.outStream != null) {
                    this.ofdDir.jar(this.outStream);
                    break block15;
                }
                throw new IllegalArgumentException("OFD\u6587\u6863\u8f93\u51fa\u5730\u5740\u9519\u8bef\u6216\u6ca1\u6709\u8bbe\u7f6e\u8f93\u51fa\u6d41");
            }
            finally {
                if (this.reader != null) {
                    this.reader.close();
                } else if (this.ofdDir != null) {
                    this.ofdDir.clean();
                }
            }
        }
    }
}

