/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.element;

import java.util.LinkedList;
import java.util.List;
import org.ofdrw.font.Font;
import org.ofdrw.layout.Rectangle;
import org.ofdrw.layout.element.TextFontInfo;
import org.ofdrw.layout.element.TxtGlyph;

public class Span
implements TextFontInfo {
    private Font font;
    private Double fontSize = 3.0;
    private Double letterSpacing = 0.0;
    private boolean bold = false;
    private boolean italic = false;
    private boolean underline = false;
    private boolean fill = true;
    private String text;
    private int[] fillColor;
    private boolean linebreak = false;
    private Boolean integrity = false;
    LinkedList<TxtGlyph> txtGlyphsCache = null;

    protected Span() {
        this.setFont(Font.getDefault());
    }

    public Span(Font font, Double fontSize, String text) {
        this.font = font;
        this.fontSize = fontSize;
        this.setText(text);
    }

    public Span(String text) {
        this();
        if (text == null) {
            throw new IllegalArgumentException("text\u5185\u5bb9\u4e3a\u7a7a");
        }
        this.setText(text);
    }

    public int[] getColor() {
        return this.fillColor;
    }

    public Span setColor(int[] rgb) {
        this.fillColor = rgb;
        return this;
    }

    public Span setColor(int r, int g, int b) {
        this.fillColor = new int[]{r, g, b};
        return this;
    }

    public int length() {
        return this.text.length();
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    public Span setFont(Font font) {
        this.font = font;
        return this;
    }

    @Override
    public Double getFontSize() {
        return this.fontSize;
    }

    public Span setFontSize(Double fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    @Override
    public Double getLetterSpacing() {
        return this.letterSpacing;
    }

    public Span setLetterSpacing(Double letterSpacing) {
        this.letterSpacing = letterSpacing;
        return this;
    }

    public boolean isBold() {
        return this.bold;
    }

    public Span setBold(boolean bold) {
        this.bold = bold;
        return this;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public Span setItalic(boolean italic) {
        this.italic = italic;
        return this;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public Span setUnderline(boolean underline) {
        this.underline = underline;
        return this;
    }

    public Boolean isFill() {
        return this.fill;
    }

    public Span setFill(boolean fill) {
        this.fill = fill;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public Span setText(String text) {
        this.text = text;
        if (this.txtGlyphsCache != null) {
            this.glyphList();
        }
        return this;
    }

    public Boolean isIntegrity() {
        if (this.text == null || this.text.length() <= 1) {
            this.integrity = true;
        }
        return this.integrity;
    }

    public Span setIntegrity(Boolean integrity) {
        this.integrity = integrity;
        return this;
    }

    public List<TxtGlyph> glyphList() {
        if (this.txtGlyphsCache == null) {
            this.txtGlyphsCache = new LinkedList();
            for (char c : this.text.toCharArray()) {
                this.txtGlyphsCache.add(new TxtGlyph(c, this));
            }
        }
        return this.txtGlyphsCache;
    }

    public Double[] getDeltaX() {
        List<TxtGlyph> list = this.glyphList();
        int len = list.size();
        if (len == 1) {
            return new Double[0];
        }
        Double[] res = new Double[len - 1];
        for (int i = 0; i < len - 1; ++i) {
            res[i] = list.get(i).getW();
        }
        return res;
    }

    public Rectangle blockSize() {
        List<TxtGlyph> txtGlyphs = this.glyphList();
        double width = 0.0;
        double height = 0.0;
        for (TxtGlyph glyph : txtGlyphs) {
            width += glyph.getW();
            height = glyph.getH();
        }
        return new Rectangle(width, height);
    }

    public Span[] split(int index) {
        if (index < 0 || index >= this.text.length()) {
            throw new IllegalArgumentException("\u975e\u6cd5\u7684\u5207\u5206\u6570\u7ec4\u5750\u6807(index): " + index);
        }
        Span s1 = this.clone().setText(this.text.substring(0, index));
        Span s2 = this.clone().setText(this.text.substring(index));
        return new Span[]{s1, s2};
    }

    public Span setLinebreak(boolean linebreak) {
        this.linebreak = linebreak;
        return this;
    }

    public boolean hasLinebreak() {
        return this.linebreak;
    }

    public LinkedList<Span> splitLineBreak() {
        LinkedList<Span> res = new LinkedList<Span>();
        if (!this.text.contains("\n")) {
            res.add(this);
        } else {
            String[] split = this.text.split("\n");
            for (int i = 0; i < split.length; ++i) {
                Span lineSpan = this.clone().setText(split[i]);
                if (i != split.length - 1) {
                    lineSpan.setLinebreak(true);
                } else if (this.text.endsWith("\n")) {
                    lineSpan.setLinebreak(true);
                }
                res.add(lineSpan);
            }
        }
        return res;
    }

    public Span clone() {
        Span span = new Span();
        span.font = this.font;
        span.fontSize = this.fontSize;
        span.letterSpacing = this.letterSpacing;
        span.bold = this.bold;
        span.italic = this.italic;
        span.underline = this.underline;
        span.fill = this.fill;
        span.text = new String(this.text);
        span.integrity = this.integrity;
        span.linebreak = this.linebreak;
        span.fillColor = this.fillColor == null ? null : (int[])this.fillColor.clone();
        return span;
    }
}

