/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.engine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.dom4j.DocumentException;
import org.ofdrw.core.OFDElement;
import org.ofdrw.core.basicStructure.doc.Document;
import org.ofdrw.core.basicStructure.res.CT_MultiMedia;
import org.ofdrw.core.basicStructure.res.MediaType;
import org.ofdrw.core.basicStructure.res.OFDResource;
import org.ofdrw.core.basicStructure.res.Res;
import org.ofdrw.core.basicStructure.res.resources.ColorSpaces;
import org.ofdrw.core.basicStructure.res.resources.CompositeGraphicUnits;
import org.ofdrw.core.basicStructure.res.resources.DrawParams;
import org.ofdrw.core.basicStructure.res.resources.Fonts;
import org.ofdrw.core.basicStructure.res.resources.MultiMedias;
import org.ofdrw.core.basicType.ST_ID;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.core.compositeObj.CT_VectorG;
import org.ofdrw.core.pageDescription.color.colorSpace.CT_ColorSpace;
import org.ofdrw.core.pageDescription.drawParam.CT_DrawParam;
import org.ofdrw.core.text.font.CT_Font;
import org.ofdrw.font.Font;
import org.ofdrw.pkg.container.DocDir;

public class ResManager {
    private AtomicInteger maxUnitID;
    private DocDir docDir;
    private MultiMedias medias;
    private DrawParams drawParams;
    private Fonts fonts;
    private ColorSpaces colorSpaces;
    private CompositeGraphicUnits compositeGraphicUnits;
    private Map<String, OFDElement> cache;

    private ResManager() {
    }

    public ResManager(DocDir docDir, AtomicInteger maxUnitID) {
        this.docDir = docDir;
        this.maxUnitID = maxUnitID;
        this.cache = new HashMap<String, OFDElement>();
        this.reloadCache();
    }

    private void reloadCache() {
        try {
            Res docRes = this.docDir.getPublicRes();
            for (Fonts f : docRes.getFonts()) {
                f.getFonts().forEach(item -> {
                    String completeFontName = item.getFontName();
                    String familyName = item.getFamilyName();
                    if (familyName != null && familyName.length() > 0) {
                        completeFontName = completeFontName + "-" + familyName;
                    }
                    this.cache.put(completeFontName, (OFDElement)item);
                });
            }
        }
        catch (FileNotFoundException docRes) {
        }
        catch (DocumentException e) {
            throw new RuntimeException("\u5df2\u6709DocumentRes.xml \u8d44\u6e90\u6587\u4ef6\u89e3\u6790\u5931\u8d25", e);
        }
    }

    public ST_ID addFont(Font font) throws IOException {
        Res resMenu = this.pubRes();
        String completeFontName = font.getCompleteFontName();
        if (this.cache.get(completeFontName) == null) {
            if (this.fonts == null) {
                this.fonts = new Fonts();
                resMenu.addResource((OFDResource)this.fonts);
            }
            ST_ID id = new ST_ID((long)this.maxUnitID.incrementAndGet());
            String familyName = font.getFamilyName();
            CT_Font ctFont = new CT_Font().setFontName(font.getName()).setFamilyName(familyName).setID(id);
            Path fontFile = font.getFontFile();
            if (fontFile != null) {
                ctFont.setFontFile(fontFile.getFileName().toString());
            }
            if (familyName != null) {
                switch (familyName.toLowerCase()) {
                    case "serif": {
                        ctFont.setSerif(Boolean.valueOf(true));
                        break;
                    }
                    case "bold": {
                        ctFont.setBold(Boolean.valueOf(true));
                        break;
                    }
                    case "italic": {
                        ctFont.setItalic(Boolean.valueOf(true));
                        break;
                    }
                    case "fixedwidth": {
                        ctFont.setFixedWidth(Boolean.valueOf(true));
                    }
                }
            }
            if (fontFile != null) {
                this.docDir.addResource(fontFile);
            }
            this.fonts.addFont(ctFont);
            this.cache.put(completeFontName, (OFDElement)ctFont);
            return id;
        }
        return this.cache.get(completeFontName).getObjID();
    }

    public ST_ID addImage(Path imgPath) throws IOException {
        Res resMenu = this.docRes();
        String absPath = imgPath.toAbsolutePath().toString();
        String fileName = imgPath.getFileName().toString();
        if (this.cache.get(absPath) == null) {
            if (this.medias == null) {
                this.medias = new MultiMedias();
                resMenu.addResource((OFDResource)this.medias);
            }
            ST_ID id = new ST_ID((long)this.maxUnitID.incrementAndGet());
            String fileSuffix = this.pictureFormat(fileName);
            this.docDir.addResource(imgPath);
            CT_MultiMedia multiMedia = new CT_MultiMedia().setType(MediaType.Image).setFormat(fileSuffix).setMediaFile(ST_Loc.getInstance((String)fileName)).setID(id);
            this.medias.addMultiMedia(multiMedia);
            this.cache.put(absPath, (OFDElement)multiMedia);
            return id;
        }
        return this.cache.get(absPath).getObjID();
    }

    public ST_ID addDrawParam(CT_DrawParam param) {
        Res resMenu = this.docRes();
        if (this.drawParams == null) {
            this.drawParams = new DrawParams();
            resMenu.addResource((OFDResource)this.drawParams);
        }
        ST_ID id = new ST_ID((long)this.maxUnitID.incrementAndGet());
        param.setID(id);
        this.drawParams.addDrawParam(param);
        return id;
    }

    private String pictureFormat(String fileName) {
        String fileSuffix;
        switch (fileSuffix = fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase()) {
            case "JPG": {
                return "JPEG";
            }
            case "TIF": {
                return "TIFF";
            }
        }
        return fileSuffix;
    }

    public Res pubRes() {
        try {
            return this.docDir.getPublicRes();
        }
        catch (FileNotFoundException | DocumentException e) {
            Res publicRes = new Res().setBaseLoc(ST_Loc.getInstance((String)"Res"));
            this.docDir.setPublicRes(publicRes);
            this.document().getCommonData().setPublicRes(ST_Loc.getInstance((String)"PublicRes.xml"));
            return publicRes;
        }
    }

    private Document document() {
        try {
            return this.docDir.getDocument();
        }
        catch (FileNotFoundException | DocumentException ex) {
            throw new RuntimeException("\u6587\u6863\u4e2d\u7f3a\u5c11Document.xml \u6587\u4ef6");
        }
    }

    public Res docRes() {
        try {
            return this.docDir.getDocumentRes();
        }
        catch (FileNotFoundException | DocumentException e) {
            Res docRes = new Res().setBaseLoc(ST_Loc.getInstance((String)"Res"));
            this.docDir.setDocumentRes(docRes);
            this.document().getCommonData().setDocumentRes(ST_Loc.getInstance((String)"DocumentRes.xml"));
            return docRes;
        }
    }

    public ResManager addRaw(OFDElement resObj) {
        if (resObj == null) {
            return this;
        }
        Res resMenu = this.docRes();
        if (resObj instanceof CT_ColorSpace) {
            if (this.colorSpaces == null) {
                this.colorSpaces = new ColorSpaces();
                resMenu.addResource((OFDResource)this.colorSpaces);
            }
            this.colorSpaces.addColorSpace((CT_ColorSpace)resObj);
        } else if (resObj instanceof CT_DrawParam) {
            if (this.drawParams == null) {
                this.drawParams = new DrawParams();
                resMenu.addResource((OFDResource)this.drawParams);
            }
            this.drawParams.addDrawParam((CT_DrawParam)resObj);
        } else if (resObj instanceof CT_Font) {
            if (this.fonts == null) {
                this.fonts = new Fonts();
                resMenu.addResource((OFDResource)this.fonts);
            }
            this.fonts.addFont((CT_Font)resObj);
        } else if (resObj instanceof CT_MultiMedia) {
            if (this.medias == null) {
                this.medias = new MultiMedias();
                resMenu.addResource((OFDResource)this.medias);
            }
            this.medias.addMultiMedia((CT_MultiMedia)resObj);
        } else if (resObj instanceof CT_VectorG) {
            if (this.compositeGraphicUnits == null) {
                this.compositeGraphicUnits = new CompositeGraphicUnits();
                resMenu.addResource((OFDResource)this.compositeGraphicUnits);
            }
            this.compositeGraphicUnits.addCompositeGraphicUnit((CT_VectorG)resObj);
        }
        return this;
    }
}

