/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout;

import java.util.Arrays;
import org.ofdrw.core.basicStructure.doc.CT_PageArea;
import org.ofdrw.layout.Rectangle;
import org.ofdrw.layout.element.ArrayParamTool;

public class PageLayout {
    Double width;
    Double height;
    private Double[] margin = new Double[]{25.4, 31.7, 25.4, 31.7};

    public static PageLayout A0() {
        return new PageLayout(841.0, 1189.0);
    }

    public static PageLayout A1() {
        return new PageLayout(594.0, 841.0);
    }

    public static PageLayout A2() {
        return new PageLayout(420.0, 594.0);
    }

    public static PageLayout A3() {
        return new PageLayout(297.0, 420.0);
    }

    public static PageLayout A4() {
        return new PageLayout(210.0, 297.0);
    }

    public static PageLayout A5() {
        return new PageLayout(148.0, 210.0);
    }

    public static PageLayout A6() {
        return new PageLayout(105.0, 148.0);
    }

    public static PageLayout A7() {
        return new PageLayout(74.0, 105.0);
    }

    public static PageLayout A8() {
        return new PageLayout(52.0, 74.0);
    }

    public static PageLayout A9() {
        return new PageLayout(37.0, 52.0);
    }

    public static PageLayout A10() {
        return new PageLayout(26.0, 37.0);
    }

    public PageLayout(Double width, Double height) {
        this.width = width;
        this.height = height;
    }

    public Double getWidth() {
        return this.width;
    }

    public PageLayout setWidth(Double width) {
        this.width = width;
        return this;
    }

    public Double getHeight() {
        return this.height;
    }

    public PageLayout setHeight(Double height) {
        this.height = height;
        return this;
    }

    public Double[] getMargin() {
        return this.margin;
    }

    public PageLayout setMargin(Double ... margin) {
        this.margin = ArrayParamTool.arr4p(margin);
        return this;
    }

    public PageLayout setMarginTop(double top) {
        this.margin[0] = top;
        return this;
    }

    public double getMarginTop() {
        return this.margin[0];
    }

    public PageLayout setMarginRight(double right) {
        this.margin[1] = right;
        return this;
    }

    public double getMarginRight() {
        return this.margin[1];
    }

    public PageLayout setMarginBottom(double bottom) {
        this.margin[2] = bottom;
        return this;
    }

    public double getMarginBottom() {
        return this.margin[2];
    }

    public PageLayout setMarginLeft(double left) {
        this.margin[3] = left;
        return this;
    }

    public double getMarginLeft() {
        return this.margin[3];
    }

    public double contentWidth() {
        return this.width - this.getMarginLeft() - this.getMarginRight();
    }

    public double contentHeight() {
        return this.height - this.getMarginTop() - this.getMarginBottom();
    }

    public double getStartX() {
        return this.getMarginLeft();
    }

    public double getStartY() {
        return this.getMarginTop();
    }

    public Rectangle getWorkerArea() {
        return new Rectangle(this.getStartX(), this.getStartY(), this.contentWidth(), this.contentHeight());
    }

    public CT_PageArea getPageArea() {
        return new CT_PageArea().setPhysicalBox(0.0, 0.0, this.getWidth().doubleValue(), this.getHeight().doubleValue()).setApplicationBox(0.0, 0.0, this.getWidth().doubleValue(), this.getHeight().doubleValue());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PageLayout) {
            PageLayout that = (PageLayout)obj;
            return Arrays.equals((Object[])this.margin, (Object[])that.margin) && this.width.equals(that.width) && this.height.equals(that.height);
        }
        return false;
    }
}

