/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.engine.render;

import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.ofdrw.core.basicStructure.pageObj.layer.PageBlockType;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CT_PageBlock;
import org.ofdrw.core.basicStructure.pageObj.layer.block.PathObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.TextObject;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.basicType.ST_ID;
import org.ofdrw.core.graph.pathObj.AbbreviatedData;
import org.ofdrw.core.graph.pathObj.CT_Path;
import org.ofdrw.core.pageDescription.color.color.CT_Color;
import org.ofdrw.core.text.TextCode;
import org.ofdrw.core.text.text.CT_Text;
import org.ofdrw.core.text.text.Weight;
import org.ofdrw.layout.element.Paragraph;
import org.ofdrw.layout.element.PlaceholderSpan;
import org.ofdrw.layout.element.Span;
import org.ofdrw.layout.element.TxtLineBlock;
import org.ofdrw.layout.engine.ResManager;
import org.ofdrw.layout.engine.render.RenderException;

public class ParagraphRender {
    public static void render(CT_PageBlock layer, ResManager resManager, Paragraph e, AtomicInteger maxUnitID) {
        if (e == null) {
            return;
        }
        LinkedList<TxtLineBlock> lines = e.getLines();
        if (lines == null || lines.isEmpty()) {
            e.doPrepare(e.getWidth() + e.widthPlus());
            lines = e.getLines();
            if (lines == null || lines.isEmpty()) {
                return;
            }
        }
        Double containerHeight = e.getHeight();
        double lineTopX = e.getX() + e.getMarginLeft() + e.getBorderLeft() + e.getPaddingLeft();
        double offsetY = e.getY() + e.getMarginTop() + e.getBorderTop() + e.getPaddingTop();
        double hCount = 0.0;
        for (TxtLineBlock txtLine : lines) {
            double offsetX = lineTopX;
            double h = txtLine.getHeight();
            if (hCount + h > containerHeight) break;
            for (Span s : txtLine.getInlineSpans()) {
                int[] color;
                double w = s.blockSize().getWidth();
                if (w == 0.0) continue;
                if (s instanceof PlaceholderSpan) {
                    offsetX += w;
                    continue;
                }
                ST_ID id = null;
                try {
                    id = resManager.addFont(s.getFont());
                }
                catch (IOException ex) {
                    throw new RenderException("\u6e32\u67d3\u5f02\u5e38\uff0c\u5b57\u4f53\u590d\u5236\u5931\u8d25\uff1a" + ex.getMessage(), ex);
                }
                TextObject txtObj = new TextObject((long)maxUnitID.incrementAndGet());
                ST_Box boundary = new ST_Box(offsetX, offsetY, w, h);
                ((CT_Text)txtObj.setBoundary(boundary)).setFont(id.ref()).setSize(s.getFontSize());
                if (s.isBold()) {
                    txtObj.setWeight(Weight.W_800);
                }
                if (s.isItalic()) {
                    txtObj.setItalic(Boolean.valueOf(true));
                }
                if (!s.isFill().booleanValue()) {
                    txtObj.setFill(Boolean.valueOf(false));
                }
                if ((color = s.getColor()) != null && color.length >= 3) {
                    txtObj.setFillColor(CT_Color.rgb((int[])color));
                }
                Double offset = txtLine.getMaxSpanHeight();
                TextCode tcSTTxt = new TextCode().setCoordinate(Double.valueOf(0.0), offset).setContent(s.getText());
                Double[] deltaX = s.getDeltaX();
                if (deltaX.length > 0) {
                    tcSTTxt.setDeltaX(deltaX);
                }
                txtObj.addTextCode(tcSTTxt);
                if (e.getOpacity() != null) {
                    txtObj.setAlpha(Integer.valueOf((int)(e.getOpacity() * 255.0)));
                }
                layer.addPageBlock((PageBlockType)txtObj);
                if (s.isUnderline()) {
                    ST_ID underlineId = new ST_ID((long)maxUnitID.incrementAndGet());
                    PathObject underline = ParagraphRender.drawUnderline(underlineId, boundary, offset);
                    if (e.getOpacity() != null) {
                        underline.setAlpha(Integer.valueOf((int)(e.getOpacity() * 255.0)));
                    }
                    layer.addPageBlock((PageBlockType)underline);
                }
                offsetX += w;
            }
            offsetY += h;
            hCount += h;
        }
    }

    private static PathObject drawUnderline(ST_ID id, ST_Box boundary, double offset) {
        PathObject res = new PathObject(id);
        ((CT_Path)res.setBoundary(boundary)).setAbbreviatedData(new AbbreviatedData().M(0.0, offset += 1.2).lineTo(boundary.getWidth().doubleValue(), offset)).setLineWidth(Double.valueOf(0.353));
        return res;
    }
}

