/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.areaholder;

import java.io.FileNotFoundException;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.ofdrw.core.basicStructure.pageObj.Page;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CT_PageBlock;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.core.basicType.ST_RefID;
import org.ofdrw.layout.OFDDoc;
import org.ofdrw.layout.areaholder.AreaHolderBlocks;
import org.ofdrw.layout.areaholder.AreaHolderBlocksProcess;
import org.ofdrw.layout.areaholder.CT_AreaHolderBlock;
import org.ofdrw.layout.edit.AdditionVPage;
import org.ofdrw.layout.element.canvas.Canvas;
import org.ofdrw.layout.element.canvas.CellContentDrawer;
import org.ofdrw.pkg.container.DocDir;
import org.ofdrw.reader.ResourceLocator;

public class AreaHolderContext {
    private final OFDDoc doc;
    private final DocDir docDir;
    private final ResourceLocator rl;

    public AreaHolderContext(OFDDoc doc, int n) throws FileNotFoundException {
        this.rl = new ResourceLocator(doc.getOfdDir());
        this.doc = doc;
        this.docDir = doc.getOfdDir().getDocByIndex(n);
    }

    public AreaHolderContext(OFDDoc doc) {
        this.rl = new ResourceLocator(doc.getOfdDir());
        this.doc = doc;
        this.docDir = doc.getOfdDir().obtainDocDefault();
    }

    public CellContentDrawer getCell(String areaName) {
        if (areaName == null) {
            return null;
        }
        Canvas canvas = this.get(areaName);
        return new CellContentDrawer(canvas);
    }

    public Canvas get(String areaName) {
        if (!AreaHolderBlocksProcess.exist(this.docDir)) {
            return null;
        }
        try {
            AreaHolderBlocks areaHolderBlocks = AreaHolderBlocksProcess.get(this.docDir);
            CT_AreaHolderBlock holder = AreaHolderBlocksProcess.find(areaHolderBlocks, areaName);
            if (holder == null) {
                return null;
            }
            ST_RefID blockId = holder.getPageBlockID();
            ST_Loc pageLoc = holder.getFontFile();
            ST_Box boundary = holder.getBoundary();
            if (blockId == null || pageLoc == null || boundary == null) {
                return null;
            }
            if (boundary.getHeight() <= 0.0 || boundary.getWidth() <= 0.0) {
                return null;
            }
            Page page = null;
            try {
                page = (Page)this.rl.get(pageLoc, Page::new);
            }
            catch (FileNotFoundException | DocumentException e) {
                return null;
            }
            if (page == null) {
                return null;
            }
            Element element = (Element)page.selectSingleNode("//*[@ID='" + blockId.toString() + "']");
            if (element == null) {
                return null;
            }
            CT_PageBlock block = new CT_PageBlock(element);
            Canvas canvas = new Canvas(boundary.getTopLeftX(), boundary.getTopLeftY(), boundary.getWidth(), boundary.getHeight());
            canvas.setPreferBlock(block);
            AdditionVPage virtualPage = new AdditionVPage(page, pageLoc);
            virtualPage.add(canvas);
            this.doc.addVPage(virtualPage);
            return canvas;
        }
        catch (FileNotFoundException | DocumentException e) {
            throw new IllegalArgumentException("\u533a\u57df\u5360\u4f4d\u533a\u5757\u5217\u8868\u6587\u4ef6\u83b7\u53d6\u5931\u8d25 ", e);
        }
    }
}

