/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.engine.render;

import java.io.FileNotFoundException;
import java.util.concurrent.atomic.AtomicInteger;
import org.dom4j.DocumentException;
import org.ofdrw.core.basicStructure.pageObj.layer.PageBlockType;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CT_PageBlock;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.basicType.ST_ID;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.layout.areaholder.AreaHolderBlocks;
import org.ofdrw.layout.areaholder.AreaHolderBlocksProcess;
import org.ofdrw.layout.areaholder.CT_AreaHolderBlock;
import org.ofdrw.layout.element.AreaHolderBlock;
import org.ofdrw.layout.engine.render.RenderException;
import org.ofdrw.pkg.container.DocDir;

public class AreaHolderBlockRender {
    public static void render(DocDir docDir, ST_Loc pageLoc, CT_PageBlock layer, AreaHolderBlock ahBlock, AtomicInteger maxUnitID) throws RenderException {
        CT_PageBlock block = new CT_PageBlock();
        ST_ID objId = new ST_ID((long)maxUnitID.incrementAndGet());
        block.setObjID(objId);
        layer.addPageBlock((PageBlockType)block);
        try {
            Double[] border = ahBlock.getBorder();
            Double[] padding = ahBlock.getPadding();
            AreaHolderBlocks blocks = AreaHolderBlocksProcess.obtian(docDir);
            ST_Box boundary = new ST_Box(ahBlock.getX() + border[0] + padding[0], ahBlock.getY() + border[1] + padding[1], ahBlock.getWidth().doubleValue(), ahBlock.getHeight().doubleValue());
            CT_AreaHolderBlock obj = new CT_AreaHolderBlock(ahBlock.getAreaName()).setBoundary(boundary).setPageFile(pageLoc).setPageBlockID(objId.ref());
            obj.setObjID(maxUnitID.incrementAndGet());
            blocks.addAreaHolderBlock(obj);
        }
        catch (FileNotFoundException | DocumentException e) {
            throw new RenderException("\u533a\u57df\u5360\u4f4d\u533a\u5757\u5217\u8868\u6587\u4ef6\u83b7\u53d6\u5931\u8d25 ", e);
        }
    }
}

