/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.edit;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.ofdrw.core.basicType.STBase;
import org.ofdrw.layout.edit.Annotation;
import org.ofdrw.layout.element.canvas.DrawContext;
import org.ofdrw.layout.element.canvas.Drawer;
import org.ofdrw.layout.element.canvas.TextMetrics;

public class WatermarkDrawer
implements Drawer {
    boolean DEBUG = false;
    private String value;
    private Annotation annotation;
    private Path extFontPath = null;
    private String color = "#000000";
    private String fontName = "\u5b8b\u4f53";
    private double fontSize = 4.5;
    private Boolean bold = false;
    private String fontWeight = "normal";
    private Boolean italic = false;
    private Double letterSpacing = 0.0;
    private Double globalAlpha = 0.5;
    private Double angle = 330.0;
    private Double intervalX = 30.0;
    private Double intervalY = 30.0;

    @Override
    public void draw(DrawContext ctx) throws IOException {
        if (this.value == null || this.value.isEmpty()) {
            return;
        }
        if (this.annotation == null) {
            return;
        }
        if (this.extFontPath != null) {
            ctx.addFont(this.fontName, this.extFontPath);
        }
        ctx.fillStyle = this.color;
        ctx.font = this.getFont();
        if (this.letterSpacing != 0.0) {
            ctx.getFont().setLetterSpacing(this.letterSpacing);
        }
        if (this.color != null && !this.color.isEmpty()) {
            ctx.fillStyle = this.color;
        }
        double width = this.annotation.getBoundary().getWidth();
        double height = this.annotation.getBoundary().getHeight();
        TextMetrics metrics = ctx.measureText(this.value);
        for (double x = this.annotation.getBoundary().getTopLeftX().doubleValue(); x < width; x += this.intervalX.doubleValue()) {
            for (double y = this.annotation.getBoundary().getTopLeftY().doubleValue(); y < height; y += this.intervalY.doubleValue()) {
                ctx.save();
                ctx.setGlobalAlpha(this.globalAlpha);
                ctx.translate(x, y);
                ctx.rotate(this.angle);
                ctx.fillText(this.value, 0.0, metrics.fontSize);
                ctx.restore();
                if (!this.isDEBUG()) continue;
                this.debugBorder(ctx, metrics, x, y);
            }
        }
    }

    private String getFont() {
        String fontStr = "";
        if (this.italic.booleanValue()) {
            fontStr = fontStr + "italic ";
        }
        if (this.bold.booleanValue()) {
            fontStr = fontStr + "bold ";
        } else if (this.fontWeight != null && !this.fontWeight.isEmpty()) {
            fontStr = fontStr + this.fontWeight + " ";
        }
        fontStr = fontStr + STBase.fmt((double)this.fontSize) + "mm " + this.fontName;
        return fontStr;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(double fontSize) {
        this.fontSize = fontSize;
    }

    public Boolean getBold() {
        return this.bold;
    }

    public void setBold(Boolean bold) {
        this.bold = bold;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(String fontWeight) {
        this.fontWeight = fontWeight;
    }

    public Boolean getItalic() {
        return this.italic;
    }

    public void setItalic(Boolean italic) {
        this.italic = italic;
    }

    public Double getLetterSpacing() {
        return this.letterSpacing;
    }

    public void setLetterSpacing(Double letterSpacing) {
        this.letterSpacing = letterSpacing;
    }

    public Double getGlobalAlpha() {
        return this.globalAlpha;
    }

    public void setGlobalAlpha(Double globalAlpha) {
        if (globalAlpha > 1.0 || globalAlpha < 0.0) {
            throw new IllegalArgumentException("\u900f\u660e\u5ea6\u8d85\u51fa\u8303\u56f40.0~1.0");
        }
        this.globalAlpha = globalAlpha;
    }

    public Double getAngle() {
        return this.angle;
    }

    public void setAngle(Double angle) {
        if (angle > 360.0 || angle < -360.0) {
            throw new IllegalArgumentException("\u65cb\u8f6c\u89d2\u5ea6\u8d85\u51fa\u8303\u56f4");
        }
        if (angle < 0.0) {
            angle = 360.0 + angle;
        }
        this.angle = angle;
    }

    public Double getIntervalX() {
        return this.intervalX;
    }

    public void setIntervalX(Double intervalX) {
        this.intervalX = intervalX;
    }

    public Double getIntervalY() {
        return this.intervalY;
    }

    public void setIntervalY(Double intervalY) {
        this.intervalY = intervalY;
    }

    public boolean isDEBUG() {
        return this.DEBUG;
    }

    public void setDEBUG(boolean DEBUG) {
        this.DEBUG = DEBUG;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(Annotation annotation) {
        this.annotation = annotation;
    }

    public WatermarkDrawer setFont(String fontName, Path fontPath) {
        if (fontName == null || fontName.isEmpty()) {
            throw new IllegalArgumentException("\u5b57\u4f53\u540d\u79f0(fontName)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (fontPath == null || !Files.exists(fontPath, new LinkOption[0])) {
            throw new IllegalArgumentException("\u5b57\u4f53\u6587\u4ef6(fontPath)\u4e0d\u5b58\u5728");
        }
        this.setFontName(fontName);
        this.extFontPath = fontPath;
        return null;
    }

    private void debugBorder(DrawContext ctx, TextMetrics metrics, double offsetX, double offsetY) {
        double lineWidth = 0.353;
        double width = metrics.width + lineWidth * 2.0;
        double height = metrics.fontSize + lineWidth * 2.0;
        ctx.save();
        ctx.translate(offsetX, offsetY);
        ctx.setLineDash(1.5, 1.5);
        ctx.setLineWidth(lineWidth);
        ctx.setGlobalAlpha(0.53);
        ctx.strokeStyle = "rgb(255,0,0)";
        ctx.moveTo(0.0, 0.0);
        ctx.lineTo(width, height);
        ctx.moveTo(width, 0.0);
        ctx.lineTo(0.0, height);
        ctx.rotate(this.angle);
        ctx.rect(offsetX, offsetY, width, height);
        ctx.stroke();
        ctx.restore();
    }
}

