/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.element.canvas;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.ofdrw.layout.element.canvas.FontSetting;
import org.ofdrw.layout.element.canvas.MeasureBody;
import org.ofdrw.layout.element.canvas.TextMetricsArea;

public final class TextMeasureTool {
    public static MeasureBody measureWithWith(String text, FontSetting fontSetting) {
        MeasureBody body = new MeasureBody();
        if (text.length() == 0) {
            return body;
        }
        int readDirection = fontSetting.getReadDirection();
        int charDirection = fontSetting.getCharDirection();
        char firstChar = text.charAt(0);
        char lastChar = text.charAt(text.length() - 1);
        Double fontSize = fontSetting.getFontSize();
        if (readDirection == 0) {
            if (charDirection == 0) {
                body.offset = TextMeasureTool.offset(text, fontSetting, 0, "W", 1);
                body.with(fontSetting.charWidth(lastChar));
            } else if (charDirection == 180) {
                body.offset = TextMeasureTool.offset(text, fontSetting, 1, "W", 1);
                body.with(fontSetting.charWidth(firstChar));
                body.firstCharOffsetX = fontSetting.charWidth(firstChar);
                body.firstCharOffsetY = -fontSize.doubleValue();
            } else if (charDirection == 90 || charDirection == 270) {
                body.offset = TextMeasureTool.offset(text, fontSetting, 0, "H", 1);
                body.with(fontSize);
                if (charDirection == 90) {
                    body.firstCharOffsetY = -fontSize.doubleValue();
                } else {
                    body.firstCharOffsetX = fontSize;
                }
            }
        } else if (readDirection == 180) {
            if (charDirection == 0) {
                body.offset = TextMeasureTool.offset(text, fontSetting, 1, "W", -1);
                body.with(fontSetting.charWidth(firstChar));
                body.firstCharOffsetX = -fontSetting.charWidth(firstChar).doubleValue();
            } else if (charDirection == 180) {
                body.offset = TextMeasureTool.offset(text, fontSetting, 0, "W", -1);
                body.with(fontSetting.charWidth(lastChar));
                body.firstCharOffsetY = -fontSize.doubleValue();
            } else if (charDirection == 90 || charDirection == 270) {
                body.offset = TextMeasureTool.offset(text, fontSetting, 0, "H", -1);
                body.with(fontSize);
                if (charDirection == 90) {
                    body.firstCharOffsetX = -fontSize.doubleValue();
                    body.firstCharOffsetY = -fontSize.doubleValue();
                }
            }
        } else if (readDirection == 90) {
            if (charDirection == 0 || charDirection == 180) {
                body.offset = TextMeasureTool.offset(text, fontSetting, 0, "H", 1);
                body.with(fontSize);
                if (charDirection == 0) {
                    body.firstCharOffsetY = fontSize;
                } else {
                    body.firstCharOffsetX = fontSize;
                }
            } else if (charDirection == 90) {
                body.offset = TextMeasureTool.offset(text, fontSetting, 0, "W", 1);
                body.with(fontSetting.charWidth(lastChar));
            } else if (charDirection == 270) {
                body.offset = TextMeasureTool.offset(text, fontSetting, 1, "W", 1);
                body.with(fontSetting.charWidth(firstChar));
                body.firstCharOffsetX = fontSize;
                body.firstCharOffsetY = fontSetting.charWidth(firstChar);
            }
        } else if (readDirection == 270) {
            if (charDirection == 0 || charDirection == 180) {
                body.offset = TextMeasureTool.offset(text, fontSetting, 0, "H", -1);
                body.with(fontSize);
                if (charDirection == 180) {
                    body.firstCharOffsetX = fontSize;
                    body.firstCharOffsetY = -fontSize.doubleValue();
                }
            } else if (charDirection == 90) {
                body.offset = TextMeasureTool.offset(text, fontSetting, 1, "W", -1);
                body.with(fontSetting.charWidth(firstChar));
                body.firstCharOffsetY = -fontSetting.charWidth(firstChar).doubleValue();
            } else if (charDirection == 270) {
                body.offset = TextMeasureTool.offset(text, fontSetting, 0, "W", -1);
                body.with(fontSetting.charWidth(lastChar));
                body.firstCharOffsetX = fontSize;
            }
        }
        return body;
    }

    public static Double[] measure(String text, FontSetting fontSetting) {
        return TextMeasureTool.measureWithWith((String)text, (FontSetting)fontSetting).offset;
    }

    public static TextMetricsArea measureArea(String text, FontSetting fontSetting) {
        TextMetricsArea area = new TextMetricsArea();
        area.charAreas = new ArrayList<Rectangle2D>(text.length());
        area.width = 0.0;
        area.height = 0.0;
        int readDirection = fontSetting.getReadDirection();
        int charDirection = fontSetting.getCharDirection();
        double width = 0.0;
        double height = 0.0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            Rectangle2D box = fontSetting.box(c);
            if (readDirection == 0 || readDirection == 180) {
                if (charDirection == 0 || charDirection == 180) {
                    if (i != 0) {
                        width += fontSetting.getLetterSpacing().doubleValue();
                    }
                    width += box.getWidth();
                    height = Math.max(height, box.getHeight());
                    area.charAreas.add(new Rectangle2D.Double(0.0, 0.0, box.getWidth(), box.getHeight()));
                    continue;
                }
                if (charDirection != 90 && charDirection != 270) continue;
                if (i != 0) {
                    width += fontSetting.getLetterSpacing().doubleValue();
                }
                width += box.getHeight();
                height = Math.max(height, box.getWidth());
                area.charAreas.add(new Rectangle2D.Double(0.0, 0.0, box.getHeight(), box.getWidth()));
                continue;
            }
            if (readDirection != 90 && readDirection != 270) continue;
            if (charDirection == 0 || charDirection == 180) {
                if (i != 0) {
                    height += fontSetting.getLetterSpacing().doubleValue();
                }
                height += box.getHeight();
                width = Math.max(width, box.getWidth());
                area.charAreas.add(new Rectangle2D.Double(0.0, 0.0, box.getWidth(), box.getHeight()));
                continue;
            }
            if (charDirection != 90 && charDirection != 270) continue;
            if (i != 0) {
                height += fontSetting.getLetterSpacing().doubleValue();
            }
            height += box.getWidth();
            width = Math.max(width, box.getHeight());
            area.charAreas.add(new Rectangle2D.Double(0.0, 0.0, box.getHeight(), box.getWidth()));
        }
        area.height = height;
        area.width = width;
        area.letterSpacing = fontSetting.getLetterSpacing();
        return area;
    }

    private static Double[] offset(String text, FontSetting fontSetting, int indexOffset, String wOrH, int direction) {
        if (text.length() == 1) {
            return new Double[0];
        }
        Double fontSize = fontSetting.getFontSize();
        Double letterSpacing = fontSetting.getLetterSpacing();
        Double[] offsetArray = new Double[text.length() - 1];
        int len = indexOffset + text.length() - 1;
        for (int i = indexOffset; i < len; ++i) {
            int index = indexOffset == 0 ? i : i - 1;
            offsetArray[index] = "w".equalsIgnoreCase(wOrH) ? Double.valueOf(fontSetting.charWidth(text.charAt(i)) + letterSpacing) : Double.valueOf(fontSize + letterSpacing);
            offsetArray[index] = (double)direction * offsetArray[index];
        }
        return offsetArray;
    }
}

