/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.engine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.ofdrw.core.OFDElement;
import org.ofdrw.core.basicStructure.doc.Document;
import org.ofdrw.core.basicStructure.res.CT_MultiMedia;
import org.ofdrw.core.basicStructure.res.MediaType;
import org.ofdrw.core.basicStructure.res.OFDResource;
import org.ofdrw.core.basicStructure.res.Res;
import org.ofdrw.core.basicStructure.res.resources.ColorSpaces;
import org.ofdrw.core.basicStructure.res.resources.CompositeGraphicUnits;
import org.ofdrw.core.basicStructure.res.resources.DrawParams;
import org.ofdrw.core.basicStructure.res.resources.Fonts;
import org.ofdrw.core.basicStructure.res.resources.MultiMedias;
import org.ofdrw.core.basicType.ST_ID;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.core.compositeObj.CT_VectorG;
import org.ofdrw.core.pageDescription.color.colorSpace.CT_ColorSpace;
import org.ofdrw.core.pageDescription.drawParam.CT_DrawParam;
import org.ofdrw.core.text.font.CT_Font;
import org.ofdrw.font.Font;
import org.ofdrw.layout.engine.ExistCTFont;
import org.ofdrw.pkg.container.DocDir;
import org.ofdrw.pkg.container.OFDDir;

public class ResManager {
    private AtomicInteger maxUnitID;
    private OFDDir root;
    private DocDir docDir;
    private MultiMedias medias;
    private DrawParams drawParams;
    private Fonts fonts;
    private ColorSpaces colorSpaces;
    private CompositeGraphicUnits compositeGraphicUnits;
    private Res documentRes;
    private Res publicRes;
    public ArrayList<ST_ID> newResIds = new ArrayList();
    private final HashMap<Integer, ST_ID> resObjHash = new HashMap();

    private ResManager() {
    }

    public ResManager(OFDDir root, DocDir docDir, AtomicInteger maxUnitID) {
        this();
        this.root = root;
        this.docDir = docDir;
        this.maxUnitID = maxUnitID;
        if (docDir.exist("PublicRes.xml")) {
            try {
                this.publicRes = docDir.getPublicRes();
                this.reloadRes(this.publicRes);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (DocumentException e) {
                throw new RuntimeException("\u5df2\u6709 PublicRes.xml \u8d44\u6e90\u6587\u4ef6\u89e3\u6790\u5931\u8d25", e);
            }
        }
        if (docDir.exist("DocumentRes.xml")) {
            try {
                this.documentRes = docDir.getDocumentRes();
                this.reloadRes(this.documentRes);
            }
            catch (FileNotFoundException e) {
            }
            catch (DocumentException e) {
                throw new RuntimeException("\u5df2\u6709 DocumentRes.xml \u8d44\u6e90\u6587\u4ef6\u89e3\u6790\u5931\u8d25", e);
            }
        }
    }

    @Deprecated
    public ResManager(DocDir docDir, AtomicInteger maxUnitID) {
        this(null, docDir, maxUnitID);
    }

    private void reloadRes(Res res) {
        List resources = res.getResources();
        if (resources == null || resources.isEmpty()) {
            return;
        }
        for (OFDResource resource : resources) {
            List elements = resource.elements();
            if (elements == null || elements.isEmpty()) continue;
            for (Element ctResObj : elements) {
                ST_ID id = ST_ID.getInstance((String)ctResObj.attributeValue("ID"));
                if (id == null) {
                    return;
                }
                Element copy = (Element)ctResObj.clone();
                copy.remove(copy.attribute("ID"));
                String key = copy.asXML();
                this.resObjHash.put(key.hashCode(), id);
            }
        }
    }

    public ST_ID addFont(Font font) throws IOException {
        return this.addFontRet(font).getID();
    }

    public CT_Font addFontRet(Font font) throws IOException {
        String familyName = font.getFamilyName();
        CT_Font ctFont = new CT_Font().setFontName(font.getName()).setFamilyName(familyName);
        Path fontFile = font.getFontFile();
        if (fontFile != null && font.isEmbeddable()) {
            fontFile = this.docDir.addResourceWithPath(fontFile);
            String filename = fontFile.getFileName().toString();
            if (this.publicRes != null && !ST_Loc.equal((Object)"Res", (Object)this.publicRes.getBaseLoc())) {
                filename = this.docDir.getAbsLoc().cat("Res").cat(filename).toString();
            }
            ctFont.setFontFile(filename);
        }
        if (familyName != null) {
            switch (familyName.toLowerCase()) {
                case "serif": {
                    ctFont.setSerif(Boolean.valueOf(true));
                    break;
                }
                case "bold": {
                    ctFont.setBold(Boolean.valueOf(true));
                    break;
                }
                case "italic": {
                    ctFont.setItalic(Boolean.valueOf(true));
                    break;
                }
                case "fixedwidth": {
                    ctFont.setFixedWidth(Boolean.valueOf(true));
                }
            }
        }
        this.addRawWithCache((OFDElement)ctFont);
        return ctFont;
    }

    public ST_ID addImage(Path imgPath) throws IOException {
        Path imgCtnPath = this.docDir.addResourceWithPath(imgPath);
        String filename = imgCtnPath.getFileName().toString();
        if (this.documentRes != null && !ST_Loc.equal((Object)"Res", (Object)this.documentRes.getBaseLoc())) {
            filename = this.docDir.getAbsLoc().cat("Res").cat(filename).toString();
        }
        String fileSuffix = this.pictureFormat(filename);
        CT_MultiMedia multiMedia = new CT_MultiMedia().setType(MediaType.Image).setFormat(fileSuffix).setMediaFile(ST_Loc.getInstance((String)filename));
        return this.addRawWithCache((OFDElement)multiMedia);
    }

    public ST_ID addDrawParam(CT_DrawParam param) {
        if (param == null) {
            return null;
        }
        param = param.clone();
        return this.addRawWithCache((OFDElement)param.clone());
    }

    private String pictureFormat(String fileName) {
        String fileSuffix;
        switch (fileSuffix = fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase()) {
            case "JPG": {
                return "JPEG";
            }
            case "TIF": {
                return "TIFF";
            }
        }
        return fileSuffix;
    }

    public Res pubRes() {
        if (this.publicRes != null) {
            return this.publicRes;
        }
        Res pubRes = new Res().setBaseLoc(ST_Loc.getInstance((String)"Res"));
        this.docDir.setPublicRes(pubRes);
        this.document().getCommonData().addPublicRes(ST_Loc.getInstance((String)"PublicRes.xml"));
        this.publicRes = pubRes;
        return this.publicRes;
    }

    public Res docRes() {
        if (this.documentRes != null) {
            return this.documentRes;
        }
        Res docRes = new Res().setBaseLoc(ST_Loc.getInstance((String)"Res"));
        this.docDir.setDocumentRes(docRes);
        this.document().getCommonData().addDocumentRes(ST_Loc.getInstance((String)"DocumentRes.xml"));
        this.documentRes = docRes;
        return this.documentRes;
    }

    private Document document() {
        try {
            return this.docDir.getDocument();
        }
        catch (FileNotFoundException | DocumentException ex) {
            throw new RuntimeException("\u6587\u6863\u4e2d\u7f3a\u5c11Document.xml \u6587\u4ef6");
        }
    }

    @Deprecated
    public ResManager addRaw(OFDElement resObj) {
        if (resObj == null) {
            return this;
        }
        if (resObj instanceof CT_ColorSpace) {
            Res resMenu = this.pubRes();
            if (this.colorSpaces == null) {
                this.colorSpaces = new ColorSpaces();
                resMenu.addResource((OFDResource)this.colorSpaces);
            }
            this.colorSpaces.addColorSpace((CT_ColorSpace)resObj);
        } else if (resObj instanceof CT_Font) {
            Res resMenu = this.pubRes();
            if (this.fonts == null) {
                this.fonts = new Fonts();
                resMenu.addResource((OFDResource)this.fonts);
            }
            this.fonts.addFont((CT_Font)resObj);
        } else if (resObj instanceof CT_DrawParam) {
            Res resMenu = this.docRes();
            if (this.drawParams == null) {
                this.drawParams = new DrawParams();
                resMenu.addResource((OFDResource)this.drawParams);
            }
            this.drawParams.addDrawParam((CT_DrawParam)resObj);
        } else if (resObj instanceof CT_MultiMedia) {
            Res resMenu = this.docRes();
            if (this.medias == null) {
                this.medias = new MultiMedias();
                resMenu.addResource((OFDResource)this.medias);
            }
            this.medias.addMultiMedia((CT_MultiMedia)resObj);
        } else if (resObj instanceof CT_VectorG) {
            Res resMenu = this.docRes();
            if (this.compositeGraphicUnits == null) {
                this.compositeGraphicUnits = new CompositeGraphicUnits();
                resMenu.addResource((OFDResource)this.compositeGraphicUnits);
            }
            this.compositeGraphicUnits.addCompositeGraphicUnit((CT_VectorG)resObj);
        }
        return this;
    }

    public ST_ID addRawWithCache(OFDElement resObj) {
        if (resObj == null) {
            return null;
        }
        resObj.removeAttr("ID");
        int key = resObj.asXML().hashCode();
        ST_ID objId = this.resObjHash.get(key);
        if (objId != null) {
            resObj.setObjID(objId);
            return objId;
        }
        objId = new ST_ID((long)this.maxUnitID.incrementAndGet());
        resObj.setObjID(objId);
        this.newResIds.add(objId);
        this.resObjHash.put(key, objId);
        if (resObj instanceof CT_ColorSpace) {
            Res resMenu = this.pubRes();
            if (this.colorSpaces == null) {
                this.colorSpaces = new ColorSpaces();
                resMenu.addResource((OFDResource)this.colorSpaces);
            }
            this.colorSpaces.addColorSpace((CT_ColorSpace)resObj);
        } else if (resObj instanceof CT_Font) {
            Res resMenu = this.pubRes();
            if (this.fonts == null) {
                this.fonts = new Fonts();
                resMenu.addResource((OFDResource)this.fonts);
            }
            this.fonts.addFont((CT_Font)resObj);
        } else if (resObj instanceof CT_DrawParam) {
            Res resMenu = this.docRes();
            if (this.drawParams == null) {
                this.drawParams = new DrawParams();
                resMenu.addResource((OFDResource)this.drawParams);
            }
            this.drawParams.addDrawParam((CT_DrawParam)resObj);
        } else if (resObj instanceof CT_MultiMedia) {
            Res resMenu = this.docRes();
            if (this.medias == null) {
                this.medias = new MultiMedias();
                resMenu.addResource((OFDResource)this.medias);
            }
            this.medias.addMultiMedia((CT_MultiMedia)resObj);
        } else if (resObj instanceof CT_VectorG) {
            Res resMenu = this.docRes();
            if (this.compositeGraphicUnits == null) {
                this.compositeGraphicUnits = new CompositeGraphicUnits();
                resMenu.addResource((OFDResource)this.compositeGraphicUnits);
            }
            this.compositeGraphicUnits.addCompositeGraphicUnit((CT_VectorG)resObj);
        }
        return objId;
    }

    public ExistCTFont getFont(String name) {
        String familyName;
        String fontName;
        List arr;
        if ("".equals(name) || name == null) {
            return null;
        }
        name = name.toLowerCase();
        CT_Font res = null;
        Res resMenu = this.pubRes();
        List fontsList = resMenu.getFonts();
        for (Fonts fonts : fontsList) {
            arr = fonts.getFonts();
            for (CT_Font ctFont : arr) {
                fontName = ctFont.getFontName();
                if (fontName != null) {
                    fontName = fontName.toLowerCase();
                }
                if ((familyName = ctFont.getFamilyName()) != null) {
                    familyName = familyName.toLowerCase();
                }
                if (!name.equals(fontName) && !name.equals(familyName)) continue;
                res = ctFont;
            }
        }
        if (res == null) {
            resMenu = this.docRes();
            fontsList = resMenu.getFonts();
            for (Fonts fonts : fontsList) {
                arr = fonts.getFonts();
                for (CT_Font ctFont : arr) {
                    fontName = ctFont.getFontName();
                    if (fontName != null) {
                        fontName = fontName.toLowerCase();
                    }
                    if ((familyName = ctFont.getFamilyName()) != null) {
                        familyName = familyName.toLowerCase();
                    }
                    if (!name.equals(fontName) && !name.equals(familyName)) continue;
                    res = ctFont;
                }
            }
        }
        if (res == null) {
            return null;
        }
        ST_Loc loc = res.getFontFile();
        Path p = null;
        if (loc != null && this.root != null) {
            ST_Loc abs = this.abs(resMenu, loc);
            try {
                p = this.root.getFile(abs.getFileName());
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return new ExistCTFont(res, p);
    }

    public void setRoot(OFDDir root) {
        this.root = root;
    }

    public OFDDir getRoot() {
        return this.root;
    }

    private ST_Loc abs(Res res, ST_Loc target) {
        if (target.isRootPath()) {
            return target;
        }
        ST_Loc absLoc = null;
        ST_Loc base = res.getBaseLoc();
        absLoc = base != null && base.isRootPath() ? base : this.docDir.getAbsLoc().cat(base);
        return absLoc.cat(target);
    }

    public ArrayList<ST_ID> getNewResIds() {
        return this.newResIds;
    }

    public DocDir getDocDir() {
        return this.docDir;
    }
}

