/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.ofdrw.core.basicStructure.pageObj.Template;
import org.ofdrw.core.basicStructure.pageObj.layer.Type;
import org.ofdrw.core.basicType.ST_ID;
import org.ofdrw.layout.PageLayout;
import org.ofdrw.layout.element.AFloat;
import org.ofdrw.layout.element.Div;
import org.ofdrw.layout.element.Position;

public class VirtualPage {
    private PageLayout style;
    private List<Div> content = new LinkedList<Div>();
    private Integer pageNum = null;
    private List<Template> templates = new ArrayList<Template>();

    protected VirtualPage() {
    }

    public VirtualPage(PageLayout style) {
        this.style = style;
    }

    public VirtualPage(Double width, Double height) {
        this.style = new PageLayout(width, height);
    }

    public PageLayout getStyle() {
        return this.style;
    }

    public void setStyle(PageLayout style) {
        this.style = style;
    }

    public VirtualPage addUnsafe(Div d) {
        this.content.add(d);
        return this;
    }

    public VirtualPage add(Div d) {
        if (d == null) {
            return this;
        }
        if (d.getFloat() != AFloat.left) {
            System.err.println("\u865a\u62df\u9875\u9762\u4e0b\u4e0d\u652f\u6301\u6d6e\u52a8\u5c5e\u6027\uff0c\u4ec5\u652f\u6301\u7edd\u5bf9\u5b9a\u4f4d");
        }
        if (d.getPosition() != Position.Absolute) {
            throw new IllegalArgumentException("\u52a0\u5165\u865a\u62df\u9875\u9762\u7684\u5bf9\u8c61\u5e94\u8be5\u91c7\u7528\u7edd\u5bf9\u5b9a\u4f4d\uff08Position: Absolute\uff09");
        }
        if (d.getX() == null || d.getY() == null) {
            throw new IllegalArgumentException("\u5904\u4e8e\u7edd\u5bf9\u5b9a\u4f4d\u7684\u6a21\u5f0f\u4e0b\u7684\u5143\u7d20\u5e94\u8be5\u8bbe\u7f6e X \u548c Y \u5750\u6807");
        }
        if (d.getWidth() == null) {
            throw new IllegalArgumentException("\u7edd\u5bf9\u5b9a\u4f4d\u5143\u7d20\u81f3\u5c11\u9700\u8981\u6307\u5b9a\u5143\u7d20\u5bbd\u5ea6\uff08Width\uff09");
        }
        d.doPrepare(d.getWidth() + d.widthPlus());
        this.content.add(d);
        return this;
    }

    public List<Div> getContent() {
        return this.content;
    }

    public List<Div> getContent(Type layer) {
        LinkedList<Div> res = new LinkedList<Div>();
        for (Div div : this.content) {
            if (!div.getLayer().equals((Object)layer)) continue;
            res.add(div);
        }
        return res;
    }

    public List<List<Div>> getLayerContent() {
        ArrayList<List<Div>> res = new ArrayList<List<Div>>(3);
        if (this.content.isEmpty()) {
            return res;
        }
        ArrayList<Div> foreground = new ArrayList<Div>();
        ArrayList<Div> body = new ArrayList<Div>();
        ArrayList<Div> background = new ArrayList<Div>();
        res.add(foreground);
        res.add(body);
        res.add(background);
        for (Div div : this.content) {
            switch (div.getLayer()) {
                case Foreground: {
                    foreground.add(div);
                    break;
                }
                case Body: {
                    body.add(div);
                    break;
                }
                case Background: {
                    background.add(div);
                }
            }
        }
        return res;
    }

    VirtualPage setContent(List<Div> content) {
        this.content = content;
        return this;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public VirtualPage setPageNum(int pageNum) {
        if (pageNum <= 0) {
            throw new IllegalArgumentException("\u865a\u62df\u9875\u9762\u9875\u7801(pageNum)\u9519\u8bef");
        }
        this.pageNum = pageNum;
        return this;
    }

    public List<Template> getTemplates() {
        return this.templates;
    }

    public void addTemplate(String id, Type order) {
        Template tpl = new Template();
        tpl.setTemplateID(ST_ID.getInstance((String)id).ref());
        if (order != null) {
            tpl.setZOrder(order);
        }
        this.templates.add(tpl);
    }
}

