/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.element.canvas;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import org.dom4j.Element;
import org.ofdrw.core.basicStructure.pageObj.layer.PageBlockType;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CT_PageBlock;
import org.ofdrw.core.basicStructure.pageObj.layer.block.ImageObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.PathObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.TextObject;
import org.ofdrw.core.basicType.ST_Array;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.basicType.ST_ID;
import org.ofdrw.core.graph.pathObj.AbbreviatedData;
import org.ofdrw.core.graph.pathObj.CT_Path;
import org.ofdrw.core.graph.pathObj.OptVal;
import org.ofdrw.core.pageDescription.CT_GraphicUnit;
import org.ofdrw.core.pageDescription.clips.Area;
import org.ofdrw.core.pageDescription.clips.CT_Clip;
import org.ofdrw.core.pageDescription.clips.ClipAble;
import org.ofdrw.core.pageDescription.clips.Clips;
import org.ofdrw.core.pageDescription.color.color.CT_Color;
import org.ofdrw.core.pageDescription.color.color.ColorClusterType;
import org.ofdrw.core.pageDescription.drawParam.LineCapType;
import org.ofdrw.core.pageDescription.drawParam.LineJoinType;
import org.ofdrw.core.text.TextCode;
import org.ofdrw.core.text.font.CT_Font;
import org.ofdrw.core.text.text.CT_Text;
import org.ofdrw.core.text.text.Direction;
import org.ofdrw.core.text.text.Weight;
import org.ofdrw.font.Font;
import org.ofdrw.layout.element.canvas.CanvasGradient;
import org.ofdrw.layout.element.canvas.CanvasPattern;
import org.ofdrw.layout.element.canvas.CanvasRadialGradient;
import org.ofdrw.layout.element.canvas.CanvasState;
import org.ofdrw.layout.element.canvas.FontSetting;
import org.ofdrw.layout.element.canvas.MeasureBody;
import org.ofdrw.layout.element.canvas.NamedColor;
import org.ofdrw.layout.element.canvas.TextAlign;
import org.ofdrw.layout.element.canvas.TextMeasureTool;
import org.ofdrw.layout.element.canvas.TextMetrics;
import org.ofdrw.layout.element.canvas.TextMetricsArea;
import org.ofdrw.layout.engine.ExistCTFont;
import org.ofdrw.layout.engine.ResManager;

public class DrawContext
implements Closeable {
    static final ST_Array ONE = ST_Array.unitCTM();
    private CT_PageBlock container;
    private AtomicInteger maxUnitID;
    private ResManager resManager;
    private ST_Box boundary;
    private CanvasState state;
    private LinkedList<CanvasState> stack;
    public Object fillStyle;
    public Object strokeStyle;
    public String font;
    public double PPM;

    private DrawContext() {
    }

    public DrawContext(CT_PageBlock container, ST_Box boundary, AtomicInteger maxUnitID, ResManager resManager) {
        this.container = container;
        this.boundary = boundary;
        this.maxUnitID = maxUnitID;
        this.resManager = resManager;
        this.state = new CanvasState();
        this.stack = new LinkedList();
        this.PPM = 3.78;
        this.fillStyle = "#000000";
        this.strokeStyle = "#000000";
    }

    public DrawContext beginPath() {
        this.state.path = new AbbreviatedData();
        return this;
    }

    public DrawContext closePath() {
        if (this.state.path == null) {
            return this;
        }
        this.state.path.close();
        return this;
    }

    public DrawContext clip() {
        if (this.state.path == null) {
            return this;
        }
        this.state.clipArea = this.state.path.clone();
        if (this.state.ctm != null && !ONE.equals((Object)this.state.ctm)) {
            DrawContext.transform(this.state.clipArea, this.state.ctm);
        }
        return this;
    }

    public DrawContext moveTo(double x, double y) {
        if (this.state.path == null) {
            this.state.path = new AbbreviatedData();
        }
        this.state.path.moveTo(x, y);
        return this;
    }

    public DrawContext lineTo(double x, double y) {
        if (this.state.path == null) {
            return this;
        }
        this.state.path.lineTo(x, y);
        return this;
    }

    public DrawContext quadraticCurveTo(double cpx, double cpy, double x, double y) {
        if (this.state.path == null) {
            this.state.path = new AbbreviatedData();
        }
        this.state.path.quadraticBezier(cpx, cpy, x, y);
        return this;
    }

    public DrawContext bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x, double y) {
        if (this.state.path == null) {
            this.state.path = new AbbreviatedData();
        }
        this.state.path.cubicBezier(cp1x, cp1y, cp2x, cp2y, x, y);
        return this;
    }

    public DrawContext arc(double a, double b, double angle, boolean large, boolean sweep, double x, double y) {
        if (this.state.path == null) {
            this.state.path = new AbbreviatedData();
        }
        this.state.path.arc(a, b, angle % 360.0, large ? 1 : 0, sweep ? 1 : 0, x, y);
        return this;
    }

    public DrawContext arc(double x, double y, double r, double sAngle, double eAngle, boolean counterclockwise) {
        if (this.state.path == null) {
            this.state.path = new AbbreviatedData();
        }
        double x1 = x + r * Math.cos(sAngle * Math.PI / 180.0);
        double y1 = y + r * Math.sin(sAngle * Math.PI / 180.0);
        this.moveTo(x1, y1);
        double angle = eAngle - sAngle;
        if (angle == 360.0) {
            this.state.path.arc(r, r, angle, 1, counterclockwise ? 1 : 0, x - r, y).arc(r, r, angle, 1, counterclockwise ? 1 : 0, x1, y1);
        } else {
            double x2 = x + r * Math.cos(eAngle * Math.PI / 180.0);
            double y2 = y + r * Math.sin(eAngle * Math.PI / 180.0);
            this.state.path.arc(r, r, angle, angle > 180.0 ? 1 : 0, counterclockwise ? 1 : 0, x2, y2);
        }
        return this;
    }

    public DrawContext arc(double x, double y, double r, double sAngle, double eAngle) {
        return this.arc(x, y, r, sAngle, eAngle, true);
    }

    public DrawContext rect(double x, double y, double width, double height) {
        if (this.state.path == null) {
            this.state.path = new AbbreviatedData();
        }
        this.state.path.moveTo(x, y).lineTo(x + width, y).lineTo(x + width, y + height).lineTo(x, y + height).close();
        return this;
    }

    public DrawContext fillRect(double x, double y, double width, double height) {
        AbbreviatedData abData = new AbbreviatedData().moveTo(x, y).lineTo(x + width, y).lineTo(x + width, y + height).lineTo(x, y + height).close();
        PathObject p = new PathObject(new ST_ID((long)this.maxUnitID.incrementAndGet()));
        p.setAbbreviatedData(abData);
        p.setFill(Boolean.valueOf(true));
        this.applyDrawParam((CT_GraphicUnit<?>)p);
        this.container.add((Element)p);
        return this;
    }

    public DrawContext strokeRect(double x, double y, double width, double height) {
        AbbreviatedData abData = new AbbreviatedData().moveTo(x, y).lineTo(x + width, y).lineTo(x + width, y + height).lineTo(x, y + height).close();
        PathObject p = new PathObject(new ST_ID((long)this.maxUnitID.incrementAndGet()));
        p.setAbbreviatedData(abData);
        p.setStroke(Boolean.valueOf(true));
        this.applyDrawParam((CT_GraphicUnit<?>)p);
        this.container.add((Element)p);
        return this;
    }

    public DrawContext stroke() {
        if (this.state.path == null) {
            return this;
        }
        PathObject p = new PathObject(new ST_ID((long)this.maxUnitID.incrementAndGet()));
        p.setAbbreviatedData(this.state.path.clone());
        p.setStroke(Boolean.valueOf(true));
        this.applyDrawParam((CT_GraphicUnit<?>)p);
        this.container.add((Element)p);
        return this;
    }

    public DrawContext fill() {
        if (this.state.path == null) {
            return this;
        }
        PathObject p = new PathObject(new ST_ID((long)this.maxUnitID.incrementAndGet()));
        p.setAbbreviatedData(this.state.path.clone());
        p.setFill(Boolean.valueOf(true));
        p.setLineWidth(Double.valueOf(0.0));
        this.applyDrawParam((CT_GraphicUnit<?>)p);
        this.container.add((Element)p);
        return this;
    }

    public DrawContext scale(double scalewidth, double scaleheight) {
        if (this.state.ctm == null) {
            this.state.ctm = ST_Array.unitCTM();
        }
        ST_Array scale = new ST_Array(scalewidth, 0.0, 0.0, scaleheight, 0.0, 0.0);
        this.state.ctm = scale.mtxMul(this.state.ctm);
        return this;
    }

    public DrawContext rotate(double angle) {
        if (this.state.ctm == null) {
            this.state.ctm = ST_Array.unitCTM();
        }
        double alpha = angle * Math.PI / 180.0;
        ST_Array r = new ST_Array(Math.cos(alpha), Math.sin(alpha), -Math.sin(alpha), Math.cos(alpha), 0.0, 0.0);
        this.state.ctm = r.mtxMul(this.state.ctm);
        return this;
    }

    public DrawContext translate(double x, double y) {
        if (this.state.ctm == null) {
            this.state.ctm = ST_Array.unitCTM();
        }
        ST_Array r = new ST_Array(1.0, 0.0, 0.0, 1.0, x, y);
        this.state.ctm = r.mtxMul(this.state.ctm);
        return this;
    }

    public DrawContext transform(double a, double b, double c, double d, double e, double f) {
        if (this.state.ctm == null) {
            this.state.ctm = ST_Array.unitCTM();
        }
        ST_Array r = new ST_Array(a, b, c, d, e, f);
        this.state.ctm = r.mtxMul(this.state.ctm);
        return this;
    }

    public DrawContext setTransform(double a, double b, double c, double d, double e, double f) {
        this.state.ctm = new ST_Array(a, b, c, d, e, f);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrawContext drawImage(Path img, double sx, double sy, double sWidth, double sHeight, double dx, double dy, double dWidth, double dHeight) throws IOException {
        if (img == null || Files.notExists(img, new LinkOption[0])) {
            throw new IllegalArgumentException("\u56fe\u50cf\u4e0d\u5b58\u5728");
        }
        BufferedImage gImg = ImageIO.read(img.toFile());
        int w = this.pixel(sWidth);
        int h = this.pixel(sHeight);
        BufferedImage cutOut = new BufferedImage(w, h, 2);
        Graphics2D g2 = cutOut.createGraphics();
        g2.drawImage(gImg, 0, 0, w, h, this.pixel(sx), this.pixel(sy), this.pixel(sx) + w, this.pixel(sy) + h, null);
        Path tmpImgCutPath = null;
        try {
            tmpImgCutPath = Files.createTempFile("", ".png", new FileAttribute[0]);
            ImageIO.write((RenderedImage)cutOut, "png", tmpImgCutPath.toFile());
            DrawContext drawContext = this.drawImage(tmpImgCutPath, dx, dy, dWidth, dHeight);
            return drawContext;
        }
        finally {
            if (tmpImgCutPath != null) {
                Files.deleteIfExists(tmpImgCutPath);
            }
        }
    }

    public DrawContext drawImage(Path img, double dx, double dy) throws IOException {
        if (img == null || Files.notExists(img, new LinkOption[0])) {
            throw new IllegalArgumentException("\u56fe\u50cf\u4e0d\u5b58\u5728");
        }
        BufferedImage gImg = ImageIO.read(img.toFile());
        int w = gImg.getWidth();
        int h = gImg.getHeight();
        return this.drawImage(img, dx, dy, this.mm(w), this.mm(h));
    }

    public DrawContext drawImage(Path img, double dx, double dy, double dWidth, double dHeight) throws IOException {
        if (img == null || Files.notExists(img, new LinkOption[0])) {
            throw new IOException("\u56fe\u7247(img)\u4e0d\u5b58\u5728");
        }
        ST_ID id = this.resManager.addImage(img);
        ImageObject imgObj = new ImageObject((long)this.maxUnitID.incrementAndGet());
        imgObj.setResourceID(id.ref());
        imgObj.setBoundary(this.boundary.clone());
        ST_Array ctm = this.state.ctm == null ? ST_Array.unitCTM() : this.state.ctm;
        ctm = new ST_Array(dWidth, 0.0, 0.0, dHeight, dx, dy).mtxMul(ctm);
        imgObj.setCTM(ctm);
        this.applyDrawParam((CT_GraphicUnit<?>)imgObj);
        this.container.addPageBlock((PageBlockType)imgObj);
        return this;
    }

    public DrawContext save() {
        this.state.strokeStyle = this.strokeStyle;
        this.state.fillStyle = this.fillStyle;
        this.state.fontStyle = this.font;
        this.stack.push(this.state.clone());
        return this;
    }

    public DrawContext restore() {
        if (this.stack.isEmpty()) {
            return this;
        }
        this.state = this.stack.pop();
        this.strokeStyle = this.state.strokeStyle;
        this.fillStyle = this.state.fillStyle;
        this.font = this.state.fontStyle;
        return this;
    }

    public DrawContext fillText(String text, double x, double y) throws IOException {
        if (text == null || text.trim().isEmpty()) {
            return this;
        }
        ST_ID fontID = null;
        CT_Font existFont = this.fontStyleToSetting(this.font, this.state.font);
        fontID = existFont != null ? existFont.getID() : this.resManager.addFont(this.state.font.getFont());
        TextObject txtObj = ((CT_Text)new CT_Text().setBoundary(this.boundary.clone())).setFont(fontID.ref()).setSize(this.state.font.getFontSize()).toObj(new ST_ID((long)this.maxUnitID.incrementAndGet()));
        txtObj.setFill(Boolean.valueOf(true));
        if (this.state.font.getFontWeight() != null && this.state.font.getFontWeight() != 400) {
            txtObj.setWeight(Weight.getInstance((int)this.state.font.getFontWeight()));
        }
        if (this.state.font.isItalic()) {
            txtObj.setItalic(Boolean.valueOf(true));
        }
        int readDirection = this.state.font.getReadDirection();
        int charDirection = this.state.font.getCharDirection();
        if (readDirection != 0) {
            txtObj.setReadDirection(Direction.getInstance((Integer)readDirection));
        }
        if (charDirection != 0) {
            txtObj.setCharDirection(Direction.getInstance((Integer)charDirection));
        }
        MeasureBody measureBody = TextMeasureTool.measureWithWith(text, this.state.font);
        double xx = x + measureBody.firstCharOffsetX;
        double yy = y + measureBody.firstCharOffsetY;
        switch (readDirection) {
            case 0: 
            case 180: {
                xx += this.textFloatFactor(this.state.font.getTextAlign(), measureBody.width, readDirection);
                break;
            }
            case 90: 
            case 270: {
                yy += this.textFloatFactor(this.state.font.getTextAlign(), measureBody.width, readDirection);
            }
        }
        TextCode tcSTTxt = new TextCode().setContent(text).setX(Double.valueOf(xx)).setY(Double.valueOf(yy));
        if (readDirection == 90 || readDirection == 270) {
            tcSTTxt.setDeltaY(measureBody.offset);
        } else {
            tcSTTxt.setDeltaX(measureBody.offset);
        }
        txtObj.addTextCode(tcSTTxt);
        this.applyDrawParam((CT_GraphicUnit<?>)txtObj);
        this.container.addPageBlock((PageBlockType)txtObj);
        return this;
    }

    private double textFloatFactor(TextAlign align, double width, int readDirection) {
        double factor = 0.0;
        switch (align) {
            case start: 
            case left: {
                factor = 0.0;
                break;
            }
            case end: 
            case right: {
                factor = -width;
                break;
            }
            case center: {
                factor = -width / 2.0;
            }
        }
        if (readDirection == 180 || readDirection == 270) {
            factor = -factor;
        }
        return factor;
    }

    public TextAlign getTextAlign() {
        return this.state.font.getTextAlign();
    }

    public DrawContext setTextAlign(TextAlign textAlign) {
        this.state.font.setTextAlign(textAlign);
        return this;
    }

    public TextMetrics measureText(String text) {
        this.fontStyleToSetting(this.font, this.state.font);
        TextMetrics tm = new TextMetrics();
        tm.readDirection = this.state.font.getReadDirection();
        tm.fontSize = this.state.font.getFontSize();
        MeasureBody measureBody = TextMeasureTool.measureWithWith(text, this.state.font);
        tm.width = measureBody.width;
        tm.offset = measureBody.offset;
        return tm;
    }

    public TextMetricsArea measureTextArea(String text) {
        this.fontStyleToSetting(this.font, this.state.font);
        return TextMeasureTool.measureArea(text, this.state.font);
    }

    public int[] getStrokeColor() {
        if (this.strokeStyle instanceof String) {
            return NamedColor.rgb((String)this.strokeStyle);
        }
        return null;
    }

    public DrawContext setStrokeColor(int[] strokeColor) {
        this.strokeStyle = String.format("#%02X%02X%02X", strokeColor[0], strokeColor[1], strokeColor[2]);
        return this;
    }

    public DrawContext setStrokeColor(int r, int g, int b) {
        return this.setStrokeColor(new int[]{r, g, b});
    }

    public int[] getFillColor() {
        if (this.fillStyle instanceof String) {
            return NamedColor.rgb((String)this.fillStyle);
        }
        return null;
    }

    public DrawContext setFillColor(int[] fillColor) {
        this.fillStyle = String.format("#%02X%02X%02X", fillColor[0], fillColor[1], fillColor[2]);
        return this;
    }

    public DrawContext setFillColor(int r, int g, int b) {
        return this.setFillColor(new int[]{r, g, b});
    }

    public double getLineWidth() {
        return this.state.drawParam.getLineWidth();
    }

    public DrawContext setLineWidth(double lineWidth) {
        if (lineWidth < 0.0) {
            lineWidth = 0.353;
        }
        this.state.drawParam.setLineWidth(Double.valueOf(lineWidth));
        return this;
    }

    public FontSetting getFont() {
        return this.state.font;
    }

    public DrawContext setFont(FontSetting font) {
        this.state.font = font;
        this.font = "";
        return this;
    }

    public DrawContext setDefaultFont(double fontSize) {
        this.state.font = FontSetting.getInstance(fontSize);
        return this;
    }

    public Double getGlobalAlpha() {
        return this.state.globalAlpha;
    }

    public DrawContext setGlobalAlpha(Double globalAlpha) {
        if (globalAlpha == null || globalAlpha > 1.0) {
            globalAlpha = 1.0;
        } else if (globalAlpha < 0.0) {
            globalAlpha = 0.0;
        }
        this.state.globalAlpha = globalAlpha;
        return this;
    }

    public DrawContext setLineCap(LineCapType cap) {
        this.state.drawParam.setCap(cap);
        return this;
    }

    public LineCapType getLineCap() {
        return this.state.drawParam.getCap();
    }

    public DrawContext setLineJoin(LineJoinType join) {
        this.state.drawParam.setJoin(join);
        return this;
    }

    public LineJoinType getLineJoin() {
        return this.state.drawParam.getJoin();
    }

    public DrawContext setMiterLimit(Double miterLimit) {
        this.state.drawParam.setMiterLimit(miterLimit);
        return this;
    }

    public Double getMiterLimit() {
        return this.state.drawParam.getMiterLimit();
    }

    public DrawContext setLineDash(Double dashOffset, Double[] pattern) {
        if (dashOffset == null && pattern == null) {
            this.state.drawParam.setDashPattern(null);
            this.state.drawParam.setDashOffset(null);
            return this;
        }
        if (pattern == null || pattern.length < 2) {
            throw new IllegalArgumentException("\u865a\u7ebf\u7684\u7ebf\u6bb5\u957f\u5ea6\u548c\u95f4\u9694\u957f\u5ea6(pattern)\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u5e76\u4e14\u9700\u8981\u5927\u4e8e\u4e24\u4e2a\u4ee5\u4e0a\u7684\u503c");
        }
        this.state.drawParam.setDashPattern(new ST_Array((Serializable[])pattern));
        this.state.drawParam.setDashOffset(dashOffset);
        return this;
    }

    public DrawContext setLineDash(Double ... pattern) {
        return this.setLineDash((Double)null, pattern);
    }

    public ST_Array getDashPattern() {
        return this.state.drawParam.getDashPattern();
    }

    public Double getDashOffset() {
        return this.state.drawParam.getDashOffset();
    }

    public CanvasGradient createLinearGradient(double x0, double y0, double x1, double y1) {
        return new CanvasGradient(x0, y0, x1, y1);
    }

    public CanvasGradient createLinearGradient(int x0, int y0, int x1, int y1) {
        return new CanvasGradient(x0, y0, x1, y1);
    }

    public CanvasPattern createPattern(Path img, String repetition) throws IOException {
        if (Files.notExists(img = img.toAbsolutePath(), new LinkOption[0])) {
            throw new IllegalArgumentException("\u5e95\u7eb9\u56fe\u7247\u4e0d\u5b58\u5728\uff1a" + img);
        }
        ST_ID id = this.resManager.addImage(img);
        BufferedImage gImg = ImageIO.read(img.toFile());
        double w = this.mm(gImg.getWidth());
        double h = this.mm(gImg.getHeight());
        ImageObject imgObj = new ImageObject((long)this.maxUnitID.incrementAndGet());
        imgObj.setResourceID(id.ref());
        imgObj.setBoundary(new ST_Box(0.0, 0.0, w, h));
        imgObj.setCTM(new ST_Array(w, 0.0, 0.0, h, 0.0, 0.0));
        return new CanvasPattern(img, repetition, imgObj);
    }

    public CanvasRadialGradient createRadialGradient(double x0, double y0, double r0, double x1, double y1, double r1) {
        return new CanvasRadialGradient(x0, y0, r0, x1, y1, r1);
    }

    private void applyDrawParam(CT_GraphicUnit<?> p) {
        CT_Color strokeColor;
        CT_Color fillColor;
        if (p == null) {
            return;
        }
        p.setBoundary(this.boundary.clone());
        if (this.state.globalAlpha != null) {
            p.setAlpha(Integer.valueOf((int)(255.0 * this.state.globalAlpha)));
        }
        if (this.state.ctm != null && p.getCTM() == null) {
            p.setCTM(this.state.ctm.clone());
        }
        if ((fillColor = this.detectColor(this.fillStyle)) != null) {
            this.state.drawParam.setFillColor(fillColor);
        }
        if ((strokeColor = this.detectColor(this.strokeStyle)) != null) {
            this.state.drawParam.setStrokeColor(strokeColor);
        }
        ST_ID paramObjId = this.resManager.addDrawParam(this.state.drawParam);
        p.setDrawParam(paramObjId.ref());
        if (this.state.clipArea != null) {
            Clips clips = new Clips();
            Area area = new Area();
            CT_Path clipObj = new CT_Path().setAbbreviatedData(this.state.clipArea.clone());
            clipObj.setFill(Boolean.valueOf(true));
            clipObj.setBoundary(new ST_Box(0.0, 0.0, this.boundary.getWidth().doubleValue(), this.boundary.getHeight().doubleValue()));
            if (this.state.ctm != null && !ONE.equals((Object)this.state.ctm)) {
                ST_Array inverse = this.inverse(this.state.ctm);
                if (inverse == null) {
                    return;
                }
                clipObj.setCTM(inverse);
            }
            area.setClipObj((ClipAble)clipObj);
            clips.addClip(new CT_Clip().addArea(area));
            p.setClips(clips);
        }
    }

    private ST_Array inverse(ST_Array ctm) {
        if (ctm.size() < 6) {
            return null;
        }
        AffineTransform at = new AffineTransform(ctm.get(0), ctm.get(1), ctm.get(2), ctm.get(3), ctm.get(4), ctm.get(5));
        AffineTransform tx = null;
        try {
            tx = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
        return new ST_Array(tx.getScaleX(), tx.getShearY(), tx.getShearX(), tx.getScaleY(), tx.getTranslateX(), tx.getTranslateY());
    }

    public static void transform(AbbreviatedData data, ST_Array ctm) {
        AffineTransform at = new AffineTransform(ctm.get(0), ctm.get(1), ctm.get(2), ctm.get(3), ctm.get(4), ctm.get(5));
        for (OptVal optVal : data.getRawOptVal()) {
            switch (optVal.opt) {
                case "S": 
                case "M": 
                case "L": {
                    double[] arr = optVal.expectValues();
                    double[] dst = new double[2];
                    at.transform(arr, 0, dst, 0, 1);
                    optVal.setValues(dst);
                    break;
                }
                case "Q": {
                    double[] arr = optVal.expectValues();
                    double[] dst = new double[4];
                    at.transform(arr, 0, dst, 0, 2);
                    optVal.setValues(dst);
                    break;
                }
                case "B": {
                    double[] arr = optVal.expectValues();
                    double[] dst = new double[6];
                    at.transform(arr, 0, dst, 0, 3);
                    optVal.setValues(dst);
                    break;
                }
                case "A": {
                    double[] arr = optVal.expectValues();
                    double rx = arr[0] * at.getScaleX();
                    double ry = arr[1] * at.getScaleY();
                    double[] ptDst = new double[2];
                    at.transform(arr, 5, ptDst, 0, 1);
                    optVal.setValues(new double[]{rx, ry, arr[2], arr[3], arr[4], ptDst[0], ptDst[1]});
                }
            }
        }
    }

    private CT_Color detectColor(Object color) {
        if (color == null) {
            return null;
        }
        if (color instanceof String) {
            int[] rgb = NamedColor.rgb((String)color);
            if (rgb != null) {
                CT_Color c = CT_Color.rgb((int)rgb[0], (int)rgb[1], (int)rgb[2]);
                if (rgb.length > 3) {
                    c.setAlpha(Integer.valueOf(rgb[3]));
                }
                return c;
            }
            return null;
        }
        if (color instanceof ColorClusterType) {
            CT_Color res = new CT_Color();
            res.setColor((ColorClusterType)color);
            return res;
        }
        if (color instanceof CT_Color) {
            return (CT_Color)color;
        }
        if (color instanceof CanvasGradient) {
            CT_Color res = new CT_Color();
            res.setColor((ColorClusterType)((CanvasGradient)color).axialShd);
            return res;
        }
        if (color instanceof CanvasPattern) {
            CT_Color res = new CT_Color();
            res.setColor((ColorClusterType)((CanvasPattern)color).pattern);
            return res;
        }
        if (color instanceof CanvasRadialGradient) {
            CT_Color res = new CT_Color();
            res.setColor((ColorClusterType)((CanvasRadialGradient)color).radialShd);
            return res;
        }
        return null;
    }

    private CT_Font fontStyleToSetting(String fontSettingStr, FontSetting fs) {
        if (fontSettingStr == null || fontSettingStr.isEmpty() || fs == null) {
            return null;
        }
        String[] arr = fontSettingStr.trim().split(" ");
        if (arr.length < 2) {
            return null;
        }
        int off = arr.length - 1;
        String fontFamily = arr[off].trim();
        Font nameFont = new Font(fontFamily, fontFamily);
        CT_Font ctFont = null;
        ExistCTFont existCTFont = this.resManager.getFont(fontFamily);
        if (existCTFont != null) {
            ctFont = existCTFont.font;
            nameFont = existCTFont.absPath != null ? new Font(ctFont.getFontName(), ctFont.getFamilyName(), existCTFont.absPath) : new Font(ctFont.getFontName(), ctFont.getFamilyName());
        }
        fs.setFont(nameFont);
        String fontSizeStr = arr[--off].trim();
        double fontSize = 1.0;
        try {
            if (fontSizeStr.endsWith("px")) {
                fontSizeStr = fontSizeStr.substring(0, fontSizeStr.length() - 2).trim();
                fontSize = Double.parseDouble(fontSizeStr) / this.PPM;
            } else if (fontSizeStr.endsWith("mm")) {
                fontSizeStr = fontSizeStr.substring(0, fontSizeStr.length() - 2).trim();
                fontSize = Double.parseDouble(fontSizeStr);
            } else {
                fontSize = Double.parseDouble(fontSizeStr);
            }
        }
        catch (NumberFormatException e) {
            fontSize = 1.0;
        }
        fs.setFontSize(fontSize);
        if (--off < 0) {
            return ctFont;
        }
        int fontWeight = 400;
        switch (arr[off].trim().toLowerCase()) {
            case "lighter": 
            case "100": {
                fontWeight = 100;
                --off;
                break;
            }
            case "200": {
                fontWeight = 200;
                --off;
                break;
            }
            case "300": {
                fontWeight = 300;
                --off;
                break;
            }
            case "normal": 
            case "400": {
                fontWeight = 400;
                --off;
                break;
            }
            case "500": {
                fontWeight = 500;
                --off;
                break;
            }
            case "600": {
                fontWeight = 600;
                --off;
                break;
            }
            case "bold": 
            case "700": {
                fontWeight = 700;
                --off;
                break;
            }
            case "800": {
                fontWeight = 800;
                --off;
                break;
            }
            case "bolder": 
            case "900": {
                fontWeight = 900;
                --off;
                break;
            }
        }
        fs.setFontWeight(fontWeight);
        if (off < 0) {
            return ctFont;
        }
        switch (arr[off].trim()) {
            case "italic": {
                fs.setItalic(true);
                break;
            }
            default: {
                fs.setItalic(false);
            }
        }
        return ctFont;
    }

    public double mm(int pixel) {
        return (double)pixel / this.PPM;
    }

    public int pixel(double mm) {
        return (int)(mm * this.PPM);
    }

    public DrawContext addFont(String name, Path p) throws IOException {
        this.resManager.addFont(new Font(name, p));
        return this;
    }

    @Override
    public void close() {
    }
}

