/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.element.canvas;

import java.io.IOException;
import org.ofdrw.layout.element.canvas.CanvasBase;
import org.ofdrw.layout.element.canvas.DrawContext;

public class Line
extends CanvasBase {
    private double[] beginPoint = new double[]{0.0, 0.0};
    private double[] endPoint = new double[]{0.0, 0.0};
    private String lineColor = "#000000";
    private double lineWidth = 0.353;
    private double lineOpacity = 1.0;

    public Line(Double width, Double height) {
        super(width, height);
    }

    public Line(double x, double y, double w, double h) {
        super(x, y, w, h);
    }

    public double[] getBeginPoint() {
        return this.beginPoint;
    }

    public Line setBeginPoint(double[] beginPoint) {
        this.beginPoint = beginPoint;
        return this;
    }

    public Line setBeginPoint(double beginX, double beginY) {
        this.beginPoint = new double[]{beginX, beginY};
        return this;
    }

    public double[] getEndPoint() {
        return this.endPoint;
    }

    public Line setEndPoint(double[] endPoint) {
        this.endPoint = endPoint;
        return this;
    }

    public Line setEndPoint(double endX, double endY) {
        this.endPoint = new double[]{endX, endY};
        return this;
    }

    public String getLineColor() {
        return this.lineColor;
    }

    public Line setLineColor(String lineColor) {
        this.lineColor = lineColor;
        return this;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public Line setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
        return this;
    }

    public double getLineOpacity() {
        return this.lineOpacity;
    }

    public Line setLineOpacity(double lineOpacity) {
        this.lineOpacity = lineOpacity;
        return this;
    }

    @Override
    public void draw(DrawContext ctx) throws IOException {
        if (this.lineColor == null) {
            this.lineColor = "#000000";
        }
        if (this.lineWidth <= 0.0) {
            return;
        }
        if (this.beginPoint == null || this.endPoint.length < 2) {
            return;
        }
        if (this.endPoint == null || this.endPoint.length < 2) {
            return;
        }
        if (this.beginPoint[0] == this.endPoint[0] && this.beginPoint[1] == this.endPoint[1]) {
            return;
        }
        ctx.save();
        try {
            ctx.setLineWidth(this.lineWidth);
            ctx.beginPath();
            ctx.setGlobalAlpha(this.lineOpacity);
            ctx.strokeStyle = this.lineColor;
            ctx.moveTo(this.beginPoint[0], this.beginPoint[1]);
            ctx.lineTo(this.endPoint[0], this.endPoint[1]);
            ctx.stroke();
        }
        finally {
            ctx.restore();
        }
    }
}

