/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.pkg.container;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.ofdrw.core.annotation.Annotations;
import org.ofdrw.core.basicStructure.doc.Document;
import org.ofdrw.core.basicStructure.res.Res;
import org.ofdrw.pkg.container.PagesDir;
import org.ofdrw.pkg.container.ResDir;
import org.ofdrw.pkg.container.SignsDir;
import org.ofdrw.pkg.container.VirtualContainer;

public class DocDir
extends VirtualContainer {
    public static final String DocContainerPrefix = "Doc_";
    public static final String DocumentFileName = "Document.xml";
    public static final String PublicResFileName = "PublicRes.xml";
    public static final String DocumentResFileName = "DocumentRes.xml";
    public static final String AnnotationsFileName = "Annotations.xml";
    public static final String Attachments = "Attachments.xml";
    private int index = 0;

    public DocDir(Path fullDir) throws IllegalArgumentException {
        super(fullDir);
        String indexStr = this.getContainerName().replace(DocContainerPrefix, "");
        try {
            this.index = Integer.parseInt(indexStr);
        }
        catch (NumberFormatException e) {
            this.clean();
            throw new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684\u6587\u4ef6\u76ee\u5f55\u540d\u79f0\uff1a" + this.getContainerName() + "\uff0c\u76ee\u5f55\u540d\u79f0\u5e94\u4e3a Doc_N");
        }
    }

    public Integer getIndex() {
        return this.index;
    }

    public Document getDocument() throws FileNotFoundException, DocumentException {
        Element obj = this.getObj(DocumentFileName);
        return new Document(obj);
    }

    public DocDir setDocument(Document document) {
        this.putObj(DocumentFileName, (Element)document);
        return this;
    }

    public Res getPublicRes() throws FileNotFoundException, DocumentException {
        Element obj = this.getObj(PublicResFileName);
        return new Res(obj);
    }

    public DocDir setPublicRes(Res publicRes) {
        this.putObj(PublicResFileName, (Element)publicRes);
        return this;
    }

    public Res getDocumentRes() throws FileNotFoundException, DocumentException {
        Element obj = this.getObj(DocumentResFileName);
        return new Res(obj);
    }

    public Annotations getAnnotations() throws FileNotFoundException, DocumentException {
        Element obj = this.getObj(AnnotationsFileName);
        return new Annotations(obj);
    }

    public DocDir setAnnotations(Annotations annotations) {
        this.putObj(AnnotationsFileName, (Element)annotations);
        return this;
    }

    public DocDir setDocumentRes(Res documentRes) {
        this.putObj(DocumentResFileName, (Element)documentRes);
        return this;
    }

    public ResDir getRes() throws FileNotFoundException {
        return this.getContainer("Res", ResDir::new);
    }

    public ResDir obtainRes() {
        return this.obtainContainer("Res", ResDir::new);
    }

    public SignsDir getSigns() throws FileNotFoundException {
        return this.getContainer("Signs", SignsDir::new);
    }

    public SignsDir obtainSigns() {
        return this.obtainContainer("Signs", SignsDir::new);
    }

    public PagesDir getPages() throws FileNotFoundException {
        return this.getContainer("Pages", PagesDir::new);
    }

    public PagesDir obtainPages() {
        return this.obtainContainer("Pages", PagesDir::new);
    }

    public DocDir addResource(Path resource) throws IOException {
        this.obtainRes().add(resource);
        return this;
    }

    public Path getResource(String name) throws FileNotFoundException {
        return this.obtainRes().get(name);
    }
}

