/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.pkg.container;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.jcajce.provider.digest.SM3;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.ofdrw.core.DefaultElementProxy;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.pkg.tool.ElemCup;

public class VirtualContainer
implements Closeable {
    private String fullPath;
    private String name;
    private VirtualContainer parent;
    private Map<String, Element> fileCache = new HashMap<String, Element>(7);
    private Map<String, byte[]> fileSrcHash;
    private MessageDigest digest = null;
    private Map<String, VirtualContainer> dirCache = new HashMap<String, VirtualContainer>(5);

    public String getContainerName() {
        return this.name;
    }

    private VirtualContainer() {
        this.fileSrcHash = new HashMap<String, byte[]>(7);
        this.parent = this;
    }

    public VirtualContainer(Path fullDir) throws IllegalArgumentException {
        this();
        if (fullDir == null) {
            throw new IllegalArgumentException("\u5b8c\u6574\u8def\u5f84(fullDir)\u4e3a\u7a7a");
        }
        if (Files.notExists(fullDir, new LinkOption[0]) || !Files.isDirectory(fullDir, new LinkOption[0])) {
            try {
                fullDir = Files.createDirectories(fullDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("\u65e0\u6cd5\u521b\u5efa\u6307\u5b9a\u76ee\u5f55", e);
            }
        }
        this.fullPath = fullDir.toAbsolutePath().toString();
        this.name = fullDir.getFileName().toString();
    }

    public VirtualContainer(Path parent, String dirName) throws IllegalArgumentException {
        this();
        if (parent == null) {
            throw new IllegalArgumentException("\u6839\u8def\u5f84(parent)\u4e3a\u7a7a");
        }
        Path fullPath = Paths.get(parent.toAbsolutePath().toString(), dirName);
        if (Files.notExists(fullPath, new LinkOption[0]) || !Files.isDirectory(fullPath, new LinkOption[0])) {
            try {
                fullPath = Files.createDirectories(fullPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("\u65e0\u6cd5\u521b\u5efa\u6307\u5b9a\u76ee\u5f55", e);
            }
        }
        if (!Files.isDirectory(parent, new LinkOption[0])) {
            throw new IllegalStateException("\u8bf7\u4f20\u5165\u57fa\u7840\u76ee\u5f55\u8def\u5f84\uff0c\u800c\u4e0d\u662f\u6587\u4ef6");
        }
        this.fullPath = fullPath.toAbsolutePath().toString();
        this.name = dirName;
    }

    public String getSysAbsPath() {
        return this.fullPath;
    }

    public VirtualContainer putFile(Path file) throws IOException {
        if (file == null || Files.notExists(file, new LinkOption[0]) || Files.isDirectory(file, new LinkOption[0])) {
            return this;
        }
        String fileName = file.getFileName().toString();
        Path target = Paths.get(this.fullPath, fileName);
        if (Files.exists(target, new LinkOption[0]) || target.toAbsolutePath().toString().equals(file.toAbsolutePath().toString())) {
            if (FileUtils.contentEquals((File)target.toFile(), (File)file.toFile())) {
                return this;
            }
            throw new FileAlreadyExistsException("\u6587\u6863\u4e2d\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u6587\u4ef6\u8d44\u6e90(" + fileName + ")\uff0c\u8bf7\u91cd\u547d\u540d\u6587\u4ef6");
        }
        Files.copy(file, target, new CopyOption[0]);
        return this;
    }

    public VirtualContainer addRaw(String fileName, InputStream in) throws IOException {
        Path target = Paths.get(this.fullPath, fileName);
        byte[] buffer = new byte[4096];
        int n = 0;
        try (OutputStream out = Files.newOutputStream(target, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            while ((n = in.read(buffer)) != -1) {
                out.write(buffer, 0, n);
            }
        }
        return this;
    }

    public VirtualContainer putObj(String fileName, Element element) {
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (element == null) {
            return this;
        }
        while (element instanceof DefaultElementProxy) {
            element = ((DefaultElementProxy)element).getProxy();
        }
        this.fileCache.put(fileName, element);
        return this;
    }

    public Element getObj(String fileName) throws FileNotFoundException, DocumentException {
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Element element = this.fileCache.get(fileName);
        if (element == null) {
            Path file = this.getFile(fileName);
            element = ElemCup.inject(file);
            this.fileSrcHash.put(fileName, this.objectHash(element));
            this.fileCache.put(fileName, element);
        }
        return element;
    }

    private byte[] objectHash(Element element) throws DocumentException {
        try {
            if (this.digest == null) {
                this.digest = new SM3.Digest();
            }
            byte[] bin = ElemCup.dump(element);
            this.digest.reset();
            this.digest.update(bin);
            return this.digest.digest();
        }
        catch (IOException e) {
            throw new DocumentException("\u6587\u6863\u8ba1\u7b97\u6458\u8981\u8fc7\u7a0b\u4e2d\u5f02\u5e38", (Throwable)e);
        }
    }

    private boolean fileChanged(String filename, Element element) {
        if (this.digest == null) {
            return true;
        }
        byte[] srcHash = this.fileSrcHash.get(filename);
        if (srcHash == null) {
            return true;
        }
        try {
            byte[] nowHash = this.objectHash(element);
            return !Arrays.equals(srcHash, nowHash);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }

    public Path getFile(String fileName) throws FileNotFoundException {
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("\u6587\u4ef6\u540d\u4e3a\u7a7a");
        }
        Path res = Paths.get(this.fullPath, fileName);
        if (Files.isDirectory(res, new LinkOption[0]) || Files.notExists(res, new LinkOption[0])) {
            throw new FileNotFoundException("\u65e0\u6cd5\u5728\u76ee\u5f55: " + this.fullPath + "\u4e2d\u627e\u5230\uff0c\u6587\u4ef6 [ " + fileName + " ]");
        }
        return res;
    }

    public <R extends VirtualContainer> R obtainContainer(String name, Function<Path, R> mapper) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("\u5bb9\u5668\u540d\u79f0\uff08name\uff09\u4e3a\u7a7a");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("\u5bb9\u5668\u6784\u5efa\u5bf9\u8c61\uff08mapper\uff09\u4e3a\u7a7a");
        }
        VirtualContainer target = this.dirCache.get(name);
        if (target == null) {
            Path p = Paths.get(this.fullPath, name);
            VirtualContainer ct = (VirtualContainer)mapper.apply(p);
            ct.setParent(this);
            this.dirCache.put(name, ct);
            return (R)ct;
        }
        return (R)target;
    }

    public <R extends VirtualContainer> R getContainer(String name, Function<Path, R> mapper) throws FileNotFoundException {
        Path p = Paths.get(this.fullPath, name);
        if (Files.notExists(p, new LinkOption[0]) || !Files.isDirectory(p, new LinkOption[0])) {
            throw new FileNotFoundException("\u5bb9\u5668\u5185\u65e0\u6cd5\u627e\u540d\u4e3a\uff1a" + name + "\u76ee\u5f55");
        }
        VirtualContainer target = this.dirCache.get(name);
        if (target == null) {
            VirtualContainer ct = (VirtualContainer)mapper.apply(p);
            ct.setParent(this);
            this.dirCache.put(name, ct);
            return (R)ct;
        }
        return (R)target;
    }

    public VirtualContainer getParent() {
        return this.parent;
    }

    protected VirtualContainer setParent(VirtualContainer parent) {
        this.parent = parent;
        return this;
    }

    public Path getContainerPath() {
        return Paths.get(this.fullPath, new String[0]);
    }

    public boolean exit(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return false;
        }
        Element element = this.fileCache.get(fileName);
        if (element == null) {
            Path res = Paths.get(this.fullPath, fileName);
            return !Files.isDirectory(res, new LinkOption[0]) && !Files.notExists(res, new LinkOption[0]);
        }
        return true;
    }

    public void clean() {
        try {
            Path path = this.getContainerPath();
            if (Files.exists(path, new LinkOption[0])) {
                FileUtils.deleteDirectory((File)path.toFile());
            }
            this.fileCache.clear();
            this.dirCache.clear();
        }
        catch (Exception e) {
            System.err.println("\u5bb9\u5668\u5220\u9664\u5f02\u5e38: " + e.getMessage());
        }
    }

    public void flush() throws IOException {
        for (Map.Entry<String, Element> kv : this.fileCache.entrySet()) {
            String filename = kv.getKey();
            Path filePath = Paths.get(this.fullPath, filename);
            Element element = kv.getValue();
            if (!this.fileChanged(filename, element)) continue;
            ElemCup.dumpUpNS(element, filePath);
        }
        for (VirtualContainer container : this.dirCache.values()) {
            container.flush();
        }
        this.fileCache.clear();
        this.dirCache.clear();
    }

    public VirtualContainer flushContainerByName(String name) throws IOException {
        if (name == null || name.trim().isEmpty()) {
            return this;
        }
        VirtualContainer virtualContainer = this.dirCache.get(name);
        if (virtualContainer != null) {
            virtualContainer.flush();
        }
        return this;
    }

    public VirtualContainer flushFileByName(String name) throws IOException {
        if (name == null || name.trim().isEmpty()) {
            return this;
        }
        Element element = this.fileCache.get(name);
        if (element != null) {
            Path filePath = Paths.get(this.fullPath, name);
            if (this.fileChanged(name, element)) {
                ElemCup.dumpUpNS(element, filePath);
            }
        }
        return this;
    }

    public ST_Loc getAbsLoc() {
        ST_Loc absRes = null;
        absRes = this.parent == this ? new ST_Loc("/") : this.parent.getAbsLoc().cat(this.name);
        return absRes;
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }
}

