/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.reader;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.utils.IOUtils;

public class ZipUtil {
    private static long MaxSize = 0x6400000L;

    public static void setMaxSize(long size) {
        if (size <= 0L) {
            size = 0x6400000L;
        }
        MaxSize = size;
    }

    public static void unZipFiles(String zipPath, String descDir) throws IOException {
        ZipUtil.unZipFiles(new File(zipPath), descDir);
    }

    public static void unZipFiles(InputStream src, String descDir) throws IOException {
        ZipEntry entry;
        File pathFile = new File(descDir).getCanonicalFile();
        if (!pathFile.exists()) {
            pathFile.mkdirs();
        }
        int countByteNumber = 0;
        ZipInputStream zip = new ZipInputStream(src, Charset.forName("GBK"));
        while ((entry = zip.getNextEntry()) != null) {
            int num;
            String name = entry.getName();
            File file = new File(pathFile, name).getCanonicalFile();
            ZipUtil.pathValid(pathFile.getAbsolutePath(), file.getAbsolutePath());
            if (entry.isDirectory()) {
                file.mkdirs();
                continue;
            }
            File dir = file.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            byte[] buf = new byte[1024];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((num = zip.read(buf, 0, buf.length)) != -1) {
                if ((long)(countByteNumber + num) > MaxSize) {
                    throw new IOException(String.format("\u5199\u5165\u6570\u636e\u8d85\u51faZIP\u89e3\u538b\u6700\u5927\u5b57\u8282\u6570(%s)\u9650\u5236\uff01", MaxSize));
                }
                bos.write(buf, 0, num);
                countByteNumber += num;
            }
            Files.write(Paths.get(file.getAbsolutePath(), new String[0]), bos.toByteArray(), new OpenOption[0]);
        }
    }

    public static void unZipFiles(File zipFile, String descDir) throws IOException {
        ZipUtil.unZipFileByApacheCommonCompress(zipFile, descDir);
    }

    private static void pathValid(String targetDir, String filePath) throws IOException {
        if (!filePath.startsWith(targetDir)) {
            throw new IOException(String.format("\u4e0d\u5408\u6cd5\u7684\u8def\u5f84\uff1a%s", filePath));
        }
    }

    public static void unZipFileByApacheCommonCompress(File srcFile, String descDir) throws IOException {
        File pathFile = new File(descDir).getCanonicalFile();
        if (!pathFile.exists() && !pathFile.mkdirs()) {
            throw new IOException("\u89e3\u538b\u76ee\u5f55\u521b\u5efa\u5931\u8d25: " + pathFile);
        }
        try (ZipFile zipFile = new ZipFile(srcFile);){
            ZipEntry entry = null;
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                File f = new File(pathFile, entry.getName());
                if (entry.isDirectory()) {
                    if (f.isDirectory() || f.mkdirs()) continue;
                    throw new IOException("failed to create directory " + f);
                }
                File parent = f.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    throw new IOException("failed to create directory " + parent);
                }
                OutputStream o = Files.newOutputStream(f.toPath(), new OpenOption[0]);
                Throwable throwable = null;
                try {
                    IOUtils.copy((InputStream)zipFile.getInputStream(entry), (OutputStream)o);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (o == null) continue;
                    if (throwable != null) {
                        try {
                            o.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    o.close();
                }
            }
        }
    }
}

