/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.reader;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipUtil {
    private static final int MaxSize = 0x6400000;

    public static void unZipFiles(String zipPath, String descDir) throws IOException {
        ZipUtil.unZipFiles(new File(zipPath), descDir);
    }

    public static void unZipFiles(InputStream src, String descDir) throws IOException {
        ZipEntry entry;
        File pathFile = new File(descDir).getCanonicalFile();
        if (!pathFile.exists()) {
            pathFile.mkdirs();
        }
        int countByteNumber = 0;
        ZipInputStream zip = new ZipInputStream(src, Charset.forName("GBK"));
        while ((entry = zip.getNextEntry()) != null) {
            int num;
            String name = entry.getName();
            File file = new File(pathFile, name).getCanonicalFile();
            ZipUtil.pathValid(pathFile.getAbsolutePath(), file.getAbsolutePath());
            if (entry.isDirectory()) {
                file.mkdirs();
                continue;
            }
            File dir = file.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            byte[] buf = new byte[1024];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((num = zip.read(buf, 0, buf.length)) != -1) {
                if (countByteNumber + num > 0x6400000) {
                    throw new IOException(String.format("\u5199\u5165\u6570\u636e\u8d85\u51faZIP\u89e3\u538b\u6700\u5927\u5b57\u8282\u6570(%s)\u9650\u5236\uff01", 0x6400000));
                }
                bos.write(buf, 0, num);
                countByteNumber += num;
            }
            Files.write(Paths.get(file.getAbsolutePath(), new String[0]), bos.toByteArray(), new OpenOption[0]);
        }
    }

    public static void unZipFiles(File zipFile, String descDir) throws IOException {
        try (FileInputStream in = new FileInputStream(zipFile);){
            ZipUtil.unZipFiles(in, descDir);
        }
    }

    private static void pathValid(String targetDir, String filePath) throws IOException {
        if (!filePath.startsWith(targetDir)) {
            throw new IOException(String.format("\u4e0d\u5408\u6cd5\u7684\u8def\u5f84\uff1a%s", filePath));
        }
    }
}

