/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.reader;

import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.pkg.container.DocDir;
import org.ofdrw.pkg.container.OFDDir;
import org.ofdrw.pkg.container.PageDir;
import org.ofdrw.pkg.container.PagesDir;
import org.ofdrw.pkg.container.ResDir;
import org.ofdrw.pkg.container.SignDir;
import org.ofdrw.pkg.container.SignsDir;
import org.ofdrw.pkg.container.VirtualContainer;
import org.ofdrw.reader.ErrorPathException;

public class ResourceLocator {
    public static Pattern PtDoc = Pattern.compile("/(Doc_\\d+)");
    public static Pattern PtSigns = Pattern.compile("/(Doc_\\d+)/Signs");
    public static Pattern PtSign = Pattern.compile("/(Doc_\\d+)/Signs/(Sign_\\d+)");
    public static Pattern PtPages = Pattern.compile("/(Doc_\\d+)/Pages");
    public static Pattern PtPage = Pattern.compile("/(Doc_\\d+)/Pages/(Page_\\d+)");
    public static Pattern PtPageRes = Pattern.compile("/(Doc_\\d+)/Pages/(Page_\\d+)/Res");
    public static Pattern PtDocRes = Pattern.compile("/(Doc_\\d+)/Res");
    private OFDDir ofdDir;
    private LinkedList<String> workDir = new LinkedList();
    private LinkedList<LinkedList<String>> savedStack = new LinkedList();

    private ResourceLocator() {
    }

    public ResourceLocator(OFDDir ofdDir) {
        this.ofdDir = ofdDir;
        this.workDir.add("/");
    }

    public ResourceLocator(VirtualContainer vc) {
        VirtualContainer p;
        for (p = vc; p != p.getParent(); p = p.getParent()) {
        }
        this.ofdDir = (OFDDir)p;
        this.cd(vc.getAbsLoc().getLoc());
    }

    public ResourceLocator save() {
        LinkedList<String> toBeSaveWd = new LinkedList<String>(this.workDir);
        this.savedStack.addFirst(toBeSaveWd);
        return this;
    }

    public ResourceLocator restore() {
        if (!this.savedStack.isEmpty()) {
            this.workDir.clear();
            LinkedList<String> lastSaved = this.savedStack.removeFirst();
            this.workDir.addAll(lastSaved);
        }
        return this;
    }

    public String toAbsolutePath(ST_Loc path) {
        if (path == null) {
            return this.pwd();
        }
        return this.toAbsolutePath(path.getLoc());
    }

    public String toAbsolutePath(String path) {
        if (path == null || path.trim().isEmpty()) {
            return this.pwd();
        }
        LinkedList<String> workDirCopy = new LinkedList<String>(this.workDir);
        if (path.startsWith("/")) {
            workDirCopy.clear();
            workDirCopy.add("/");
        }
        for (String item : path.split("/")) {
            if ((item = item.trim()).equals(".") || item.isEmpty()) continue;
            if (item.equals("..")) {
                workDirCopy.removeLast();
                if (!workDirCopy.isEmpty()) continue;
                workDirCopy.add("/");
                continue;
            }
            workDirCopy.add(item);
        }
        return this.pwd(workDirCopy);
    }

    public ResourceLocator restWd() {
        return this.cd("/");
    }

    public ResourceLocator cd(VirtualContainer vc) {
        if (vc == null) {
            throw new IllegalArgumentException("\u6539\u53d8\u76ee\u5f55\u7684\u5bb9\u5668\u5bf9\u8c61\uff08vc\uff09\u4e3a\u7a7a");
        }
        return this.cd(vc.getAbsLoc().getLoc());
    }

    public ResourceLocator cd(String path) {
        return this.cd(this.workDir, path);
    }

    public ResourceLocator cd(LinkedList<String> workDir, String path) {
        if (path == null || path.equals("")) {
            return this;
        }
        if ((path = path.trim()).equals("/")) {
            workDir.clear();
            workDir.add("/");
            return this;
        }
        String absPath = this.toAbsolutePath(path);
        String ofwTmp = this.ofdDir.getSysAbsPath();
        Path sysPath = Paths.get(ofwTmp + absPath, new String[0]);
        if (Files.exists(sysPath, new LinkOption[0]) && Files.isDirectory(sysPath, new LinkOption[0])) {
            workDir.clear();
            workDir.add("/");
            for (String item : absPath.split("/")) {
                if ((item = item.trim()).isEmpty()) continue;
                workDir.add(item);
            }
        } else {
            throw new ErrorPathException("\u65e0\u6cd5\u5207\u6362\u8def\u5f84\u5230" + path + "\uff0c\u76ee\u5f55\u4e0d\u5b58\u5728\u3002");
        }
        return this;
    }

    public boolean exist(String path) {
        String ofwTmp = this.ofdDir.getSysAbsPath();
        String fullPath = "";
        fullPath = path.startsWith("/") ? ofwTmp + path : Paths.get(ofwTmp, this.pwd(), path).toAbsolutePath().toString();
        return Files.exists(Paths.get(fullPath, new String[0]), new LinkOption[0]);
    }

    public boolean exist(LinkedList<String> workDir) {
        String pwd = this.pwd(workDir);
        String ofwTmp = this.ofdDir.getSysAbsPath();
        Path path = Paths.get(ofwTmp + pwd, new String[0]);
        return Files.exists(path, new LinkOption[0]);
    }

    public boolean dirExit(LinkedList<String> workDir) {
        String pwd = this.pwd(workDir);
        String ofwTmp = this.ofdDir.getSysAbsPath();
        Path path = Paths.get(ofwTmp + pwd, new String[0]);
        return Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]);
    }

    public String pwd() {
        return this.pwd(this.workDir);
    }

    public String pwd(List<String> workDir) {
        if (workDir.size() == 1) {
            return "/";
        }
        StringBuilder sb = new StringBuilder();
        int len = workDir.size();
        for (int i = 0; i < len; ++i) {
            String item = workDir.get(i);
            if ((item = item.trim()).isEmpty()) continue;
            sb.append(item);
            if (item.equals("/") || i == len - 1) continue;
            sb.append("/");
        }
        return sb.toString();
    }

    public ST_Loc getAbsTo(ST_Loc to) {
        String fileName;
        if (to == null) {
            return new ST_Loc(this.pwd());
        }
        String loc = to.getLoc();
        if (loc.startsWith("/")) {
            return new ST_Loc(loc);
        }
        LinkedList<String> wd = new LinkedList<String>(this.workDir);
        int indexOf = loc.lastIndexOf(47);
        if (indexOf != -1) {
            this.cd(wd, loc.substring(0, indexOf + 1));
            fileName = loc.substring(indexOf + 1);
        } else {
            fileName = loc;
        }
        String p = this.pwd(wd);
        loc = p.endsWith("/") ? p + fileName : p + "/" + fileName;
        return new ST_Loc(loc);
    }

    public <R> R get(ST_Loc loc, Function<Element, R> mapper) throws FileNotFoundException, DocumentException {
        return this.get(loc.getLoc(), mapper);
    }

    public <R> R get(String loc, Function<Element, R> mapper) throws FileNotFoundException, DocumentException {
        String fileName;
        if (loc == null || loc.trim().equals("")) {
            throw new FileNotFoundException("\u8def\u5f84\u4e3a\u7a7a\uff08loc\uff09");
        }
        LinkedList<String> wd = new LinkedList<String>(this.workDir);
        int indexOf = loc.lastIndexOf(47);
        if (indexOf != -1) {
            this.cd(wd, loc.substring(0, indexOf + 1));
            fileName = loc.substring(indexOf + 1);
        } else {
            fileName = loc;
        }
        VirtualContainer vc = this.getContainer(wd);
        Element element = vc.getObj(fileName);
        return mapper.apply(element);
    }

    public Path getFile(ST_Loc stLoc) throws FileNotFoundException {
        String loc = stLoc.getLoc();
        return this.getFile(loc);
    }

    public Path getFile(String loc) throws FileNotFoundException {
        String fileName;
        if (loc == null || loc.trim().equals("")) {
            throw new FileNotFoundException("\u8def\u5f84\u4e3a\u7a7a\uff08loc\uff09");
        }
        LinkedList<String> wd = new LinkedList<String>(this.workDir);
        int indexOf = loc.lastIndexOf(47);
        if (indexOf != -1) {
            this.cd(wd, loc.substring(0, indexOf + 1));
            fileName = loc.substring(indexOf + 1);
        } else {
            fileName = loc;
        }
        VirtualContainer vc = this.getContainer(wd);
        return vc.getFile(fileName);
    }

    public VirtualContainer getContainer(LinkedList<String> workDir) throws FileNotFoundException {
        OFDDir vc = this.ofdDir;
        for (String item : workDir) {
            if (item.equals("/")) continue;
            if (item.startsWith("Doc_")) {
                vc = vc.getContainer(item, DocDir::new);
                continue;
            }
            if (item.equals("Signs")) {
                vc = vc.getContainer(item, SignsDir::new);
                continue;
            }
            if (item.startsWith("Sign_")) {
                vc = vc.getContainer(item, SignDir::new);
                continue;
            }
            if (item.equals("Pages")) {
                vc = vc.getContainer(item, PagesDir::new);
                continue;
            }
            if (item.startsWith("Page_")) {
                vc = vc.getContainer(item, PageDir::new);
                continue;
            }
            if (item.equals("Res")) {
                vc = vc.getContainer(item, ResDir::new);
                continue;
            }
            vc = vc.getContainer(item, VirtualContainer::new);
        }
        return vc;
    }

    public VirtualContainer getContainer(String containerPath) throws FileNotFoundException {
        this.save();
        try {
            this.cd(containerPath);
            VirtualContainer virtualContainer = this.getContainer(this.workDir);
            return virtualContainer;
        }
        finally {
            this.restore();
        }
    }

    public String toString() {
        return this.pwd();
    }
}

