/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.reader;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ZipUtil {
    public static void unZipFiles(String zipPath, String descDir) throws IOException {
        ZipUtil.unZipFiles(new File(zipPath), descDir);
    }

    public static void unZipFiles(InputStream src, String descDir) throws IOException {
        ZipEntry entry;
        File pathFile = new File(descDir);
        if (!pathFile.exists()) {
            pathFile.mkdirs();
        }
        ZipInputStream zip = new ZipInputStream(src, Charset.forName("GBK"));
        while ((entry = zip.getNextEntry()) != null) {
            File dir;
            int num;
            String name = entry.getName();
            byte[] buf = new byte[1024];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((num = zip.read(buf, 0, buf.length)) != -1) {
                bos.write(buf, 0, num);
            }
            Path path = Paths.get(descDir, name);
            if (entry.isDirectory()) {
                dir = new File(path.toString());
                dir.mkdirs();
                continue;
            }
            dir = new File(path.toString()).getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            Files.write(path, bos.toByteArray(), new OpenOption[0]);
        }
    }

    public static void unZipFiles(File zipFile, String descDir) throws IOException {
        File pathFile = new File(descDir);
        if (!pathFile.exists()) {
            pathFile.mkdirs();
        }
        try (ZipFile zip = new ZipFile(zipFile, Charset.forName("GBK"));){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String zipEntryName = entry.getName();
                InputStream in = zip.getInputStream(entry);
                Throwable throwable = null;
                try {
                    File file;
                    String outPath = (descDir + zipEntryName).replaceAll("\\*", "/");
                    int vIndex = outPath.lastIndexOf(47);
                    if (vIndex == -1) {
                        file = new File(outPath);
                    } else {
                        file = new File(outPath.substring(0, vIndex));
                        if (!file.exists()) {
                            file.mkdirs();
                        }
                    }
                    if (new File(outPath).isDirectory()) continue;
                    FileOutputStream out = new FileOutputStream(outPath);
                    Throwable throwable2 = null;
                    try {
                        int len;
                        byte[] buf1 = new byte[1024];
                        while ((len = in.read(buf1)) > 0) {
                            ((OutputStream)out).write(buf1, 0, len);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((OutputStream)out).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
    }
}

