/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.reader.keyword;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.TextAttribute;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.DocumentException;
import org.ofdrw.core.basicStructure.doc.Document;
import org.ofdrw.core.basicStructure.ofd.OFD;
import org.ofdrw.core.basicStructure.pageObj.CT_TemplatePage;
import org.ofdrw.core.basicStructure.pageObj.Page;
import org.ofdrw.core.basicStructure.pageObj.Template;
import org.ofdrw.core.basicStructure.pageObj.layer.CT_Layer;
import org.ofdrw.core.basicStructure.pageObj.layer.PageBlockType;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CT_PageBlock;
import org.ofdrw.core.basicStructure.pageObj.layer.block.TextObject;
import org.ofdrw.core.basicStructure.res.Res;
import org.ofdrw.core.basicStructure.res.resources.Fonts;
import org.ofdrw.core.basicType.ST_Array;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.basicType.ST_ID;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.core.basicType.ST_Pos;
import org.ofdrw.core.text.TextCode;
import org.ofdrw.core.text.font.CT_Font;
import org.ofdrw.core.text.text.CT_Text;
import org.ofdrw.reader.DeltaTool;
import org.ofdrw.reader.OFDReader;
import org.ofdrw.reader.ResourceLocator;
import org.ofdrw.reader.keyword.KeywordPosition;
import org.ofdrw.reader.keyword.KeywordResource;
import sun.font.FontDesignMetrics;

public class KeywordExtractor {
    private static final float POINT_PER_MM = 2.8346457f;

    public static List<KeywordPosition> getKeyWordPositionList(OFDReader reader, String keyword) throws FileNotFoundException, DocumentException {
        return KeywordExtractor.getKeyWordPositionList(reader, keyword, null);
    }

    public static List<KeywordPosition> getKeyWordPositionList(OFDReader reader, String[] keywords) throws FileNotFoundException, DocumentException {
        return KeywordExtractor.getKeyWordPositionList(reader, keywords, null);
    }

    public static List<KeywordPosition> getKeyWordPositionList(OFDReader reader, String keyword, int[] pages) throws FileNotFoundException, DocumentException {
        return KeywordExtractor.getKeyWordPositionList(reader, new String[]{keyword}, pages);
    }

    public static List<KeywordPosition> getKeyWordPositionList(OFDReader reader, String[] keywords, int[] pages) throws FileNotFoundException, DocumentException {
        boolean hasPageLimit;
        HashMap<TextCode, KeywordResource> boundaryMapping = new HashMap<TextCode, KeywordResource>(8);
        ResourceLocator locator = reader.getResourceLocator();
        OFD ofd = locator.get("OFD.xml", OFD::new);
        String docFile = ofd.getDocBody().getDocRoot().getLoc();
        Document document = locator.get(docFile, Document::new);
        String dataDir = docFile.split("/")[0];
        Map<ST_ID, CT_Font> fontMapping = KeywordExtractor.getFontMapping(locator, dataDir, document);
        Map<ST_ID, Page> templatePage = KeywordExtractor.getTemplatePage(locator, dataDir, document);
        ArrayList<TextCode> textCodeList = new ArrayList<TextCode>();
        int numberOfPages = reader.getNumberOfPages();
        boolean bl = hasPageLimit = pages != null && pages.length > 0;
        if (hasPageLimit) {
            for (int page : pages) {
                if (page >= 1 && page <= numberOfPages) continue;
                throw new IllegalArgumentException(String.format("\u9875\u7801\u4e0d\u6b63\u786e\uff0c\u652f\u6301\u8303\u56f4[%d-%d]", 1, numberOfPages));
            }
        }
        block1: for (int page = 1; page <= numberOfPages; ++page) {
            if (hasPageLimit) {
                for (int i : pages) {
                    if (i != page) continue;
                    KeywordExtractor.preparedContextData(reader, textCodeList, boundaryMapping, fontMapping, templatePage, page);
                    continue block1;
                }
                continue;
            }
            KeywordExtractor.preparedContextData(reader, textCodeList, boundaryMapping, fontMapping, templatePage, page);
        }
        ArrayList<KeywordPosition> positionList = new ArrayList<KeywordPosition>();
        for (int i = 0; i < textCodeList.size(); ++i) {
            String content;
            TextCode textCode = (TextCode)textCodeList.get(i);
            if (textCode == null || (content = textCode.getContent()) == null || "".equals(content.trim())) continue;
            for (String keyword : keywords) {
                int textIndex = content.indexOf(keyword);
                if (textIndex != -1) {
                    KeywordExtractor.addNormalKeyword(keyword, boundaryMapping, positionList, textCode, textIndex);
                    continue;
                }
                if (keyword.indexOf(content) == 0 && i != textCodeList.size() - 1) {
                    KeywordExtractor.addPrefixBreakTextCodeList(keyword, boundaryMapping, textCodeList, positionList, i, textCode);
                    continue;
                }
                int startIndex = KeywordExtractor.checkPostfixMatch(content, keyword);
                if (startIndex == -1) continue;
                KeywordExtractor.addPostfixBreakTextCodeList(keyword, boundaryMapping, textCodeList, positionList, i, startIndex, textCode);
            }
        }
        return positionList;
    }

    private static int checkPostfixMatch(String content, String keyword) {
        boolean match = true;
        int startIndex = content.lastIndexOf(keyword.charAt(0));
        if (startIndex != -1) {
            int j = startIndex;
            int k = 0;
            while (j < content.length()) {
                if (content.charAt(j) != keyword.charAt(k)) {
                    match = false;
                    break;
                }
                ++j;
                ++k;
            }
        }
        return match ? startIndex : -1;
    }

    private static void addPostfixBreakTextCodeList(String keyword, Map<TextCode, KeywordResource> boundaryMapping, List<TextCode> textCodeList, List<KeywordPosition> positionList, int textCodeIndex, int startIndex, TextCode textCode) {
        ArrayList<TextCode> mergeTextCodeList = new ArrayList<TextCode>();
        mergeTextCodeList.add(textCode);
        KeywordExtractor.searchNextText(keyword, textCodeList, mergeTextCodeList, boundaryMapping, textCodeIndex, textCode.getContent().substring(startIndex), textCode);
        StringBuilder builder = new StringBuilder();
        for (TextCode code : mergeTextCodeList) {
            builder.append(code.getContent());
        }
        if (builder.indexOf(keyword) != -1) {
            KeywordExtractor.mergeKeywordPosition(keyword, startIndex, positionList, mergeTextCodeList, boundaryMapping);
        }
    }

    private static void addPrefixBreakTextCodeList(String keyword, Map<TextCode, KeywordResource> boundaryMapping, List<TextCode> textCodeList, List<KeywordPosition> positionList, int textCodeIndex, TextCode textCode) {
        ArrayList<TextCode> mergeTextCodeList = new ArrayList<TextCode>();
        mergeTextCodeList.add(textCode);
        KeywordExtractor.searchNextText(keyword, textCodeList, mergeTextCodeList, boundaryMapping, textCodeIndex, textCode.getContent(), textCode);
        StringBuilder builder = new StringBuilder();
        for (TextCode code : mergeTextCodeList) {
            builder.append(code.getContent());
        }
        if (builder.indexOf(keyword) != -1) {
            KeywordExtractor.mergeKeywordPosition(keyword, 0, positionList, mergeTextCodeList, boundaryMapping);
        }
    }

    private static void searchNextText(String keyword, List<TextCode> textCodeList, List<TextCode> mergeTextCodeList, Map<TextCode, KeywordResource> boundaryMapping, int textCodeIndex, String firstMatchString, TextCode textCode) {
        StringBuilder mergeText = new StringBuilder(firstMatchString);
        KeywordResource kr = boundaryMapping.get(textCode);
        if (kr != null) {
            int currentPage = kr.getPage();
            for (int j = textCodeIndex + 1; j < textCodeList.size(); ++j) {
                KeywordResource nextKr;
                TextCode next = textCodeList.get(j);
                if ("".equals(next.getContent().trim()) || (nextKr = boundaryMapping.get(next)) == null) continue;
                if (currentPage != nextKr.getPage()) break;
                mergeText.append(next.getContent());
                String mergeTextString = mergeText.toString();
                if (mergeTextString.equals(keyword) || mergeTextString.startsWith(keyword)) {
                    mergeTextCodeList.add(next);
                    break;
                }
                if (!keyword.startsWith(mergeTextString)) break;
                mergeTextCodeList.add(next);
            }
        }
    }

    private static void addNormalKeyword(String keyword, Map<TextCode, KeywordResource> boundaryMapping, List<KeywordPosition> positionList, TextCode textCode, int textIndex) {
        CT_Text ctText;
        KeywordResource kr = boundaryMapping.get(textCode);
        if (kr != null && (ctText = kr.getText()).getBoundary() != null) {
            FontDesignMetrics fontMetrics = FontDesignMetrics.getMetrics(KeywordExtractor.getFont(ctText, kr.getFont()));
            List<Float> deltaX = DeltaTool.getDelta(textCode.getDeltaX(), textCode.getContent().length());
            List<Float> deltaY = DeltaTool.getDelta(textCode.getDeltaY(), textCode.getContent().length());
            ST_Array ctm = ctText.getCTM();
            int keywordLength = keyword.length();
            KeywordPosition position = ctm != null ? KeywordExtractor.getCtmKeywordPosition(textCode, textIndex, kr.getPage(), ctText, fontMetrics, ctm, deltaX, deltaY, keywordLength) : KeywordExtractor.getKeywordPosition(textCode, textIndex, kr.getPage(), ctText, fontMetrics, deltaX, deltaY, keywordLength);
            position.setKeyword(keyword);
            positionList.add(position);
        }
    }

    private static KeywordPosition getCtmKeywordPosition(TextCode textCode, int textIndex, int page, CT_Text ctText, FontMetrics fontMetrics, ST_Array ctm, List<Float> deltaX, List<Float> deltaY, int keywordLength) {
        double height = (float)(fontMetrics.getAscent() - fontMetrics.getDescent()) / 2.8346457f;
        double[] matrix = KeywordExtractor.getMatrix(ctm);
        double x = textCode.getX();
        double y = textCode.getY();
        for (int i = 0; i < textIndex; ++i) {
            if (deltaX.size() > i) {
                x += (double)deltaX.get(i).floatValue();
            }
            if (deltaY.size() <= i) continue;
            y += (double)deltaY.get(i).floatValue();
        }
        double stringWidth = KeywordExtractor.getStringWidth(textIndex, keywordLength, deltaX, ctText.getSize());
        ST_Pos leftTop = KeywordExtractor.transform(matrix, x, y - height);
        ST_Pos leftBottom = KeywordExtractor.transform(matrix, x, y);
        ST_Pos rightTop = KeywordExtractor.transform(matrix, x + stringWidth, y - height);
        ST_Pos rightBottom = KeywordExtractor.transform(matrix, x + stringWidth, y);
        ST_Box ctmBox = KeywordExtractor.mergePos(leftTop, leftBottom, rightTop, rightBottom);
        ctmBox.setTopLeftX(Double.valueOf(ctmBox.getTopLeftX() + ctText.getBoundary().getTopLeftX()));
        ctmBox.setTopLeftY(Double.valueOf(ctmBox.getTopLeftY() + ctText.getBoundary().getTopLeftY()));
        return new KeywordPosition(page, ctmBox);
    }

    private static ST_Box mergePos(ST_Pos ... posList) {
        double topLeftX = 0.0;
        double topLeftY = 0.0;
        double bottomRightX = 0.0;
        double bottomRightY = 0.0;
        for (int i = 0; i < posList.length; ++i) {
            ST_Pos pos = posList[i];
            if (i == 0) {
                topLeftX = bottomRightX = pos.getX().doubleValue();
                topLeftY = bottomRightY = pos.getY().doubleValue();
            }
            if (topLeftX > pos.getX()) {
                topLeftX = pos.getX();
            }
            if (topLeftY > pos.getY()) {
                topLeftY = pos.getY();
            }
            if (bottomRightX < pos.getX()) {
                bottomRightX = pos.getX();
            }
            if (!(bottomRightY < pos.getY())) continue;
            bottomRightY = pos.getY();
        }
        return new ST_Box(topLeftX, topLeftY, bottomRightX - topLeftX, bottomRightY - topLeftY);
    }

    private static ST_Pos transform(double[] matrix, double sx, double sy) {
        double x = matrix[0] * sx + matrix[2] * sy + matrix[4];
        double y = matrix[1] * sx + matrix[3] * sy + matrix[5];
        return new ST_Pos(x, y);
    }

    private static double[] getMatrix(ST_Array ctm) {
        List ctmArray = ctm.getArray();
        double[] matrix = new double[ctmArray.size()];
        for (int i = 0; i < ctmArray.size(); ++i) {
            matrix[i] = Double.valueOf((String)ctmArray.get(i));
        }
        return matrix;
    }

    private static void mergeKeywordPosition(String keyword, int firstStartIndex, List<KeywordPosition> positionList, List<TextCode> textCodeList, Map<TextCode, KeywordResource> boundaryMapping) {
        ArrayList<ST_Box> boxList = new ArrayList<ST_Box>();
        FontMetrics fontMetrics = null;
        int page = 0;
        int totalLength = 0;
        int keywordLength = keyword.length();
        int fontSize = 0;
        for (int i = 0; i < textCodeList.size(); ++i) {
            TextCode textCode = textCodeList.get(i);
            int textLength = textCode.getContent().length();
            KeywordResource kr = boundaryMapping.get(textCode);
            if (kr == null) continue;
            CT_Text ctText = kr.getText();
            if (page == 0) {
                page = kr.getPage();
            }
            if (ctText == null || ctText.getBoundary() == null) continue;
            if (i == 0 && firstStartIndex > 0) {
                textLength = totalLength = textCode.getContent().length() - firstStartIndex;
            } else if (totalLength + textLength > keywordLength) {
                textLength = keywordLength - totalLength;
            } else {
                totalLength += textCode.getContent().length();
            }
            List<Float> deltaX = DeltaTool.getDelta(textCode.getDeltaX(), textCode.getContent().length());
            List<Float> deltaY = DeltaTool.getDelta(textCode.getDeltaY(), textCode.getContent().length());
            double width = i == 0 && firstStartIndex > 0 ? KeywordExtractor.getStringWidth(firstStartIndex, textLength, deltaX, ctText.getSize()) : KeywordExtractor.getStringWidth(0, textLength, deltaX, ctText.getSize());
            if (width == 0.0) {
                width = kr.getText().getSize();
            }
            int size = ctText.getSize().intValue();
            if (fontMetrics == null || fontSize != size) {
                fontMetrics = FontDesignMetrics.getMetrics(KeywordExtractor.getFont(ctText, kr.getFont()));
                fontSize = size;
            }
            double height = (float)(fontMetrics.getAscent() - fontMetrics.getDescent()) / 2.8346457f;
            ST_Array ctm = ctText.getCTM();
            if (ctm != null) {
                int j;
                double y;
                double[] matrix = KeywordExtractor.getMatrix(ctm);
                double x = textCode.getX() == null ? 0.0 : textCode.getX();
                double d = y = textCode.getY() == null ? 0.0 : textCode.getY();
                if (i == 0 && firstStartIndex > 0 && deltaX.size() > 0) {
                    for (j = 0; j < firstStartIndex; ++j) {
                        x += (double)deltaX.get(j).floatValue();
                    }
                }
                if (i == 0 && firstStartIndex > 0 && deltaY.size() > 0) {
                    for (j = 0; j < firstStartIndex; ++j) {
                        y += (double)deltaY.get(j).floatValue();
                    }
                }
                ST_Pos leftBottom = KeywordExtractor.transform(matrix, x, y);
                ST_Pos rightTop = KeywordExtractor.transform(matrix, x + width, y - height);
                ST_Pos position = ctText.getBoundary().getTopLeftPos();
                ST_Box box = KeywordExtractor.mergePos(leftBottom, rightTop);
                box.setTopLeftX(Double.valueOf(position.getX() + box.getTopLeftX()));
                box.setTopLeftY(Double.valueOf(position.getY() + box.getTopLeftY()));
                boxList.add(box);
                continue;
            }
            ST_Pos basePoint = KeywordExtractor.getLeftBottomPos(ctText.getBoundary(), textCode, deltaX, deltaY, 0);
            if (i == 0 && firstStartIndex > 0 && deltaX.size() > 0) {
                for (int j = 0; j < firstStartIndex; ++j) {
                    basePoint.setX(Double.valueOf(basePoint.getX() + (double)deltaX.get(j).floatValue()));
                }
            }
            if (i == 0 && firstStartIndex > 0 && deltaY.size() > 0) {
                for (int j = 0; j < firstStartIndex; ++j) {
                    basePoint.setY(Double.valueOf(basePoint.getY() + (double)deltaY.get(j).floatValue()));
                }
            }
            boxList.add(new ST_Box(basePoint.getX().doubleValue(), basePoint.getY() - height, width, height));
        }
        if (boxList.size() > 0) {
            positionList.add(new KeywordPosition(page, KeywordExtractor.mergeBox(boxList)));
        }
    }

    private static ST_Box mergeBox(List<ST_Box> boxList) {
        double topLeftX = 0.0;
        double topLeftY = 0.0;
        double bottomRightX = 0.0;
        double bottomRightY = 0.0;
        for (int i = 0; i < boxList.size(); ++i) {
            ST_Box box = boxList.get(i);
            if (i == 0) {
                topLeftX = box.getTopLeftX();
                topLeftY = box.getTopLeftY();
            } else {
                if (box.getTopLeftX() < topLeftX) {
                    topLeftX = box.getTopLeftX();
                }
                if (box.getTopLeftY() < topLeftY) {
                    topLeftY = box.getTopLeftY();
                }
            }
            if (box.getTopLeftX() + box.getWidth() > bottomRightX) {
                bottomRightX = box.getTopLeftX() + box.getWidth();
            }
            if (!(box.getTopLeftY() + box.getHeight() > bottomRightY)) continue;
            bottomRightY = box.getTopLeftY() + box.getHeight();
        }
        return new ST_Box(topLeftX, topLeftY, bottomRightX - topLeftX, bottomRightY - topLeftY);
    }

    private static Map<ST_ID, Page> getTemplatePage(ResourceLocator locator, String dataDir, Document document) throws FileNotFoundException, DocumentException {
        HashMap<ST_ID, Page> templatePage = new HashMap<ST_ID, Page>(8);
        for (CT_TemplatePage tp : document.getCommonData().getTemplatePages()) {
            String templateFile = dataDir + "/" + tp.getBaseLoc();
            Page page = locator.get(templateFile, Page::new);
            templatePage.put(tp.getID(), page);
        }
        return templatePage;
    }

    private static KeywordPosition getKeywordPosition(TextCode textCode, int textIndex, int page, CT_Text ctText, FontMetrics fontMetrics, List<Float> deltaX, List<Float> deltaY, int keywordLength) {
        double width = KeywordExtractor.getStringWidth(textIndex, keywordLength, deltaX, ctText.getSize());
        double height = (float)(fontMetrics.getAscent() - fontMetrics.getDescent()) / 2.8346457f;
        if (!deltaY.isEmpty()) {
            for (int i = 0; i < deltaY.size() && i < keywordLength - 1; ++i) {
                height -= (double)deltaY.get(i).floatValue();
            }
        }
        ST_Pos basePoint = KeywordExtractor.getLeftBottomPos(ctText.getBoundary(), textCode, deltaX, deltaY, textIndex);
        ST_Box box = new ST_Box(basePoint.getX().doubleValue(), basePoint.getY() - height, width, height);
        return new KeywordPosition(page, box);
    }

    private static double getStringWidth(int textIndex, int keywordLength, List<Float> deltaX, Double fontSize) {
        double width = fontSize;
        for (int i = textIndex; i < textIndex + keywordLength - 1 && i < deltaX.size(); ++i) {
            width += (double)deltaX.get(i).floatValue();
        }
        return width;
    }

    private static Font getFont(CT_Text ctText, CT_Font ctFont) {
        if (ctFont == null) {
            ctFont = new CT_Font("\u9ed1\u4f53");
        }
        int fontSize = (int)(ctText.getSize() * 2.8346457481384277);
        Font font = ctText.getItalic() != false ? new Font(ctFont.getFontName(), 2, fontSize) : new Font(ctFont.getFontName(), 0, fontSize);
        Map<TextAttribute, ?> attributes = font.getAttributes();
        if (ctText.getHScale() != null) {
            attributes.put(TextAttribute.WIDTH, ctText.getHScale());
        }
        if (ctText.getWeight() != null) {
            attributes.put(TextAttribute.WEIGHT, ctText.getWeight().getWeight() / 100);
        }
        return Font.getFont(attributes);
    }

    private static ST_Pos getLeftBottomPos(ST_Box boundary, TextCode textCode, List<Float> deltaX, List<Float> deltaY, int textIndex) {
        ST_Pos position = boundary.getTopLeftPos();
        double positionX = position.getX() == null ? 0.0 : position.getX();
        double positionY = position.getY() == null ? 0.0 : position.getY();
        double x = (textCode.getX() == null ? 0.0 : textCode.getX()) + positionX;
        double y = (textCode.getY() == null ? 0.0 : textCode.getY()) + positionY;
        for (int i = 0; i < textIndex; ++i) {
            if (deltaX.size() > i) {
                x += (double)deltaX.get(i).floatValue();
            }
            if (deltaY.size() <= i) continue;
            y += (double)deltaY.get(i).floatValue();
        }
        return ST_Pos.getInstance((double)x, (double)y);
    }

    private static void preparedContextData(OFDReader reader, List<TextCode> textCodeList, Map<TextCode, KeywordResource> boundaryMapping, Map<ST_ID, CT_Font> fontMapping, Map<ST_ID, Page> templatePageMap, int pageNumber) {
        Page page = reader.getPage(pageNumber);
        List layers = page.getContent().getLayers();
        for (Template tpl : page.getTemplates()) {
            ST_ID templateId;
            Page templatePage = null;
            if (tpl != null && templatePageMap.containsKey(templateId = tpl.getTemplateID().getRefId())) {
                templatePage = templatePageMap.get(templateId);
            }
            if (templatePage == null) continue;
            layers.addAll(templatePage.getContent().getLayers());
        }
        for (CT_Layer layer : layers) {
            KeywordExtractor.pageBlockHandle(textCodeList, boundaryMapping, fontMapping, pageNumber, layer.getPageBlocks());
        }
    }

    private static void pageBlockHandle(List<TextCode> textCodeList, Map<TextCode, KeywordResource> boundaryMapping, Map<ST_ID, CT_Font> fontMapping, int pageNumber, List<PageBlockType> pageBlocks) {
        for (PageBlockType block : pageBlocks) {
            if (block instanceof TextObject) {
                TextObject text = (TextObject)block;
                CT_Font font = fontMapping.get(text.getFont().getRefId());
                for (TextCode code : text.getTextCodes()) {
                    KeywordResource kr = new KeywordResource();
                    kr.setPage(pageNumber);
                    kr.setFont(font);
                    kr.setText((CT_Text)text);
                    textCodeList.add(code);
                    boundaryMapping.put(code, kr);
                }
                continue;
            }
            if (!(block instanceof CT_PageBlock)) continue;
            CT_PageBlock ctPageBlock = (CT_PageBlock)block;
            KeywordExtractor.pageBlockHandle(textCodeList, boundaryMapping, fontMapping, pageNumber, ctPageBlock.getPageBlocks());
        }
    }

    private static Map<ST_ID, CT_Font> getFontMapping(ResourceLocator locator, String dataDir, Document document) throws FileNotFoundException, DocumentException {
        HashMap<ST_ID, CT_Font> fontMapping = new HashMap<ST_ID, CT_Font>(8);
        ST_Loc publicRes = document.getCommonData().getPublicRes();
        if (publicRes != null) {
            String resFile = dataDir + "/" + publicRes.getLoc();
            Res res = locator.get(resFile, Res::new);
            List fontsList = res.getFonts();
            for (Fonts font : fontsList) {
                List ctFontList = font.getFonts();
                for (CT_Font ctFont : ctFontList) {
                    fontMapping.put(ctFont.getID(), ctFont);
                }
            }
        }
        return fontMapping;
    }
}

