/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.reader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;

public class ZipUtil {
    private static String charset = "UTF8";

    @Deprecated
    public static void setMaxSize(long size) {
    }

    public static void setDefaultCharset(String charset) {
        ZipUtil.charset = charset;
    }

    public static void unZipFiles(String zipPath, String descDir) throws IOException {
        ZipUtil.unZipFiles(new File(zipPath), descDir);
    }

    public static void unZipFiles(InputStream src, String descDir) throws IOException {
        ZipUtil.unZipFileByApacheCommonCompress(src, descDir);
    }

    public static void unZipFiles(File zipFile, String descDir) throws IOException {
        ZipUtil.unZipFileByApacheCommonCompress(zipFile, descDir);
    }

    private static void pathValid(String targetDir, String filePath) throws IOException {
        if (!filePath.startsWith(targetDir)) {
            throw new IOException(String.format("\u4e0d\u5408\u6cd5\u7684\u8def\u5f84\uff1a%s", filePath));
        }
    }

    public static void unZipFileByApacheCommonCompress(File srcFile, String descDir) throws IOException {
        if (srcFile == null || !srcFile.exists()) {
            throw new IOException("\u89e3\u538b\u6587\u4ef6\u4e0d\u5b58\u5728: " + srcFile);
        }
        try (FileInputStream fin = new FileInputStream(srcFile);){
            ZipUtil.unZipFileByApacheCommonCompress(fin, descDir);
        }
    }

    public static void unZipFileByApacheCommonCompress(InputStream src, String descDir) throws IOException {
        File pathFile = new File(descDir).getCanonicalFile();
        if (!pathFile.exists() && !pathFile.mkdirs()) {
            throw new IOException("\u89e3\u538b\u76ee\u5f55\u521b\u5efa\u5931\u8d25: " + pathFile);
        }
        try (ZipArchiveInputStream zipFile = new ZipArchiveInputStream(src, charset);){
            ZipArchiveEntry entry = null;
            while ((entry = (ZipArchiveEntry)zipFile.getNextEntry()) != null) {
                File f = new File(pathFile, entry.getName()).getCanonicalFile();
                ZipUtil.pathValid(pathFile.getAbsolutePath(), f.getAbsolutePath());
                if (entry.isDirectory()) {
                    if (f.isDirectory() || f.mkdirs()) continue;
                    throw new IOException("failed to create directory " + f);
                }
                File parent = f.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    throw new IOException("failed to create directory " + parent);
                }
                OutputStream o = Files.newOutputStream(f.toPath(), new OpenOption[0]);
                Throwable throwable = null;
                try {
                    IOUtils.copy((InputStream)zipFile, (OutputStream)o);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (o == null) continue;
                    if (throwable != null) {
                        try {
                            o.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    o.close();
                }
            }
        }
    }
}

