/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.reader;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.ofdrw.core.basicStructure.pageObj.Page;
import org.ofdrw.core.basicStructure.pageObj.layer.CT_Layer;
import org.ofdrw.core.basicStructure.pageObj.layer.Type;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.basicType.ST_ID;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.reader.model.TemplatePageEntity;

public class PageInfo {
    private ST_Box size;
    private Page obj;
    private ST_ID id;
    private Integer index;
    private ArrayList<TemplatePageEntity> templates = new ArrayList();
    private ST_Loc pageAbsLoc;
    private Integer pageN;

    public ST_Box getSize() {
        return this.size;
    }

    public PageInfo setSize(ST_Box size) {
        this.size = size;
        return this;
    }

    public Page getObj() {
        return this.obj;
    }

    public PageInfo setObj(Page obj) {
        this.obj = obj;
        return this;
    }

    public ST_ID getId() {
        return this.id;
    }

    public PageInfo setId(ST_ID id) {
        this.id = id;
        return this;
    }

    public Integer getIndex() {
        return this.index;
    }

    public PageInfo setIndex(Integer index) {
        this.index = index;
        return this;
    }

    public ST_Loc getPageAbsLoc() {
        return this.pageAbsLoc;
    }

    public PageInfo setPageAbsLoc(ST_Loc pageAbsLoc) {
        this.pageAbsLoc = pageAbsLoc;
        return this;
    }

    public Integer getPageN() {
        return this.pageN;
    }

    public PageInfo setPageN(Integer pageN) {
        this.pageN = pageN;
        return this;
    }

    public List<Page> getOrderRelatedPageList() {
        ArrayList<TemplatePageEntity> res = new ArrayList<TemplatePageEntity>(this.templates);
        res.add(new TemplatePageEntity(Type.Body, this.obj));
        res.sort(Comparator.comparingInt(p -> p.getZOrder().order()));
        return res.stream().map(TemplatePageEntity::getPage).collect(Collectors.toList());
    }

    public List<CT_Layer> getAllLayer() {
        ArrayList<CT_Layer> layerList = new ArrayList<CT_Layer>();
        for (Page page : this.getOrderRelatedPageList()) {
            if (page.getContent() == null) continue;
            layerList.addAll(page.getContent().getOrderedLayers());
        }
        return layerList;
    }

    public PageInfo setTemplates(ArrayList<TemplatePageEntity> templates) {
        this.templates = templates;
        return this;
    }
}

