/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.sign.verify.container;

import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Signature;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.jcajce.provider.digest.SM3;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.ofdrw.core.signatures.SigType;
import org.ofdrw.gm.cert.CertTools;
import org.ofdrw.gm.sm2strut.IssuerAndSerialNumber;
import org.ofdrw.gm.sm2strut.SignedData;
import org.ofdrw.gm.sm2strut.SignerInfo;
import org.ofdrw.sign.verify.SignedDataValidateContainer;
import org.ofdrw.sign.verify.exceptions.InvalidSignedValueException;

public class GBT35275ValidateContainer
implements SignedDataValidateContainer {
    @Override
    public void validate(SigType type, String alg, byte[] tbsContent, byte[] signedValue) throws InvalidSignedValueException, GeneralSecurityException {
        byte[] plaintext;
        if (type != SigType.Sign) {
            throw new IllegalArgumentException("\u7b7e\u540d\u7c7b\u578b(type)\u5fc5\u987b\u662f Sign\uff0c\u4e0d\u652f\u6301\u7535\u5b50\u5370\u7ae0\u9a8c\u8bc1");
        }
        SignedData signedData = null;
        try {
            signedData = SignedData.getInstance((Object)signedValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (signedData == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u7b7e\u540d\u503c\u683c\u5f0f\uff0c\u4e0d\u7b26 GBT35275");
        }
        SM3.Digest md = new SM3.Digest();
        byte[] plaintextAct = md.digest(tbsContent);
        if (!Arrays.equals(plaintextAct, plaintext = DEROctetString.getInstance((Object)signedData.getContentInfo().getContent()).getOctets())) {
            throw new InvalidSignedValueException("\u5f85\u7b7e\u540d\u539f\u6587\u4e0d\u7b26");
        }
        for (ASN1Encodable item : signedData.getSignerInfos()) {
            SignerInfo signerInfo = SignerInfo.getInstance((Object)item);
            IssuerAndSerialNumber iaSn = signerInfo.getIssuerAngSerialNumber();
            Certificate c = signedData.getSignCert(iaSn);
            if (c == null) {
                throw new InvalidSignedValueException("\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u8bc1\u4e66\u65e0\u6cd5\u9a8c\u8bc1\u7b7e\u540d");
            }
            java.security.cert.Certificate cert = CertTools.obj((Certificate)c);
            Signature sg = Signature.getInstance(alg, (Provider)new BouncyCastleProvider());
            sg.initVerify(cert.getPublicKey());
            sg.update(plaintext);
            byte[] signature = signerInfo.getEncryptedDigest().getOctets();
            if (sg.verify(signature)) continue;
            throw new InvalidSignedValueException("\u7b7e\u540d\u503c\u4e0d\u4e00\u81f4");
        }
    }
}

