/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.sign;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.dom4j.DocumentException;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.core.signatures.SigType;
import org.ofdrw.core.signatures.Signature;
import org.ofdrw.core.signatures.Signatures;
import org.ofdrw.core.signatures.appearance.Seal;
import org.ofdrw.core.signatures.range.Reference;
import org.ofdrw.core.signatures.range.References;
import org.ofdrw.core.signatures.sig.Parameters;
import org.ofdrw.core.signatures.sig.Provider;
import org.ofdrw.core.signatures.sig.SignedInfo;
import org.ofdrw.pkg.container.OFDDir;
import org.ofdrw.pkg.container.SignDir;
import org.ofdrw.pkg.container.SignsDir;
import org.ofdrw.reader.BadOFDException;
import org.ofdrw.reader.OFDReader;
import org.ofdrw.reader.ResourceLocator;
import org.ofdrw.sign.ExtendSignatureContainer;
import org.ofdrw.sign.ProtectFileFilter;
import org.ofdrw.sign.SignIDProvider;
import org.ofdrw.sign.SignMode;
import org.ofdrw.sign.SignatureException;
import org.ofdrw.sign.SignatureTerminateException;
import org.ofdrw.sign.StandFormatAtomicSignID;
import org.ofdrw.sign.ToDigestFileInfo;
import org.ofdrw.sign.stamppos.StampAppearance;

public class OFDSigner
implements Closeable {
    public static final DateTimeFormatter DF = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private OFDDir ofdDir;
    private OFDReader reader;
    private SignIDProvider MaxSignID;
    private SignMode signMode;
    private Parameters parameters;
    private ST_Loc signaturesLoc;
    private List<StampAppearance> apList;
    private ProtectFileFilter protectFileFilter;
    private ExtendSignatureContainer signContainer;
    private Path out;
    private OutputStream outStream;
    private boolean hasSign;
    private String relativeID = null;

    public static Provider OFDRW_Provider() {
        return new Provider().setProviderName("ofdrw-sign").setCompany("ofdrw").setVersion("1.17.9");
    }

    private OFDSigner() {
    }

    public OFDSigner(OFDReader reader, OutputStream outStream, SignIDProvider idProvider) throws SignatureTerminateException {
        if (reader == null) {
            throw new IllegalArgumentException("OFD\u89e3\u6790\u5668\uff08reader\uff09\u4e3a\u7a7a");
        }
        if (outStream == null) {
            throw new IllegalArgumentException("\u7535\u5b50\u7b7e\u540d\u540e\u6587\u4ef6\u8f93\u51fa\u6d41\uff08outStream\uff09\u4e3a\u7a7a");
        }
        if (idProvider == null) {
            throw new IllegalArgumentException("\u7b7e\u540d\u6587\u4ef6ID\u63d0\u4f9b\u5668\uff08idProvider\uff09\u4e3a\u7a7a");
        }
        this.outStream = outStream;
        this.setProperty(reader, idProvider);
    }

    public OFDSigner(OFDReader reader, Path out, SignIDProvider idProvider) throws SignatureTerminateException {
        if (reader == null) {
            throw new IllegalArgumentException("OFD\u89e3\u6790\u5668\uff08reader\uff09\u4e3a\u7a7a");
        }
        if (out == null) {
            throw new IllegalArgumentException("\u7535\u5b50\u7b7e\u540d\u540e\u6587\u4ef6\u4fdd\u5b58\u4f4d\u7f6e\uff08out\uff09\u4e3a\u7a7a");
        }
        if (idProvider == null) {
            throw new IllegalArgumentException("\u7b7e\u540d\u6587\u4ef6ID\u63d0\u4f9b\u5668\uff08idProvider\uff09\u4e3a\u7a7a");
        }
        this.out = out;
        this.setProperty(reader, idProvider);
    }

    private void setProperty(OFDReader reader, SignIDProvider idProvider) throws SignatureTerminateException {
        this.reader = reader;
        this.ofdDir = reader.getOFDDir();
        this.hasSign = false;
        this.MaxSignID = idProvider;
        this.apList = new LinkedList<StampAppearance>();
        this.signMode = SignMode.WholeProtected;
        this.signaturesLoc = null;
        this.preChecker();
    }

    public OFDSigner(OFDReader reader, Path out) throws SignatureTerminateException {
        this(reader, out, (SignIDProvider)new StandFormatAtomicSignID());
    }

    public SignMode getSignMode() {
        return this.signMode;
    }

    public OFDSigner setSignMode(SignMode signMode) {
        if (signMode == null) {
            signMode = SignMode.WholeProtected;
        }
        this.signMode = signMode;
        return this;
    }

    public OFDSigner setSignContainer(ExtendSignatureContainer signContainer) {
        if (signContainer == null) {
            throw new IllegalArgumentException("\u7b7e\u540d\u5b9e\u73b0\u5bb9\u5668\uff08signContainer\uff09\u4e3a\u7a7a");
        }
        this.signContainer = signContainer;
        return this;
    }

    public OFDSigner addApPos(StampAppearance sa) {
        if (sa == null) {
            return this;
        }
        this.apList.add(sa);
        return this;
    }

    private void preChecker() throws SignatureTerminateException {
        ResourceLocator rl = this.reader.getResourceLocator();
        try {
            rl.save();
            rl.cd("/");
            this.signaturesLoc = this.reader.getDefaultDocSignaturesPath();
            if (this.signaturesLoc == null || !rl.exist(this.signaturesLoc.toString())) {
                return;
            }
            Signatures signatures = (Signatures)rl.get(this.signaturesLoc, Signatures::new);
            String maxSignId = signatures.getMaxSignId();
            this.MaxSignID.setCurrentMaxSignId(maxSignId);
            String parent = this.signaturesLoc.parent();
            rl.cd(parent);
            List signatureList = signatures.getSignatures();
            for (Signature sig : signatureList) {
                ST_Loc baseLoc = sig.getBaseLoc();
                org.ofdrw.core.signatures.sig.Signature sigObj = (org.ofdrw.core.signatures.sig.Signature)rl.get(baseLoc, org.ofdrw.core.signatures.sig.Signature::new);
                References refList = sigObj.getSignedInfo().getReferences();
                if (!refList.hasFile(this.signaturesLoc.getLoc())) continue;
                throw new SignatureTerminateException("\u7b7e\u540d\u5217\u8868\u6587\u4ef6\uff08Signatures.xml\uff09\u5df2\u7ecf\u88ab\u4fdd\u62a4\uff0c\u6587\u6863\u4e0d\u5141\u8bb8\u7ee7\u7eed\u8ffd\u52a0\u7b7e\u540d");
            }
        }
        catch (FileNotFoundException | DocumentException e) {
            throw new BadOFDException("\u9519\u8befOFD\u7ed3\u6784\u548c\u6587\u4ef6\u683c\u5f0f", e);
        }
        finally {
            rl.restore();
        }
    }

    private List<ToDigestFileInfo> toBeDigestFileList() throws IOException {
        final LinkedList<ToDigestFileInfo> res = new LinkedList<ToDigestFileInfo>();
        Path containerPath = this.ofdDir.getContainerPath();
        final String sysRoot = FilenameUtils.separatorsToUnix((String)containerPath.toAbsolutePath().toString());
        Files.walkFileTree(containerPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                String abxFilePath = FilenameUtils.separatorsToUnix((String)file.toAbsolutePath().toString());
                abxFilePath = abxFilePath.replace(sysRoot, "");
                ToDigestFileInfo fileInfo = new ToDigestFileInfo(abxFilePath, file);
                try {
                    if (OFDSigner.this.protectFileFilter != null && !OFDSigner.this.protectFileFilter.filter(fileInfo.getAbsPath())) {
                        return FileVisitResult.CONTINUE;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (OFDSigner.this.signMode == SignMode.ContinueSign && abxFilePath.equals(OFDSigner.this.signaturesLoc.getLoc())) {
                    return FileVisitResult.CONTINUE;
                }
                res.add(fileInfo);
                return FileVisitResult.CONTINUE;
            }
        });
        return res;
    }

    public Signatures exeSign() throws IOException, GeneralSecurityException {
        byte[] signedValue;
        if (this.signContainer == null) {
            throw new IllegalArgumentException("\u7b7e\u540d\u5b9e\u73b0\u5bb9\u5668\uff08signContainer\uff09\u4e3a\u7a7a\uff0c\u8bf7\u63d0\u4f9b\u7b7e\u540d\u5b9e\u73b0\u5bb9\u5668");
        }
        this.hasSign = true;
        SignsDir signsDir = this.ofdDir.obtainDocDefault().obtainSigns();
        SignDir signDir = signsDir.newSignDir();
        Signatures signListObj = this.reader.getDefaultSignatures();
        if (this.signaturesLoc == null || signListObj == null) {
            signListObj = new Signatures();
            signsDir.setSignatures(signListObj);
            this.signaturesLoc = signsDir.getAbsLoc().cat("Signatures.xml");
            try {
                this.ofdDir.getOfd().getDocBody().setSignatures(this.signaturesLoc);
                this.ofdDir.flushFileByName("OFD.xml");
            }
            catch (DocumentException e) {
                throw new BadOFDException("OFD.xml \u6587\u4ef6\u89e3\u6790\u5931\u8d25");
            }
        }
        ST_Loc signatureLoc = signDir.getAbsLoc().cat("Signature.xml");
        Signature signatureRecord = new Signature().setID(this.MaxSignID.incrementAndGet()).setType(this.signContainer.getSignType()).setBaseLoc(signatureLoc);
        if (this.relativeID != null && this.relativeID.trim().length() > 0) {
            signatureRecord.setRelative(this.relativeID);
        }
        signListObj.addSignature(signatureRecord);
        Path signatureFilePath = this.buildSignature(signsDir, signDir, signListObj);
        String propertyInfo = signDir.getAbsLoc().cat("Signature.xml").toString();
        try (InputStream inData = Files.newInputStream(signatureFilePath, new OpenOption[0]);){
            signedValue = this.signContainer.sign(inData, propertyInfo);
        }
        Path signedValuePath = Paths.get(signDir.getSysAbsPath(), "SignedValue.dat");
        Files.write(signedValuePath, signedValue, new OpenOption[0]);
        return signListObj;
    }

    private Path buildSignature(SignsDir signsDir, SignDir signDir, Signatures signListObj) throws IOException, SignatureException {
        Object sealBin;
        SignedInfo signedInfo = new SignedInfo().setProvider(OFDSigner.OFDRW_Provider()).setSignatureMethod(this.signContainer.getSignAlgOID()).setParameters(this.parameters).setSignatureDateTime(DF.format(LocalDateTime.now()));
        ST_Loc signDirAbsLoc = signDir.getAbsLoc();
        if (this.signContainer.getSignType() == SigType.Seal && (sealBin = this.signContainer.getSeal()) != null && ((byte[])sealBin).length != 0) {
            Path sealPath = Paths.get(signDir.getSysAbsPath(), "Seal.esl");
            Files.write(sealPath, (byte[])sealBin, new OpenOption[0]);
            Seal seal = new Seal().setBaseLoc(signDirAbsLoc.cat("Seal.esl"));
            signedInfo.setSeal(seal);
        }
        if (!this.apList.isEmpty()) {
            sealBin = this.apList.iterator();
            while (sealBin.hasNext()) {
                StampAppearance sa = (StampAppearance)sealBin.next();
                sa.getAppearance(this.reader, this.MaxSignID).forEach(arg_0 -> ((SignedInfo)signedInfo).addStampAnnot(arg_0));
            }
        }
        signListObj.setMaxSignId(this.MaxSignID.get());
        signsDir.flushFileByName("Signatures.xml");
        MessageDigest md = this.signContainer.getDigestFnc();
        References references = new References().setCheckMethod(md.getAlgorithm());
        List<ToDigestFileInfo> toDigestFileInfos = this.toBeDigestFileList();
        for (ToDigestFileInfo fileInfo : toDigestFileInfos) {
            byte[] digest = this.calculateFileDigest(md, fileInfo.getSysPath());
            md.reset();
            Reference ref = new Reference().setFileRef(fileInfo.getAbsPath()).setCheckValue(digest);
            references.addReference(ref);
        }
        signedInfo.setReferences(references);
        org.ofdrw.core.signatures.sig.Signature signature = new org.ofdrw.core.signatures.sig.Signature().setSignedValue(signDirAbsLoc.cat("SignedValue.dat")).setSignedInfo(signedInfo);
        signDir.setSignature(signature);
        signDir.flushFileByName("Signature.xml");
        return Paths.get(signDir.getSysAbsPath(), "Signature.xml");
    }

    /*
     * Exception decompiling
     */
    private byte[] calculateFileDigest(MessageDigest md, Path path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void close() throws IOException {
        if (!this.hasSign) {
            throw new IllegalStateException("\u8bf7\u5148\u6267\u884c exeSign\u5728\u5173\u95ed\u5f15\u64ce\u5b8c\u6210\u6570\u5b57\u7b7e\u540d\u3002");
        }
        if (this.out != null) {
            this.ofdDir.jar(this.out);
        } else if (this.outStream != null) {
            this.ofdDir.jar(this.outStream);
        } else {
            throw new IllegalArgumentException("OFD\u6587\u6863\u8f93\u51fa\u76ee\u5f55\u9519\u8bef\u6216\u6ca1\u6709\u8bbe\u7f6e\u8f93\u51fa\u6d41");
        }
        this.reader.close();
    }

    public OFDSigner setProtectFileFilter(ProtectFileFilter filter) {
        this.protectFileFilter = filter;
        return this;
    }

    public OFDSigner setRelative(String id) {
        this.relativeID = id;
        return this;
    }

    public OFDSigner setParameters(Parameters parameters) {
        this.parameters = parameters;
        return this;
    }
}

