/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.sign;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.dom4j.DocumentException;
import org.ofdrw.core.basicStructure.ofd.DocBody;
import org.ofdrw.core.basicStructure.ofd.OFD;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.pkg.container.OFDDir;
import org.ofdrw.pkg.container.VirtualContainer;
import org.ofdrw.reader.OFDReader;
import org.ofdrw.reader.ResourceLocator;

public class SignCleaner {
    private OFDReader reader;
    private Path out;

    private SignCleaner() {
    }

    public SignCleaner(OFDReader reader, Path out) {
        if (reader == null) {
            throw new IllegalArgumentException("OFD\u89e3\u6790\u5668(reader)\u4e3a\u7a7a");
        }
        if (out == null) {
            throw new IllegalArgumentException("\u8f93\u51fa\u4f4d\u7f6e(out)\u4e3a\u7a7a");
        }
        this.reader = reader;
        this.out = out;
    }

    public void clean() throws IOException, DocumentException {
        OFDDir ofdDir = this.reader.getOFDDir();
        OFD ofd = ofdDir.getOfd();
        ResourceLocator rl = this.reader.getResourceLocator();
        for (DocBody docBody : ofd.getDocBodies()) {
            ST_Loc signListFileLoc = docBody.getSignatures();
            docBody.removeOFDElemByNames(new String[]{"Signatures"});
            if (signListFileLoc == null) continue;
            Path signaturesXMLFile = rl.getFile(signListFileLoc);
            String parent = signListFileLoc.parent();
            VirtualContainer container = rl.getContainer(parent);
            if ("Signs".equalsIgnoreCase(container.getContainerName())) {
                container.clean();
            }
            if (Files.exists(signaturesXMLFile, new LinkOption[0])) {
                Files.delete(signaturesXMLFile);
            }
            ofdDir.jar(this.out.toAbsolutePath());
        }
    }
}

