/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.sign.verify;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.dom4j.DocumentException;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.core.signatures.SigType;
import org.ofdrw.core.signatures.Signature;
import org.ofdrw.core.signatures.Signatures;
import org.ofdrw.core.signatures.appearance.Seal;
import org.ofdrw.core.signatures.range.Reference;
import org.ofdrw.core.signatures.range.References;
import org.ofdrw.core.signatures.sig.SignedInfo;
import org.ofdrw.gm.ses.parse.SESVersion;
import org.ofdrw.gm.ses.parse.SESVersionHolder;
import org.ofdrw.gm.ses.parse.VersionParser;
import org.ofdrw.gm.ses.v1.SES_Signature;
import org.ofdrw.gm.ses.v1.SESeal;
import org.ofdrw.pkg.container.OFDDir;
import org.ofdrw.reader.BadOFDException;
import org.ofdrw.reader.OFDReader;
import org.ofdrw.reader.ResourceLocator;
import org.ofdrw.sign.verify.SignedDataValidateContainer;
import org.ofdrw.sign.verify.exceptions.DocNotSignException;
import org.ofdrw.sign.verify.exceptions.FileIntegrityException;
import org.ofdrw.sign.verify.exceptions.OFDVerifyException;

public class OFDValidator
implements Closeable {
    private Provider provider;
    private OFDDir ofdDir;
    private final OFDReader reader;
    private final ResourceLocator rl;
    private SignedDataValidateContainer validator;

    public OFDValidator(OFDReader reader) {
        this.reader = reader;
        this.ofdDir = reader.getOFDDir();
        this.rl = reader.getResourceLocator();
        this.provider = new BouncyCastleProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exeValidate() throws OFDVerifyException, IOException, GeneralSecurityException {
        this.rl.save();
        try {
            this.rl.cd("/");
            ST_Loc signsListLoc = this.reader.getDefaultDocSignaturesPath();
            if (signsListLoc == null) {
                throw new DocNotSignException("\u6587\u4ef6\u672a\u8fdb\u884c\u7535\u5b50\u7b7e\u540d");
            }
            Signatures sigList = (Signatures)this.rl.get(signsListLoc, Signatures::new);
            this.rl.cd(signsListLoc.parent());
            List signatures = sigList.getSignatures();
            if (signatures == null || signatures.size() == 0) {
                throw new DocNotSignException("\u6587\u4ef6\u672a\u8fdb\u884c\u7535\u5b50\u7b7e\u540d");
            }
            for (Signature sigRecord : signatures) {
                SigType type = sigRecord.getType();
                ST_Loc signFileLoc = sigRecord.getBaseLoc();
                Path signatureFilePath = this.rl.getFile(signFileLoc);
                org.ofdrw.core.signatures.sig.Signature sig = (org.ofdrw.core.signatures.sig.Signature)this.rl.get(signFileLoc, org.ofdrw.core.signatures.sig.Signature::new);
                this.rl.save();
                try {
                    Path sealFilePath;
                    boolean sealMatch;
                    Seal seal;
                    this.rl.cd(signFileLoc.parent());
                    this.checkFileIntegrity(sig);
                    Path signedValueFilePath = this.rl.getFile(sig.getSignedValue());
                    if (!(type != null && type != SigType.Seal || (seal = sig.getSignedInfo().getSeal()) == null || (sealMatch = this.checkSealMatch(sealFilePath = this.rl.getFile(seal.getBaseLoc()), signedValueFilePath)))) {
                        throw new GeneralSecurityException("\u5370\u7ae0(Seal.esl)\u4e0e\u7535\u5b50\u7b7e\u7ae0\u6570\u636e(SignedValue.dat)\u4e2d\u7684\u5370\u7ae0\u4e0d\u5339\u914d");
                    }
                    String alg = sig.getSignedInfo().getSignatureMethod();
                    this.checkSignedValue(type, alg, signatureFilePath, signedValueFilePath);
                }
                finally {
                    this.rl.restore();
                }
            }
        }
        catch (FileNotFoundException | DocumentException e) {
            throw new BadOFDException("OFD\u6587\u4ef6\u5185\u90e8\u7ed3\u6784\u9519\u8bef\uff0c\u65e0\u6cd5\u89e3\u6790\u3002", e);
        }
        finally {
            this.rl.restore();
        }
    }

    public OFDValidator setValidator(SignedDataValidateContainer validator) {
        if (validator == null) {
            throw new IllegalArgumentException("\u7535\u5b50\u7b7e\u7ae0\u6570\u636e\u9a8c\u8bc1\u5bb9\u5668\uff08validator\uff09\u4e3a\u7a7a");
        }
        this.validator = validator;
        return this;
    }

    public void checkSignedValue(SigType type, String alg, Path signatureFilePath, Path signedValuePath) throws IOException, GeneralSecurityException {
        if (this.validator == null) {
            throw new IllegalArgumentException("\u7535\u5b50\u7b7e\u7ae0\u6570\u636e\u9a8c\u8bc1\u5bb9\u5668\uff08validator\uff09\u4e3a\u7a7a,Call #setValidator");
        }
        if (type == null) {
            type = SigType.Seal;
        }
        this.validator.validate(type, alg, Files.readAllBytes(signatureFilePath), Files.readAllBytes(signedValuePath));
    }

    private void checkFileIntegrity(org.ofdrw.core.signatures.sig.Signature sig) throws FileIntegrityException, NoSuchAlgorithmException, IOException {
        SignedInfo signedInfo = sig.getSignedInfo();
        References references = signedInfo.getReferences();
        String checkMethod = references.getCheckMethod();
        MessageDigest md = MessageDigest.getInstance(checkMethod, this.provider);
        for (Reference ref : references.getReferences()) {
            ST_Loc fileRef = ref.getFileRef();
            Path file = this.rl.getFile(fileRef);
            byte[] expectDataHash = ref.getCheckValue();
            try (InputStream in = Files.newInputStream(file, new OpenOption[0]);
                 DigestInputStream dis = new DigestInputStream(in, md);){
                byte[] buffer = new byte[4096];
                while (dis.read(buffer) > -1) {
                }
                byte[] actualDataHash = md.digest();
                if (!Arrays.equals(expectDataHash, actualDataHash)) {
                    throw new FileIntegrityException(fileRef, expectDataHash, actualDataHash);
                }
            }
            md.reset();
        }
    }

    private boolean checkSealMatch(Path sealPath, Path signedValuePath) throws IOException, OFDVerifyException {
        org.ofdrw.gm.ses.v4.SES_Signature sesSignature;
        byte[] sesSignatureBin = Files.readAllBytes(signedValuePath);
        byte[] expect = null;
        SESVersionHolder v = VersionParser.parseSES_SignatureVersion((Object)sesSignatureBin);
        if (v.getVersion() == SESVersion.v4) {
            sesSignature = org.ofdrw.gm.ses.v4.SES_Signature.getInstance((Object)v.getObjSeq());
            org.ofdrw.gm.ses.v4.SESeal eseal = sesSignature.getToSign().getEseal();
            expect = eseal.getEncoded("DER");
        } else if (v.getVersion() == SESVersion.v1) {
            sesSignature = SES_Signature.getInstance((Object)v.getObjSeq());
            SESeal eseal = sesSignature.getToSign().getEseal();
            expect = eseal.getEncoded("DER");
        } else {
            throw new OFDVerifyException("\u672a\u77e5\u7684\u7535\u5b50\u7b7e\u7ae0\u6570\u636e\u7248\u672c\uff0c\u65e0\u6cd5\u89e3\u6790");
        }
        byte[] sealBin = Files.readAllBytes(sealPath);
        return Arrays.equals(expect, sealBin);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

