/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.tool.merge;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.ofdrw.core.basicStructure.doc.CT_CommonData;
import org.ofdrw.core.basicStructure.doc.Document;
import org.ofdrw.core.basicStructure.ofd.DocBody;
import org.ofdrw.core.basicStructure.ofd.OFD;
import org.ofdrw.core.basicStructure.ofd.docInfo.CT_DocInfo;
import org.ofdrw.core.basicStructure.pageTree.Pages;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.layout.PageLayout;
import org.ofdrw.layout.engine.ResManager;
import org.ofdrw.pkg.container.DocDir;
import org.ofdrw.pkg.container.OFDDir;

public class BareOFDDoc
implements Closeable {
    private Path outPath;
    private boolean closed = false;
    public final OFDDir ofdDir;
    public final AtomicInteger MaxUnitID = new AtomicInteger(0);
    public final ResManager prm;
    public CT_CommonData cdata;
    public final Document document;
    public final DocDir docDir;

    public BareOFDDoc(Path outPath) {
        this();
        if (outPath == null) {
            throw new IllegalArgumentException("OFD\u6587\u4ef6\u5b58\u50a8\u8def\u5f84(outPath)\u4e3a\u7a7a");
        }
        if (Files.isDirectory(outPath, new LinkOption[0])) {
            throw new IllegalArgumentException("OFD\u6587\u4ef6\u5b58\u50a8\u8def\u5f84(outPath)\u4e0d\u80fd\u662f\u76ee\u5f55");
        }
        if (!Files.exists(outPath.toAbsolutePath().getParent(), new LinkOption[0])) {
            throw new IllegalArgumentException("OFD\u6587\u4ef6\u5b58\u50a8\u8def\u5f84(outPath)\u4e0a\u7ea7\u76ee\u5f55 [" + outPath.getParent().toAbsolutePath() + "] \u4e0d\u5b58\u5728");
        }
        this.outPath = outPath;
    }

    private BareOFDDoc() {
        DocDir docDir;
        CT_DocInfo docInfo = new CT_DocInfo().setDocID(UUID.randomUUID()).setCreationDate(LocalDate.now()).setCreator("OFD R&W").setCreatorVersion("2.2.6");
        DocBody docBody = new DocBody().setDocInfo(docInfo).setDocRoot(new ST_Loc("Doc_0/Document.xml"));
        OFD ofd = new OFD().addDocBody(docBody);
        this.document = new Document();
        this.cdata = new CT_CommonData();
        this.cdata.setPageArea(PageLayout.A4().getPageArea());
        this.document.setCommonData(this.cdata).setPages(new Pages());
        this.ofdDir = OFDDir.newOFD().setOfd(ofd);
        this.docDir = docDir = this.ofdDir.newDoc();
        docDir.setDocument(this.document);
        this.prm = new ResManager(docDir, this.MaxUnitID);
        this.prm.setRoot(this.ofdDir);
    }

    @Override
    public void close() throws IOException {
        block6: {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                this.cdata.setMaxUnitID((long)this.MaxUnitID.get());
                if (this.outPath != null) {
                    this.ofdDir.jar(this.outPath.toAbsolutePath());
                    break block6;
                }
                throw new IllegalArgumentException("OFD\u6587\u6863\u8f93\u51fa\u5730\u5740\u9519\u8bef\u6216\u6ca1\u6709\u8bbe\u7f6e\u8f93\u51fa\u6d41");
            }
            finally {
                if (this.ofdDir != null) {
                    this.ofdDir.clean();
                }
            }
        }
    }
}

