/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1Boolean;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1EncodableVector;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Enumerated;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Exception;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1GeneralizedTime;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Integer;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1ObjectIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1StreamParser;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1UTCTime;
import edu.illinois.ncsa.bouncycastle.asn1.BERApplicationSpecificParser;
import edu.illinois.ncsa.bouncycastle.asn1.BERConstructedOctetString;
import edu.illinois.ncsa.bouncycastle.asn1.BEROctetStringParser;
import edu.illinois.ncsa.bouncycastle.asn1.BERSequenceParser;
import edu.illinois.ncsa.bouncycastle.asn1.BERSetParser;
import edu.illinois.ncsa.bouncycastle.asn1.BERTaggedObjectParser;
import edu.illinois.ncsa.bouncycastle.asn1.DERApplicationSpecific;
import edu.illinois.ncsa.bouncycastle.asn1.DERBMPString;
import edu.illinois.ncsa.bouncycastle.asn1.DERBitString;
import edu.illinois.ncsa.bouncycastle.asn1.DERExternal;
import edu.illinois.ncsa.bouncycastle.asn1.DERExternalParser;
import edu.illinois.ncsa.bouncycastle.asn1.DERFactory;
import edu.illinois.ncsa.bouncycastle.asn1.DERGeneralString;
import edu.illinois.ncsa.bouncycastle.asn1.DERIA5String;
import edu.illinois.ncsa.bouncycastle.asn1.DERNull;
import edu.illinois.ncsa.bouncycastle.asn1.DERNumericString;
import edu.illinois.ncsa.bouncycastle.asn1.DERObject;
import edu.illinois.ncsa.bouncycastle.asn1.DEROctetString;
import edu.illinois.ncsa.bouncycastle.asn1.DERPrintableString;
import edu.illinois.ncsa.bouncycastle.asn1.DERT61String;
import edu.illinois.ncsa.bouncycastle.asn1.DERTags;
import edu.illinois.ncsa.bouncycastle.asn1.DERUTF8String;
import edu.illinois.ncsa.bouncycastle.asn1.DERUniversalString;
import edu.illinois.ncsa.bouncycastle.asn1.DERUnknownTag;
import edu.illinois.ncsa.bouncycastle.asn1.DERVisibleString;
import edu.illinois.ncsa.bouncycastle.asn1.DefiniteLengthInputStream;
import edu.illinois.ncsa.bouncycastle.asn1.IndefiniteLengthInputStream;
import edu.illinois.ncsa.bouncycastle.asn1.LazyDERSequence;
import edu.illinois.ncsa.bouncycastle.asn1.LimitedInputStream;
import edu.illinois.ncsa.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ASN1InputStream
extends FilterInputStream
implements DERTags {
    private final int limit;
    private final boolean lazyEvaluate;

    static int findLimit(InputStream inputStream) {
        if (inputStream instanceof LimitedInputStream) {
            return ((LimitedInputStream)inputStream).getRemaining();
        }
        if (inputStream instanceof ByteArrayInputStream) {
            return ((ByteArrayInputStream)inputStream).available();
        }
        return Integer.MAX_VALUE;
    }

    public ASN1InputStream(InputStream inputStream) {
        this(inputStream, ASN1InputStream.findLimit(inputStream));
    }

    public ASN1InputStream(byte[] byArray) {
        this(new ByteArrayInputStream(byArray), byArray.length);
    }

    public ASN1InputStream(byte[] byArray, boolean bl) {
        this(new ByteArrayInputStream(byArray), byArray.length, bl);
    }

    public ASN1InputStream(InputStream inputStream, int n) {
        this(inputStream, n, false);
    }

    public ASN1InputStream(InputStream inputStream, int n, boolean bl) {
        super(inputStream);
        this.limit = n;
        this.lazyEvaluate = bl;
    }

    protected int readLength() throws IOException {
        return ASN1InputStream.readLength(this, this.limit);
    }

    protected void readFully(byte[] byArray) throws IOException {
        if (Streams.readFully(this, byArray) != byArray.length) {
            throw new EOFException("EOF encountered in middle of object");
        }
    }

    protected DERObject buildObject(int n, int n2, int n3) throws IOException {
        boolean bl = (n & 0x20) != 0;
        DefiniteLengthInputStream definiteLengthInputStream = new DefiniteLengthInputStream(this, n3);
        if ((n & 0x40) != 0) {
            return new DERApplicationSpecific(bl, n2, definiteLengthInputStream.toByteArray());
        }
        if ((n & 0x80) != 0) {
            return new ASN1StreamParser(definiteLengthInputStream).readTaggedObject(bl, n2);
        }
        if (bl) {
            switch (n2) {
                case 4: {
                    return new BERConstructedOctetString(this.buildDEREncodableVector((DefiniteLengthInputStream)definiteLengthInputStream).v);
                }
                case 16: {
                    if (this.lazyEvaluate) {
                        return new LazyDERSequence(definiteLengthInputStream.toByteArray());
                    }
                    return DERFactory.createSequence(this.buildDEREncodableVector(definiteLengthInputStream));
                }
                case 17: {
                    return DERFactory.createSet(this.buildDEREncodableVector(definiteLengthInputStream), false);
                }
                case 8: {
                    return new DERExternal(this.buildDEREncodableVector(definiteLengthInputStream));
                }
            }
            return new DERUnknownTag(true, n2, definiteLengthInputStream.toByteArray());
        }
        return ASN1InputStream.createPrimitiveDERObject(n2, definiteLengthInputStream.toByteArray());
    }

    ASN1EncodableVector buildEncodableVector() throws IOException {
        DERObject dERObject;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        while ((dERObject = this.readObject()) != null) {
            aSN1EncodableVector.add(dERObject);
        }
        return aSN1EncodableVector;
    }

    ASN1EncodableVector buildDEREncodableVector(DefiniteLengthInputStream definiteLengthInputStream) throws IOException {
        return new ASN1InputStream(definiteLengthInputStream).buildEncodableVector();
    }

    public DERObject readObject() throws IOException {
        int n = this.read();
        if (n <= 0) {
            if (n == 0) {
                throw new IOException("unexpected end-of-contents marker");
            }
            return null;
        }
        int n2 = ASN1InputStream.readTagNumber(this, n);
        boolean bl = (n & 0x20) != 0;
        int n3 = this.readLength();
        if (n3 < 0) {
            if (!bl) {
                throw new IOException("indefinite length primitive encoding encountered");
            }
            IndefiniteLengthInputStream indefiniteLengthInputStream = new IndefiniteLengthInputStream(this, this.limit);
            ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(indefiniteLengthInputStream, this.limit);
            if ((n & 0x40) != 0) {
                return new BERApplicationSpecificParser(n2, aSN1StreamParser).getLoadedObject();
            }
            if ((n & 0x80) != 0) {
                return new BERTaggedObjectParser(true, n2, aSN1StreamParser).getLoadedObject();
            }
            switch (n2) {
                case 4: {
                    return new BEROctetStringParser(aSN1StreamParser).getLoadedObject();
                }
                case 16: {
                    return new BERSequenceParser(aSN1StreamParser).getLoadedObject();
                }
                case 17: {
                    return new BERSetParser(aSN1StreamParser).getLoadedObject();
                }
                case 8: {
                    return new DERExternalParser(aSN1StreamParser).getLoadedObject();
                }
            }
            throw new IOException("unknown BER object encountered");
        }
        try {
            return this.buildObject(n, n2, n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ASN1Exception("corrupted stream detected", illegalArgumentException);
        }
    }

    static int readTagNumber(InputStream inputStream, int n) throws IOException {
        int n2 = n & 0x1F;
        if (n2 == 31) {
            n2 = 0;
            int n3 = inputStream.read();
            if ((n3 & 0x7F) == 0) {
                throw new IOException("corrupted stream - invalid high tag number found");
            }
            while (n3 >= 0 && (n3 & 0x80) != 0) {
                n2 |= n3 & 0x7F;
                n2 <<= 7;
                n3 = inputStream.read();
            }
            if (n3 < 0) {
                throw new EOFException("EOF found inside tag value.");
            }
            n2 |= n3 & 0x7F;
        }
        return n2;
    }

    static int readLength(InputStream inputStream, int n) throws IOException {
        int n2 = inputStream.read();
        if (n2 < 0) {
            throw new EOFException("EOF found when length expected");
        }
        if (n2 == 128) {
            return -1;
        }
        if (n2 > 127) {
            int n3 = n2 & 0x7F;
            if (n3 > 4) {
                throw new IOException("DER length more than 4 bytes: " + n3);
            }
            n2 = 0;
            for (int i = 0; i < n3; ++i) {
                int n4 = inputStream.read();
                if (n4 < 0) {
                    throw new EOFException("EOF found reading length");
                }
                n2 = (n2 << 8) + n4;
            }
            if (n2 < 0) {
                throw new IOException("corrupted stream - negative length found");
            }
            if (n2 >= n) {
                throw new IOException("corrupted stream - out of bounds length found");
            }
        }
        return n2;
    }

    static DERObject createPrimitiveDERObject(int n, byte[] byArray) {
        switch (n) {
            case 3: {
                return DERBitString.fromOctetString(byArray);
            }
            case 30: {
                return new DERBMPString(byArray);
            }
            case 1: {
                return new ASN1Boolean(byArray);
            }
            case 10: {
                return new ASN1Enumerated(byArray);
            }
            case 24: {
                return new ASN1GeneralizedTime(byArray);
            }
            case 27: {
                return new DERGeneralString(byArray);
            }
            case 22: {
                return new DERIA5String(byArray);
            }
            case 2: {
                return new ASN1Integer(byArray);
            }
            case 5: {
                return DERNull.INSTANCE;
            }
            case 18: {
                return new DERNumericString(byArray);
            }
            case 6: {
                return new ASN1ObjectIdentifier(byArray);
            }
            case 4: {
                return new DEROctetString(byArray);
            }
            case 19: {
                return new DERPrintableString(byArray);
            }
            case 20: {
                return new DERT61String(byArray);
            }
            case 28: {
                return new DERUniversalString(byArray);
            }
            case 23: {
                return new ASN1UTCTime(byArray);
            }
            case 12: {
                return new DERUTF8String(byArray);
            }
            case 26: {
                return new DERVisibleString(byArray);
            }
        }
        return new DERUnknownTag(false, n, byArray);
    }
}

