/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.cms;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1OctetString;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1SequenceParser;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1SetParser;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1TaggedObjectParser;
import edu.illinois.ncsa.bouncycastle.asn1.DEREncodable;
import edu.illinois.ncsa.bouncycastle.asn1.DERInteger;
import edu.illinois.ncsa.bouncycastle.asn1.cms.EncryptedContentInfoParser;
import edu.illinois.ncsa.bouncycastle.asn1.cms.OriginatorInfo;
import java.io.IOException;

public class AuthEnvelopedDataParser {
    private ASN1SequenceParser seq;
    private DERInteger version;
    private DEREncodable nextObject;
    private boolean originatorInfoCalled;

    public AuthEnvelopedDataParser(ASN1SequenceParser aSN1SequenceParser) throws IOException {
        this.seq = aSN1SequenceParser;
        this.version = (DERInteger)aSN1SequenceParser.readObject();
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public OriginatorInfo getOriginatorInfo() throws IOException {
        this.originatorInfoCalled = true;
        if (this.nextObject == null) {
            this.nextObject = this.seq.readObject();
        }
        if (this.nextObject instanceof ASN1TaggedObjectParser && ((ASN1TaggedObjectParser)this.nextObject).getTagNo() == 0) {
            ASN1SequenceParser aSN1SequenceParser = (ASN1SequenceParser)((ASN1TaggedObjectParser)this.nextObject).getObjectParser(16, false);
            this.nextObject = null;
            return OriginatorInfo.getInstance(aSN1SequenceParser.getDERObject());
        }
        return null;
    }

    public ASN1SetParser getRecipientInfos() throws IOException {
        if (!this.originatorInfoCalled) {
            this.getOriginatorInfo();
        }
        if (this.nextObject == null) {
            this.nextObject = this.seq.readObject();
        }
        ASN1SetParser aSN1SetParser = (ASN1SetParser)this.nextObject;
        this.nextObject = null;
        return aSN1SetParser;
    }

    public EncryptedContentInfoParser getAuthEncryptedContentInfo() throws IOException {
        if (this.nextObject == null) {
            this.nextObject = this.seq.readObject();
        }
        if (this.nextObject != null) {
            ASN1SequenceParser aSN1SequenceParser = (ASN1SequenceParser)this.nextObject;
            this.nextObject = null;
            return new EncryptedContentInfoParser(aSN1SequenceParser);
        }
        return null;
    }

    public ASN1SetParser getAuthAttrs() throws IOException {
        if (this.nextObject == null) {
            this.nextObject = this.seq.readObject();
        }
        if (this.nextObject instanceof ASN1TaggedObjectParser) {
            DEREncodable dEREncodable = this.nextObject;
            this.nextObject = null;
            return (ASN1SetParser)((ASN1TaggedObjectParser)dEREncodable).getObjectParser(17, false);
        }
        return null;
    }

    public ASN1OctetString getMac() throws IOException {
        if (this.nextObject == null) {
            this.nextObject = this.seq.readObject();
        }
        DEREncodable dEREncodable = this.nextObject;
        this.nextObject = null;
        return ASN1OctetString.getInstance(dEREncodable.getDERObject());
    }

    public ASN1SetParser getUnauthAttrs() throws IOException {
        if (this.nextObject == null) {
            this.nextObject = this.seq.readObject();
        }
        if (this.nextObject != null) {
            DEREncodable dEREncodable = this.nextObject;
            this.nextObject = null;
            return (ASN1SetParser)((ASN1TaggedObjectParser)dEREncodable).getObjectParser(17, false);
        }
        return null;
    }
}

