/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.cms;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1EncodableVector;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1OctetStringParser;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1SequenceParser;
import edu.illinois.ncsa.bouncycastle.asn1.BERSequence;
import edu.illinois.ncsa.bouncycastle.asn1.DEREncodable;
import edu.illinois.ncsa.bouncycastle.asn1.DERIA5String;
import edu.illinois.ncsa.bouncycastle.asn1.DERInteger;
import edu.illinois.ncsa.bouncycastle.asn1.DERObject;
import edu.illinois.ncsa.bouncycastle.asn1.cms.Evidence;
import edu.illinois.ncsa.bouncycastle.asn1.cms.MetaData;
import java.io.IOException;

public class TimeStampedDataParser {
    private DERInteger version;
    private DERIA5String dataUri;
    private MetaData metaData;
    private ASN1OctetStringParser content;
    private Evidence temporalEvidence;
    private ASN1SequenceParser parser;

    private TimeStampedDataParser(ASN1SequenceParser aSN1SequenceParser) throws IOException {
        this.parser = aSN1SequenceParser;
        this.version = DERInteger.getInstance(aSN1SequenceParser.readObject());
        DEREncodable dEREncodable = aSN1SequenceParser.readObject();
        if (dEREncodable instanceof DERIA5String) {
            this.dataUri = DERIA5String.getInstance(dEREncodable);
            dEREncodable = aSN1SequenceParser.readObject();
        }
        if (dEREncodable instanceof MetaData || dEREncodable instanceof ASN1SequenceParser) {
            this.metaData = MetaData.getInstance(dEREncodable.getDERObject());
            dEREncodable = aSN1SequenceParser.readObject();
        }
        if (dEREncodable instanceof ASN1OctetStringParser) {
            this.content = (ASN1OctetStringParser)dEREncodable;
        }
    }

    public static TimeStampedDataParser getInstance(Object object) throws IOException {
        if (object instanceof ASN1Sequence) {
            return new TimeStampedDataParser(((ASN1Sequence)object).parser());
        }
        if (object instanceof ASN1SequenceParser) {
            return new TimeStampedDataParser((ASN1SequenceParser)object);
        }
        return null;
    }

    public DERIA5String getDataUri() {
        return this.dataUri;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public ASN1OctetStringParser getContent() {
        return this.content;
    }

    public Evidence getTemporalEvidence() throws IOException {
        if (this.temporalEvidence == null) {
            this.temporalEvidence = Evidence.getInstance(this.parser.readObject().getDERObject());
        }
        return this.temporalEvidence;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.version);
        if (this.dataUri != null) {
            aSN1EncodableVector.add(this.dataUri);
        }
        if (this.metaData != null) {
            aSN1EncodableVector.add(this.metaData);
        }
        if (this.content != null) {
            aSN1EncodableVector.add(this.content);
        }
        aSN1EncodableVector.add(this.temporalEvidence);
        return new BERSequence(aSN1EncodableVector);
    }
}

