/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.pkcs;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1Encodable;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1EncodableVector;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERBitString;
import edu.illinois.ncsa.bouncycastle.asn1.DERObject;
import edu.illinois.ncsa.bouncycastle.asn1.DERSequence;
import edu.illinois.ncsa.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import edu.illinois.ncsa.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class CertificationRequest
extends ASN1Encodable {
    protected CertificationRequestInfo reqInfo = null;
    protected AlgorithmIdentifier sigAlgId = null;
    protected DERBitString sigBits = null;

    public static CertificationRequest getInstance(Object object) {
        if (object instanceof CertificationRequest) {
            return (CertificationRequest)object;
        }
        if (object != null) {
            return new CertificationRequest(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    protected CertificationRequest() {
    }

    public CertificationRequest(CertificationRequestInfo certificationRequestInfo, AlgorithmIdentifier algorithmIdentifier, DERBitString dERBitString) {
        this.reqInfo = certificationRequestInfo;
        this.sigAlgId = algorithmIdentifier;
        this.sigBits = dERBitString;
    }

    public CertificationRequest(ASN1Sequence aSN1Sequence) {
        this.reqInfo = CertificationRequestInfo.getInstance(aSN1Sequence.getObjectAt(0));
        this.sigAlgId = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
        this.sigBits = (DERBitString)aSN1Sequence.getObjectAt(2);
    }

    public CertificationRequestInfo getCertificationRequestInfo() {
        return this.reqInfo;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.sigAlgId;
    }

    public DERBitString getSignature() {
        return this.sigBits;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.reqInfo);
        aSN1EncodableVector.add(this.sigAlgId);
        aSN1EncodableVector.add(this.sigBits);
        return new DERSequence(aSN1EncodableVector);
    }
}

