/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.pkcs;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1Encodable;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1EncodableVector;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1OctetString;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERInteger;
import edu.illinois.ncsa.bouncycastle.asn1.DERObject;
import edu.illinois.ncsa.bouncycastle.asn1.DEROctetString;
import edu.illinois.ncsa.bouncycastle.asn1.DERSequence;
import java.math.BigInteger;

public class PBEParameter
extends ASN1Encodable {
    DERInteger iterations;
    ASN1OctetString salt;

    public PBEParameter(byte[] byArray, int n) {
        if (byArray.length != 8) {
            throw new IllegalArgumentException("salt length must be 8");
        }
        this.salt = new DEROctetString(byArray);
        this.iterations = new DERInteger(n);
    }

    public PBEParameter(ASN1Sequence aSN1Sequence) {
        this.salt = (ASN1OctetString)aSN1Sequence.getObjectAt(0);
        this.iterations = (DERInteger)aSN1Sequence.getObjectAt(1);
    }

    public static PBEParameter getInstance(Object object) {
        if (object instanceof PBEParameter) {
            return (PBEParameter)object;
        }
        if (object instanceof ASN1Sequence) {
            return new PBEParameter((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory: " + object.getClass().getName());
    }

    public BigInteger getIterationCount() {
        return this.iterations.getValue();
    }

    public byte[] getSalt() {
        return this.salt.getOctets();
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.salt);
        aSN1EncodableVector.add(this.iterations);
        return new DERSequence(aSN1EncodableVector);
    }
}

