/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1Object;
import edu.illinois.ncsa.bouncycastle.asn1.icao.CscaMasterList;
import edu.illinois.ncsa.bouncycastle.util.Arrays;
import edu.illinois.ncsa.bouncycastle.util.io.Streams;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;
import java.io.IOException;

public class CscaMasterListTest
extends SimpleTest {
    public String getName() {
        return "CscaMasterList";
    }

    public void performTest() throws Exception {
        byte[] byArray;
        byte[] byArray2 = this.getInput("masterlist-content.data");
        CscaMasterList cscaMasterList = CscaMasterList.getInstance(ASN1Object.fromByteArray(byArray2));
        if (cscaMasterList.getCertStructs().length != 3) {
            this.fail("Cert structure parsing failed: incorrect length");
        }
        if (!Arrays.areEqual(byArray2, byArray = cscaMasterList.getEncoded())) {
            this.fail("Encoding failed after parse");
        }
    }

    private byte[] getInput(String string) throws IOException {
        return Streams.readAll(this.getClass().getResourceAsStream(string));
    }

    public static void main(String[] stringArray) {
        CscaMasterListTest.runTest(new CscaMasterListTest());
    }
}

