/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.DERGeneralizedTime;
import edu.illinois.ncsa.bouncycastle.asn1.DERTaggedObject;
import edu.illinois.ncsa.bouncycastle.asn1.isismtt.x509.DeclarationOfMajority;
import edu.illinois.ncsa.bouncycastle.asn1.test.ASN1UnitTest;
import java.io.IOException;

public class DeclarationOfMajorityUnitTest
extends ASN1UnitTest {
    public String getName() {
        return "DeclarationOfMajority";
    }

    public void performTest() throws Exception {
        DERGeneralizedTime dERGeneralizedTime = new DERGeneralizedTime("20070315173729Z");
        DeclarationOfMajority declarationOfMajority = new DeclarationOfMajority(dERGeneralizedTime);
        this.checkConstruction(declarationOfMajority, 2, dERGeneralizedTime, -1);
        declarationOfMajority = new DeclarationOfMajority(6);
        this.checkConstruction(declarationOfMajority, 0, null, 6);
        declarationOfMajority = DeclarationOfMajority.getInstance(null);
        if (declarationOfMajority != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            DeclarationOfMajority.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(DeclarationOfMajority declarationOfMajority, int n, DERGeneralizedTime dERGeneralizedTime, int n2) throws IOException {
        this.checkValues(declarationOfMajority, n, dERGeneralizedTime, n2);
        declarationOfMajority = DeclarationOfMajority.getInstance(declarationOfMajority);
        this.checkValues(declarationOfMajority, n, dERGeneralizedTime, n2);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(declarationOfMajority.toASN1Object().getEncoded());
        DERTaggedObject dERTaggedObject = (DERTaggedObject)aSN1InputStream.readObject();
        declarationOfMajority = DeclarationOfMajority.getInstance(dERTaggedObject);
        this.checkValues(declarationOfMajority, n, dERGeneralizedTime, n2);
    }

    private void checkValues(DeclarationOfMajority declarationOfMajority, int n, DERGeneralizedTime dERGeneralizedTime, int n2) {
        this.checkMandatoryField("type", n, declarationOfMajority.getType());
        this.checkOptionalField("dateOfBirth", dERGeneralizedTime, declarationOfMajority.getDateOfBirth());
        if (n2 != -1 && n2 != declarationOfMajority.notYoungerThan()) {
            this.fail("notYoungerThan mismatch");
        }
    }

    public static void main(String[] stringArray) {
        DeclarationOfMajorityUnitTest.runTest(new DeclarationOfMajorityUnitTest());
    }
}

