/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1OutputStream;
import edu.illinois.ncsa.bouncycastle.asn1.BERConstructedOctetString;
import edu.illinois.ncsa.bouncycastle.asn1.BERSequence;
import edu.illinois.ncsa.bouncycastle.asn1.BERSet;
import edu.illinois.ncsa.bouncycastle.asn1.BERTaggedObject;
import edu.illinois.ncsa.bouncycastle.asn1.DERApplicationSpecific;
import edu.illinois.ncsa.bouncycastle.asn1.DERBMPString;
import edu.illinois.ncsa.bouncycastle.asn1.DERBitString;
import edu.illinois.ncsa.bouncycastle.asn1.DERBoolean;
import edu.illinois.ncsa.bouncycastle.asn1.DEREnumerated;
import edu.illinois.ncsa.bouncycastle.asn1.DERGeneralString;
import edu.illinois.ncsa.bouncycastle.asn1.DERGeneralizedTime;
import edu.illinois.ncsa.bouncycastle.asn1.DERIA5String;
import edu.illinois.ncsa.bouncycastle.asn1.DERInteger;
import edu.illinois.ncsa.bouncycastle.asn1.DERNull;
import edu.illinois.ncsa.bouncycastle.asn1.DERNumericString;
import edu.illinois.ncsa.bouncycastle.asn1.DERObject;
import edu.illinois.ncsa.bouncycastle.asn1.DERObjectIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.DEROctetString;
import edu.illinois.ncsa.bouncycastle.asn1.DERPrintableString;
import edu.illinois.ncsa.bouncycastle.asn1.DERSequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERSet;
import edu.illinois.ncsa.bouncycastle.asn1.DERT61String;
import edu.illinois.ncsa.bouncycastle.asn1.DERTaggedObject;
import edu.illinois.ncsa.bouncycastle.asn1.DERUTCTime;
import edu.illinois.ncsa.bouncycastle.asn1.DERUTF8String;
import edu.illinois.ncsa.bouncycastle.asn1.DERUniversalString;
import edu.illinois.ncsa.bouncycastle.asn1.DERUnknownTag;
import edu.illinois.ncsa.bouncycastle.asn1.DERVisibleString;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTestResult;
import edu.illinois.ncsa.bouncycastle.util.test.Test;
import edu.illinois.ncsa.bouncycastle.util.test.TestResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Date;

public class EqualsAndHashCodeTest
implements Test {
    public TestResult perform() {
        byte[] byArray = new byte[]{0, 1, 0, 1, 0, 0, 1};
        DERObject[] dERObjectArray = new DERObject[]{new BERConstructedOctetString(byArray), new BERSequence(new DERPrintableString("hello world")), new BERSet(new DERPrintableString("hello world")), new BERTaggedObject(0, new DERPrintableString("hello world")), new DERApplicationSpecific(0, byArray), new DERBitString(byArray), new DERBMPString("hello world"), new DERBoolean(true), new DERBoolean(false), new DEREnumerated(100), new DERGeneralizedTime("20070315173729Z"), new DERGeneralString("hello world"), new DERIA5String("hello"), new DERInteger(1000), new DERNull(), new DERNumericString("123456"), new DERObjectIdentifier("1.1.1.10000.1"), new DEROctetString(byArray), new DERPrintableString("hello world"), new DERSequence(new DERPrintableString("hello world")), new DERSet(new DERPrintableString("hello world")), new DERT61String("hello world"), new DERTaggedObject(0, new DERPrintableString("hello world")), new DERUniversalString(byArray), new DERUnknownTag(true, 500, byArray), new DERUTCTime(new Date()), new DERUTF8String("hello world"), new DERVisibleString("hello world")};
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            for (int i = 0; i != dERObjectArray.length; ++i) {
                aSN1OutputStream.writeObject(dERObjectArray[i]);
            }
            DERObject[] dERObjectArray2 = new DERObject[dERObjectArray.length];
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            for (int i = 0; i != dERObjectArray.length; ++i) {
                DERObject dERObject = aSN1InputStream.readObject();
                if (!dERObject.equals(dERObjectArray[i])) {
                    return new SimpleTestResult(false, this.getName() + ": Failed equality test for " + dERObject.getClass());
                }
                if (dERObject.hashCode() == dERObjectArray[i].hashCode()) continue;
                return new SimpleTestResult(false, this.getName() + ": Failed hashCode test for " + dERObject.getClass());
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": Failed - exception " + exception.toString(), exception);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public String getName() {
        return "EqualsAndHashCode";
    }

    public static void main(String[] stringArray) {
        EqualsAndHashCodeTest equalsAndHashCodeTest = new EqualsAndHashCodeTest();
        TestResult testResult = equalsAndHashCodeTest.perform();
        System.out.println(testResult);
    }
}

