/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1EncodableVector;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Set;
import edu.illinois.ncsa.bouncycastle.asn1.BERSet;
import edu.illinois.ncsa.bouncycastle.asn1.DERBitString;
import edu.illinois.ncsa.bouncycastle.asn1.DERBoolean;
import edu.illinois.ncsa.bouncycastle.asn1.DERInteger;
import edu.illinois.ncsa.bouncycastle.asn1.DEROctetString;
import edu.illinois.ncsa.bouncycastle.asn1.DERSequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERSet;
import edu.illinois.ncsa.bouncycastle.asn1.DERTaggedObject;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;

public class SetTest
extends SimpleTest {
    public String getName() {
        return "Set";
    }

    private void checkedSortedSet(int n, ASN1Set aSN1Set) {
        if (aSN1Set.getObjectAt(0) instanceof DERBoolean && aSN1Set.getObjectAt(1) instanceof DERInteger && aSN1Set.getObjectAt(2) instanceof DERBitString && aSN1Set.getObjectAt(3) instanceof DEROctetString) {
            return;
        }
        this.fail("sorting failed on attempt: " + n);
    }

    public void performTest() {
        DERTaggedObject dERTaggedObject;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        byte[] byArray = new byte[10];
        aSN1EncodableVector.add(new DEROctetString(byArray));
        aSN1EncodableVector.add(new DERBitString(byArray));
        aSN1EncodableVector.add(new DERInteger(100));
        aSN1EncodableVector.add(new DERBoolean(true));
        this.checkedSortedSet(0, new DERSet(aSN1EncodableVector));
        aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DERInteger(100));
        aSN1EncodableVector.add(new DERBoolean(true));
        aSN1EncodableVector.add(new DEROctetString(byArray));
        aSN1EncodableVector.add(new DERBitString(byArray));
        this.checkedSortedSet(1, new DERSet(aSN1EncodableVector));
        aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DERBoolean(true));
        aSN1EncodableVector.add(new DEROctetString(byArray));
        aSN1EncodableVector.add(new DERBitString(byArray));
        aSN1EncodableVector.add(new DERInteger(100));
        this.checkedSortedSet(2, new DERSet(aSN1EncodableVector));
        aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DERBitString(byArray));
        aSN1EncodableVector.add(new DEROctetString(byArray));
        aSN1EncodableVector.add(new DERInteger(100));
        aSN1EncodableVector.add(new DERBoolean(true));
        this.checkedSortedSet(3, new DERSet(aSN1EncodableVector));
        aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DEROctetString(byArray));
        aSN1EncodableVector.add(new DERBitString(byArray));
        aSN1EncodableVector.add(new DERInteger(100));
        aSN1EncodableVector.add(new DERBoolean(true));
        ASN1Set aSN1Set = new BERSet(aSN1EncodableVector);
        if (!(aSN1Set.getObjectAt(0) instanceof DEROctetString)) {
            this.fail("BER set sort order changed.");
        }
        if ((aSN1Set = ASN1Set.getInstance(dERTaggedObject = new DERTaggedObject(false, 1, new DERSequence(aSN1EncodableVector)), false)).getObjectAt(0) instanceof DERBoolean) {
            this.fail("sorted when shouldn't be.");
        }
        aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DERBoolean(true));
        aSN1EncodableVector.add(new DERBoolean(true));
        aSN1EncodableVector.add(new DERBoolean(true));
        aSN1Set = new DERSet(aSN1EncodableVector);
    }

    public static void main(String[] stringArray) {
        SetTest.runTest(new SetTest());
    }
}

