/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.DERObject;
import edu.illinois.ncsa.bouncycastle.asn1.DERObjectIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.x509.qualified.TypeOfBiometricData;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;
import java.io.IOException;

public class TypeOfBiometricDataUnitTest
extends SimpleTest {
    public String getName() {
        return "TypeOfBiometricData";
    }

    public void performTest() throws Exception {
        this.checkPredefinedType(0);
        this.checkPredefinedType(1);
        DERObjectIdentifier dERObjectIdentifier = new DERObjectIdentifier("1.1");
        TypeOfBiometricData typeOfBiometricData = new TypeOfBiometricData(dERObjectIdentifier);
        this.checkNonPredefined(typeOfBiometricData, dERObjectIdentifier);
        typeOfBiometricData = TypeOfBiometricData.getInstance(typeOfBiometricData);
        this.checkNonPredefined(typeOfBiometricData, dERObjectIdentifier);
        DERObject dERObject = typeOfBiometricData.toASN1Object();
        typeOfBiometricData = TypeOfBiometricData.getInstance(dERObject);
        this.checkNonPredefined(typeOfBiometricData, dERObjectIdentifier);
        typeOfBiometricData = TypeOfBiometricData.getInstance(null);
        if (typeOfBiometricData != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            TypeOfBiometricData.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new TypeOfBiometricData(100);
            this.fail("constructor failed to detect bad predefined type.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkPredefinedType(int n) throws IOException {
        TypeOfBiometricData typeOfBiometricData = new TypeOfBiometricData(n);
        this.checkPredefined(typeOfBiometricData, n);
        typeOfBiometricData = TypeOfBiometricData.getInstance(typeOfBiometricData);
        this.checkPredefined(typeOfBiometricData, n);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(typeOfBiometricData.toASN1Object().getEncoded());
        DERObject dERObject = aSN1InputStream.readObject();
        typeOfBiometricData = TypeOfBiometricData.getInstance(dERObject);
        this.checkPredefined(typeOfBiometricData, n);
    }

    private void checkPredefined(TypeOfBiometricData typeOfBiometricData, int n) {
        if (!typeOfBiometricData.isPredefined()) {
            this.fail("predefined type expected but not found.");
        }
        if (typeOfBiometricData.getPredefinedBiometricType() != n) {
            this.fail("predefined type does not match.");
        }
    }

    private void checkNonPredefined(TypeOfBiometricData typeOfBiometricData, DERObjectIdentifier dERObjectIdentifier) {
        if (typeOfBiometricData.isPredefined()) {
            this.fail("predefined type found when not expected.");
        }
        if (!typeOfBiometricData.getBiometricDataOid().equals(dERObjectIdentifier)) {
            this.fail("data oid does not match.");
        }
    }

    public static void main(String[] stringArray) {
        TypeOfBiometricDataUnitTest.runTest(new TypeOfBiometricDataUnitTest());
    }
}

