/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1EncodableVector;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Object;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1ObjectIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1OutputStream;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Set;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1String;
import edu.illinois.ncsa.bouncycastle.asn1.DEREncodable;
import edu.illinois.ncsa.bouncycastle.asn1.DERGeneralizedTime;
import edu.illinois.ncsa.bouncycastle.asn1.DERIA5String;
import edu.illinois.ncsa.bouncycastle.asn1.DERPrintableString;
import edu.illinois.ncsa.bouncycastle.asn1.DERSequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERSet;
import edu.illinois.ncsa.bouncycastle.asn1.DERTaggedObject;
import edu.illinois.ncsa.bouncycastle.asn1.DERUTF8String;
import edu.illinois.ncsa.bouncycastle.asn1.x500.RDN;
import edu.illinois.ncsa.bouncycastle.asn1.x500.X500Name;
import edu.illinois.ncsa.bouncycastle.asn1.x500.X500NameBuilder;
import edu.illinois.ncsa.bouncycastle.asn1.x500.style.BCStyle;
import edu.illinois.ncsa.bouncycastle.asn1.x509.X509DefaultEntryConverter;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class X500NameTest
extends SimpleTest {
    String[] subjects = new String[]{"C=AU,ST=Victoria,L=South Melbourne,O=Connect 4 Pty Ltd,OU=Webserver Team,CN=www2.connect4.com.au,E=webmaster@connect4.com.au", "C=AU,ST=Victoria,L=South Melbourne,O=Connect 4 Pty Ltd,OU=Certificate Authority,CN=Connect 4 CA,E=webmaster@connect4.com.au", "C=AU,ST=QLD,CN=SSLeay/rsa test cert", "C=US,O=National Aeronautics and Space Administration,SERIALNUMBER=16+CN=Steve Schoch", "E=cooke@issl.atl.hp.com,C=US,OU=Hewlett Packard Company (ISSL),CN=Paul A. Cooke", "O=Sun Microsystems Inc,CN=store.sun.com", "unstructuredAddress=192.168.1.33,unstructuredName=pixfirewall.ciscopix.com,CN=pixfirewall.ciscopix.com"};

    public String getName() {
        return "X500Name";
    }

    private static X500Name fromBytes(byte[] byArray) throws IOException {
        return X500Name.getInstance(new ASN1InputStream(new ByteArrayInputStream(byArray)).readObject());
    }

    private DEREncodable createEntryValue(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        X500NameBuilder x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        x500NameBuilder.addRDN(aSN1ObjectIdentifier, string);
        X500Name x500Name = x500NameBuilder.build();
        ASN1Sequence aSN1Sequence = (ASN1Sequence)x500Name.getDERObject();
        ASN1Set aSN1Set = ASN1Set.getInstance(aSN1Sequence.getObjectAt(0).getDERObject());
        aSN1Sequence = (ASN1Sequence)aSN1Set.getObjectAt(0);
        return aSN1Sequence.getObjectAt(1);
    }

    private DEREncodable createEntryValueFromString(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        X500NameBuilder x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        x500NameBuilder.addRDN(aSN1ObjectIdentifier, string);
        X500Name x500Name = new X500Name(x500NameBuilder.build().toString());
        ASN1Sequence aSN1Sequence = (ASN1Sequence)x500Name.getDERObject();
        ASN1Set aSN1Set = ASN1Set.getInstance(aSN1Sequence.getObjectAt(0).getDERObject());
        aSN1Sequence = (ASN1Sequence)aSN1Set.getObjectAt(0);
        return aSN1Sequence.getObjectAt(1);
    }

    private void testEncodingPrintableString(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        DEREncodable dEREncodable = this.createEntryValue(aSN1ObjectIdentifier, string);
        if (!(dEREncodable instanceof DERPrintableString)) {
            this.fail("encoding for " + aSN1ObjectIdentifier + " not printable string");
        }
    }

    private void testEncodingIA5String(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        DEREncodable dEREncodable = this.createEntryValue(aSN1ObjectIdentifier, string);
        if (!(dEREncodable instanceof DERIA5String)) {
            this.fail("encoding for " + aSN1ObjectIdentifier + " not IA5String");
        }
    }

    private void testEncodingGeneralizedTime(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        DEREncodable dEREncodable = this.createEntryValue(aSN1ObjectIdentifier, string);
        if (!(dEREncodable instanceof DERGeneralizedTime)) {
            this.fail("encoding for " + aSN1ObjectIdentifier + " not GeneralizedTime");
        }
        if (!((dEREncodable = this.createEntryValueFromString(aSN1ObjectIdentifier, string)) instanceof DERGeneralizedTime)) {
            this.fail("encoding for " + aSN1ObjectIdentifier + " not GeneralizedTime");
        }
    }

    public void performTest() throws Exception {
        RDN[] rDNArray;
        X500Name x500Name;
        X500Name x500Name2;
        X500Name x500Name3;
        this.testEncodingPrintableString(BCStyle.C, "AU");
        this.testEncodingPrintableString(BCStyle.SERIALNUMBER, "123456");
        this.testEncodingPrintableString(BCStyle.DN_QUALIFIER, "123456");
        this.testEncodingIA5String(BCStyle.EmailAddress, "test@test.com");
        this.testEncodingIA5String(BCStyle.DC, "test");
        this.testEncodingGeneralizedTime(BCStyle.DATE_OF_BIRTH, "#180F32303032303132323132323232305A");
        this.testEncodingGeneralizedTime(BCStyle.DATE_OF_BIRTH, "20020122122220Z");
        X500NameBuilder x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        x500NameBuilder.addRDN(BCStyle.C, "AU");
        x500NameBuilder.addRDN(BCStyle.O, "The Legion of the Bouncy Castle");
        x500NameBuilder.addRDN(BCStyle.L, "Melbourne");
        x500NameBuilder.addRDN(BCStyle.ST, "Victoria");
        x500NameBuilder.addRDN(BCStyle.E, "feedback-crypto@bouncycastle.org");
        X500Name x500Name4 = x500NameBuilder.build();
        if (!x500Name4.equals(x500Name4)) {
            this.fail("Failed same object test");
        }
        x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        x500NameBuilder.addRDN(BCStyle.C, "AU");
        x500NameBuilder.addRDN(BCStyle.O, "The Legion of the Bouncy Castle");
        x500NameBuilder.addRDN(BCStyle.L, "Melbourne");
        x500NameBuilder.addRDN(BCStyle.ST, "Victoria");
        x500NameBuilder.addRDN(BCStyle.E, "feedback-crypto@bouncycastle.org");
        X500Name x500Name5 = x500NameBuilder.build();
        if (!x500Name4.equals(x500Name5)) {
            this.fail("Failed same name test");
        }
        if (x500Name4.hashCode() != x500Name5.hashCode()) {
            this.fail("Failed same name test - in Order");
        }
        X500NameBuilder x500NameBuilder2 = new X500NameBuilder(BCStyle.INSTANCE);
        x500NameBuilder.addRDN(BCStyle.C, "AU");
        x500NameBuilder.addRDN(BCStyle.O, "The Legion of the Bouncy Castle");
        x500NameBuilder.addRDN(BCStyle.L, "Melbourne");
        x500NameBuilder.addRDN(BCStyle.ST, "Victoria");
        x500NameBuilder.addRDN(BCStyle.E, "feedback-crypto@bouncycastle.org");
        X500NameBuilder x500NameBuilder3 = new X500NameBuilder(BCStyle.INSTANCE);
        x500NameBuilder.addRDN(BCStyle.E, "feedback-crypto@bouncycastle.org");
        x500NameBuilder.addRDN(BCStyle.C, "AU");
        x500NameBuilder.addRDN(BCStyle.O, "The Legion of the Bouncy Castle");
        x500NameBuilder.addRDN(BCStyle.L, "Melbourne");
        x500NameBuilder.addRDN(BCStyle.ST, "Victoria");
        x500Name4 = x500NameBuilder2.build();
        x500Name5 = x500NameBuilder3.build();
        if (!x500Name4.equals(x500Name5)) {
            this.fail("Failed reverse name test");
        }
        if (x500Name4.hashCode() != x500Name5.hashCode()) {
            this.fail("Failed reverse name test hashCode");
        }
        for (int i = 0; i != this.subjects.length; ++i) {
            x500Name3 = new X500Name(this.subjects[i]);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.writeObject(x500Name3);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            x500Name3 = X500Name.getInstance(aSN1InputStream.readObject());
            if (x500Name3.toString().equals(this.subjects[i])) continue;
            this.fail("failed regeneration test " + i);
        }
        X500Name x500Name6 = new X500Name("SERIALNUMBER=BBB + CN=AA");
        if (!X500NameTest.fromBytes(x500Name6.getEncoded()).toString().equals("CN=AA+SERIALNUMBER=BBB")) {
            this.fail("failed sort test 1");
        }
        if (!X500NameTest.fromBytes((x500Name6 = new X500Name("CN=AA + SERIALNUMBER=BBB")).getEncoded()).toString().equals("CN=AA+SERIALNUMBER=BBB")) {
            this.fail("failed sort test 2");
        }
        if (!X500NameTest.fromBytes((x500Name6 = new X500Name("SERIALNUMBER=B + CN=AA")).getEncoded()).toString().equals("SERIALNUMBER=B+CN=AA")) {
            this.fail("failed sort test 3");
        }
        if (!X500NameTest.fromBytes((x500Name6 = new X500Name("CN=AA + SERIALNUMBER=B")).getEncoded()).toString().equals("SERIALNUMBER=B+CN=AA")) {
            this.fail("failed sort test 4");
        }
        this.equalityTest(new X500Name("CN=The     Legion"), new X500Name("CN=The Legion"));
        this.equalityTest(new X500Name("CN=   The Legion"), new X500Name("CN=The Legion"));
        this.equalityTest(new X500Name("CN=The Legion   "), new X500Name("CN=The Legion"));
        this.equalityTest(new X500Name("CN=  The     Legion "), new X500Name("CN=The Legion"));
        this.equalityTest(new X500Name("CN=  the     legion "), new X500Name("CN=The Legion"));
        this.equalityTest(new X500Name("CN=  the     legion+C=AU, O=Legion "), new X500Name("CN=The Legion+C=AU, O=Legion"));
        x500Name3 = new X500Name("SERIALNUMBER=8,O=ABC,CN=ABC Class 3 CA,C=LT");
        X500Name x500Name7 = new X500Name("2.5.4.5=8,O=ABC,CN=ABC Class 3 CA,C=LT");
        X500Name x500Name8 = new X500Name("2.5.4.5=#130138,O=ABC,CN=ABC Class 3 CA,C=LT");
        this.equalityTest(x500Name3, x500Name7);
        this.equalityTest(x500Name7, x500Name8);
        this.equalityTest(x500Name8, x500Name3);
        x500Name3 = new X500Name("2.5.4.5=#130138,CN=SSC Class 3 CA,O=UAB Skaitmeninio sertifikavimo centras,C=LT");
        x500Name7 = new X500Name("SERIALNUMBER=#130138,CN=SSC Class 3 CA,O=UAB Skaitmeninio sertifikavimo centras,C=LT");
        x500Name8 = X500Name.getInstance(ASN1Object.fromByteArray(Hex.decode("3063310b3009060355040613024c54312f302d060355040a132655414220536b6169746d656e696e696f20736572746966696b6176696d6f2063656e74726173311730150603550403130e53534320436c6173732033204341310a30080603550405130138")));
        this.equalityTest(x500Name3, x500Name7);
        this.equalityTest(x500Name7, x500Name8);
        this.equalityTest(x500Name8, x500Name3);
        x500Name3 = new X500Name("SERIALNUMBER=8,O=XX,CN=ABC Class 3 CA,C=LT");
        x500Name7 = new X500Name("2.5.4.5=8,O=,CN=ABC Class 3 CA,C=LT");
        x500Name3 = new X500Name("SERIALNUMBER=8,O=,CN=ABC Class 3 CA,C=LT");
        x500Name7 = new X500Name("2.5.4.5=8,O=,CN=ABC Class 3 CA,C=LT");
        this.equalityTest(x500Name3, x500Name7);
        x500Name4 = new X500Name("CN=The Legion");
        if (x500Name4.equals(new DERSequence())) {
            this.fail("inequality test with sequence");
        }
        if (x500Name4.equals(new DERSequence(new DERSet()))) {
            this.fail("inequality test with sequence and set");
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1ObjectIdentifier("1.1"));
        aSN1EncodableVector.add(new ASN1ObjectIdentifier("1.1"));
        if (x500Name4.equals(new DERSequence(new DERSet(new DERSet(aSN1EncodableVector))))) {
            this.fail("inequality test with sequence and bad set");
        }
        if (x500Name4.equals(new DERSequence(new DERSet(new DERSet(aSN1EncodableVector))))) {
            this.fail("inequality test with sequence and bad set");
        }
        if (x500Name4.equals(new DERSequence(new DERSet(new DERSequence())))) {
            this.fail("inequality test with sequence and short sequence");
        }
        if (x500Name4.equals(new DERSequence(new DERSet(new DERSequence())))) {
            this.fail("inequality test with sequence and short sequence");
        }
        aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1ObjectIdentifier("1.1"));
        aSN1EncodableVector.add(new DERSequence());
        if (x500Name4.equals(new DERSequence(new DERSet(new DERSequence(aSN1EncodableVector))))) {
            this.fail("inequality test with sequence and bad sequence");
        }
        if (x500Name4.equals(null)) {
            this.fail("inequality test with null");
        }
        x500Name6 = new X500Name("CN=AA + CN=AA + CN=AA");
        DERTaggedObject dERTaggedObject = new DERTaggedObject(false, 1, new X500Name("CN=AA"));
        if (!dERTaggedObject.isExplicit()) {
            this.fail("failed to explicitly tag CHOICE object");
        }
        if (!(x500Name2 = X500Name.getInstance(dERTaggedObject, false)).equals(new X500Name("CN=AA"))) {
            this.fail("failed to recover tagged name");
        }
        DERUTF8String dERUTF8String = new DERUTF8String("The Legion of the Bouncy Castle");
        byte[] byArray = dERUTF8String.getEncoded();
        byte[] byArray2 = Hex.encode(byArray);
        String string = "#" + new String(byArray2);
        DERUTF8String dERUTF8String2 = (DERUTF8String)new X509DefaultEntryConverter().getConvertedValue(BCStyle.L, string);
        if (!dERUTF8String2.equals(dERUTF8String)) {
            this.fail("failed X509DefaultEntryConverter test");
        }
        if (!(dERUTF8String2 = (DERUTF8String)new X509DefaultEntryConverter().getConvertedValue(BCStyle.L, "\\" + string)).equals(new DERUTF8String(string))) {
            this.fail("failed X509DefaultEntryConverter test got " + dERUTF8String2 + " expected: " + string);
        }
        if (!(x500Name = new X500Name("CN=\\#nothex#string")).toString().equals("CN=\\#nothex#string")) {
            this.fail("# string not properly escaped.");
        }
        if ((rDNArray = x500Name.getRDNs(BCStyle.CN)).length != 1 || !this.getValue(rDNArray[0]).equals("#nothex#string")) {
            this.fail("escaped # not reduced properly");
        }
        if ((rDNArray = (x500Name = new X500Name("CN=\"a+b\"")).getRDNs(BCStyle.CN)).length != 1 || !this.getValue(rDNArray[0]).equals("a+b")) {
            this.fail("escaped + not reduced properly");
        }
        if ((rDNArray = (x500Name = new X500Name("CN=a\\+b")).getRDNs(BCStyle.CN)).length != 1 || !this.getValue(rDNArray[0]).equals("a+b")) {
            this.fail("escaped + not reduced properly");
        }
        if (!x500Name.toString().equals("CN=a\\+b")) {
            this.fail("+ in string not properly escaped.");
        }
        if ((rDNArray = (x500Name = new X500Name("CN=a\\=b")).getRDNs(BCStyle.CN)).length != 1 || !this.getValue(rDNArray[0]).equals("a=b")) {
            this.fail("escaped = not reduced properly");
        }
        if (!x500Name.toString().equals("CN=a\\=b")) {
            this.fail("= in string not properly escaped.");
        }
        if ((rDNArray = (x500Name = new X500Name("TELEPHONENUMBER=\"+61999999999\"")).getRDNs(BCStyle.TELEPHONE_NUMBER)).length != 1 || !this.getValue(rDNArray[0]).equals("+61999999999")) {
            this.fail("telephonenumber escaped + not reduced properly");
        }
        if ((rDNArray = (x500Name = new X500Name("TELEPHONENUMBER=\\+61999999999")).getRDNs(BCStyle.TELEPHONE_NUMBER)).length != 1 || !this.getValue(rDNArray[0]).equals("+61999999999")) {
            this.fail("telephonenumber escaped + not reduced properly");
        }
    }

    private String getValue(RDN rDN) {
        return ((ASN1String)((Object)rDN.getFirst().getValue())).getString();
    }

    private void equalityTest(X500Name x500Name, X500Name x500Name2) {
        if (!x500Name.equals(x500Name2)) {
            this.fail("equality test failed for " + x500Name + " : " + x500Name2);
        }
        if (x500Name.hashCode() != x500Name2.hashCode()) {
            this.fail("hashCodeTest test failed for " + x500Name + " : " + x500Name2);
        }
    }

    public static void main(String[] stringArray) {
        X500NameTest.runTest(new X500NameTest());
    }
}

