/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.util;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1OctetString;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Set;
import edu.illinois.ncsa.bouncycastle.asn1.BERApplicationSpecific;
import edu.illinois.ncsa.bouncycastle.asn1.BERConstructedOctetString;
import edu.illinois.ncsa.bouncycastle.asn1.BERSequence;
import edu.illinois.ncsa.bouncycastle.asn1.BERSet;
import edu.illinois.ncsa.bouncycastle.asn1.BERTaggedObject;
import edu.illinois.ncsa.bouncycastle.asn1.DERApplicationSpecific;
import edu.illinois.ncsa.bouncycastle.asn1.DERBMPString;
import edu.illinois.ncsa.bouncycastle.asn1.DERBitString;
import edu.illinois.ncsa.bouncycastle.asn1.DERBoolean;
import edu.illinois.ncsa.bouncycastle.asn1.DEREncodable;
import edu.illinois.ncsa.bouncycastle.asn1.DEREnumerated;
import edu.illinois.ncsa.bouncycastle.asn1.DERExternal;
import edu.illinois.ncsa.bouncycastle.asn1.DERGeneralizedTime;
import edu.illinois.ncsa.bouncycastle.asn1.DERIA5String;
import edu.illinois.ncsa.bouncycastle.asn1.DERInteger;
import edu.illinois.ncsa.bouncycastle.asn1.DERNull;
import edu.illinois.ncsa.bouncycastle.asn1.DERObject;
import edu.illinois.ncsa.bouncycastle.asn1.DERObjectIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.DEROctetString;
import edu.illinois.ncsa.bouncycastle.asn1.DERPrintableString;
import edu.illinois.ncsa.bouncycastle.asn1.DERSequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERSet;
import edu.illinois.ncsa.bouncycastle.asn1.DERT61String;
import edu.illinois.ncsa.bouncycastle.asn1.DERTaggedObject;
import edu.illinois.ncsa.bouncycastle.asn1.DERUTCTime;
import edu.illinois.ncsa.bouncycastle.asn1.DERUTF8String;
import edu.illinois.ncsa.bouncycastle.asn1.DERUnknownTag;
import edu.illinois.ncsa.bouncycastle.asn1.DERVisibleString;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.util.Enumeration;

public class ASN1Dump {
    private static final String TAB = "    ";
    private static final int SAMPLE_SIZE = 32;

    static void _dumpAsString(String string, boolean bl, DERObject dERObject, StringBuffer stringBuffer) {
        String string2 = System.getProperty("line.separator");
        if (dERObject instanceof ASN1Sequence) {
            Enumeration enumeration = ((ASN1Sequence)dERObject).getObjects();
            String string3 = string + TAB;
            stringBuffer.append(string);
            if (dERObject instanceof BERSequence) {
                stringBuffer.append("BER Sequence");
            } else if (dERObject instanceof DERSequence) {
                stringBuffer.append("DER Sequence");
            } else {
                stringBuffer.append("Sequence");
            }
            stringBuffer.append(string2);
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null || e.equals(new DERNull())) {
                    stringBuffer.append(string3);
                    stringBuffer.append("NULL");
                    stringBuffer.append(string2);
                    continue;
                }
                if (e instanceof DERObject) {
                    ASN1Dump._dumpAsString(string3, bl, (DERObject)e, stringBuffer);
                    continue;
                }
                ASN1Dump._dumpAsString(string3, bl, ((DEREncodable)e).getDERObject(), stringBuffer);
            }
        } else if (dERObject instanceof DERTaggedObject) {
            String string4 = string + TAB;
            stringBuffer.append(string);
            if (dERObject instanceof BERTaggedObject) {
                stringBuffer.append("BER Tagged [");
            } else {
                stringBuffer.append("Tagged [");
            }
            DERTaggedObject dERTaggedObject = (DERTaggedObject)dERObject;
            stringBuffer.append(Integer.toString(dERTaggedObject.getTagNo()));
            stringBuffer.append(']');
            if (!dERTaggedObject.isExplicit()) {
                stringBuffer.append(" IMPLICIT ");
            }
            stringBuffer.append(string2);
            if (dERTaggedObject.isEmpty()) {
                stringBuffer.append(string4);
                stringBuffer.append("EMPTY");
                stringBuffer.append(string2);
            } else {
                ASN1Dump._dumpAsString(string4, bl, dERTaggedObject.getObject(), stringBuffer);
            }
        } else if (dERObject instanceof BERSet) {
            Enumeration enumeration = ((ASN1Set)dERObject).getObjects();
            String string5 = string + TAB;
            stringBuffer.append(string);
            stringBuffer.append("BER Set");
            stringBuffer.append(string2);
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null) {
                    stringBuffer.append(string5);
                    stringBuffer.append("NULL");
                    stringBuffer.append(string2);
                    continue;
                }
                if (e instanceof DERObject) {
                    ASN1Dump._dumpAsString(string5, bl, (DERObject)e, stringBuffer);
                    continue;
                }
                ASN1Dump._dumpAsString(string5, bl, ((DEREncodable)e).getDERObject(), stringBuffer);
            }
        } else if (dERObject instanceof DERSet) {
            Enumeration enumeration = ((ASN1Set)dERObject).getObjects();
            String string6 = string + TAB;
            stringBuffer.append(string);
            stringBuffer.append("DER Set");
            stringBuffer.append(string2);
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null) {
                    stringBuffer.append(string6);
                    stringBuffer.append("NULL");
                    stringBuffer.append(string2);
                    continue;
                }
                if (e instanceof DERObject) {
                    ASN1Dump._dumpAsString(string6, bl, (DERObject)e, stringBuffer);
                    continue;
                }
                ASN1Dump._dumpAsString(string6, bl, ((DEREncodable)e).getDERObject(), stringBuffer);
            }
        } else if (dERObject instanceof DERObjectIdentifier) {
            stringBuffer.append(string + "ObjectIdentifier(" + ((DERObjectIdentifier)dERObject).getId() + ")" + string2);
        } else if (dERObject instanceof DERBoolean) {
            stringBuffer.append(string + "Boolean(" + ((DERBoolean)dERObject).isTrue() + ")" + string2);
        } else if (dERObject instanceof DERInteger) {
            stringBuffer.append(string + "Integer(" + ((DERInteger)dERObject).getValue() + ")" + string2);
        } else if (dERObject instanceof BERConstructedOctetString) {
            ASN1OctetString aSN1OctetString = (ASN1OctetString)dERObject;
            stringBuffer.append(string + "BER Constructed Octet String" + "[" + aSN1OctetString.getOctets().length + "] ");
            if (bl) {
                stringBuffer.append(ASN1Dump.dumpBinaryDataAsString(string, aSN1OctetString.getOctets()));
            } else {
                stringBuffer.append(string2);
            }
        } else if (dERObject instanceof DEROctetString) {
            ASN1OctetString aSN1OctetString = (ASN1OctetString)dERObject;
            stringBuffer.append(string + "DER Octet String" + "[" + aSN1OctetString.getOctets().length + "] ");
            if (bl) {
                stringBuffer.append(ASN1Dump.dumpBinaryDataAsString(string, aSN1OctetString.getOctets()));
            } else {
                stringBuffer.append(string2);
            }
        } else if (dERObject instanceof DERBitString) {
            DERBitString dERBitString = (DERBitString)dERObject;
            stringBuffer.append(string + "DER Bit String" + "[" + dERBitString.getBytes().length + ", " + dERBitString.getPadBits() + "] ");
            if (bl) {
                stringBuffer.append(ASN1Dump.dumpBinaryDataAsString(string, dERBitString.getBytes()));
            } else {
                stringBuffer.append(string2);
            }
        } else if (dERObject instanceof DERIA5String) {
            stringBuffer.append(string + "IA5String(" + ((DERIA5String)dERObject).getString() + ") " + string2);
        } else if (dERObject instanceof DERUTF8String) {
            stringBuffer.append(string + "UTF8String(" + ((DERUTF8String)dERObject).getString() + ") " + string2);
        } else if (dERObject instanceof DERPrintableString) {
            stringBuffer.append(string + "PrintableString(" + ((DERPrintableString)dERObject).getString() + ") " + string2);
        } else if (dERObject instanceof DERVisibleString) {
            stringBuffer.append(string + "VisibleString(" + ((DERVisibleString)dERObject).getString() + ") " + string2);
        } else if (dERObject instanceof DERBMPString) {
            stringBuffer.append(string + "BMPString(" + ((DERBMPString)dERObject).getString() + ") " + string2);
        } else if (dERObject instanceof DERT61String) {
            stringBuffer.append(string + "T61String(" + ((DERT61String)dERObject).getString() + ") " + string2);
        } else if (dERObject instanceof DERUTCTime) {
            stringBuffer.append(string + "UTCTime(" + ((DERUTCTime)dERObject).getTime() + ") " + string2);
        } else if (dERObject instanceof DERGeneralizedTime) {
            stringBuffer.append(string + "GeneralizedTime(" + ((DERGeneralizedTime)dERObject).getTime() + ") " + string2);
        } else if (dERObject instanceof DERUnknownTag) {
            stringBuffer.append(string + "Unknown " + Integer.toString(((DERUnknownTag)dERObject).getTag(), 16) + " " + new String(Hex.encode(((DERUnknownTag)dERObject).getData())) + string2);
        } else if (dERObject instanceof BERApplicationSpecific) {
            stringBuffer.append(ASN1Dump.outputApplicationSpecific("BER", string, bl, dERObject, string2));
        } else if (dERObject instanceof DERApplicationSpecific) {
            stringBuffer.append(ASN1Dump.outputApplicationSpecific("DER", string, bl, dERObject, string2));
        } else if (dERObject instanceof DEREnumerated) {
            DEREnumerated dEREnumerated = (DEREnumerated)dERObject;
            stringBuffer.append(string + "DER Enumerated(" + dEREnumerated.getValue() + ")" + string2);
        } else if (dERObject instanceof DERExternal) {
            DERExternal dERExternal = (DERExternal)dERObject;
            stringBuffer.append(string + "External " + string2);
            String string7 = string + TAB;
            if (dERExternal.getDirectReference() != null) {
                stringBuffer.append(string7 + "Direct Reference: " + dERExternal.getDirectReference().getId() + string2);
            }
            if (dERExternal.getIndirectReference() != null) {
                stringBuffer.append(string7 + "Indirect Reference: " + dERExternal.getIndirectReference().toString() + string2);
            }
            if (dERExternal.getDataValueDescriptor() != null) {
                ASN1Dump._dumpAsString(string7, bl, dERExternal.getDataValueDescriptor(), stringBuffer);
            }
            stringBuffer.append(string7 + "Encoding: " + dERExternal.getEncoding() + string2);
            ASN1Dump._dumpAsString(string7, bl, dERExternal.getExternalContent(), stringBuffer);
        } else {
            stringBuffer.append(string + dERObject.toString() + string2);
        }
    }

    private static String outputApplicationSpecific(String string, String string2, boolean bl, DERObject dERObject, String string3) {
        DERApplicationSpecific dERApplicationSpecific = (DERApplicationSpecific)dERObject;
        StringBuffer stringBuffer = new StringBuffer();
        if (dERApplicationSpecific.isConstructed()) {
            try {
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(dERApplicationSpecific.getObject(16));
                stringBuffer.append(string2 + string + " ApplicationSpecific[" + dERApplicationSpecific.getApplicationTag() + "]" + string3);
                Enumeration enumeration = aSN1Sequence.getObjects();
                while (enumeration.hasMoreElements()) {
                    ASN1Dump._dumpAsString(string2 + TAB, bl, (DERObject)enumeration.nextElement(), stringBuffer);
                }
            }
            catch (IOException iOException) {
                stringBuffer.append(iOException);
            }
            return stringBuffer.toString();
        }
        return string2 + string + " ApplicationSpecific[" + dERApplicationSpecific.getApplicationTag() + "] (" + new String(Hex.encode(dERApplicationSpecific.getContents())) + ")" + string3;
    }

    public static String dumpAsString(Object object) {
        return ASN1Dump.dumpAsString(object, false);
    }

    public static String dumpAsString(Object object, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof DERObject) {
            ASN1Dump._dumpAsString("", bl, (DERObject)object, stringBuffer);
        } else if (object instanceof DEREncodable) {
            ASN1Dump._dumpAsString("", bl, ((DEREncodable)object).getDERObject(), stringBuffer);
        } else {
            return "unknown object type " + object.toString();
        }
        return stringBuffer.toString();
    }

    private static String dumpBinaryDataAsString(String string, byte[] byArray) {
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        string = string + TAB;
        stringBuffer.append(string2);
        for (int i = 0; i < byArray.length; i += 32) {
            if (byArray.length - i > 32) {
                stringBuffer.append(string);
                stringBuffer.append(new String(Hex.encode(byArray, i, 32)));
                stringBuffer.append(TAB);
                stringBuffer.append(ASN1Dump.calculateAscString(byArray, i, 32));
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(string);
            stringBuffer.append(new String(Hex.encode(byArray, i, byArray.length - i)));
            for (int j = byArray.length - i; j != 32; ++j) {
                stringBuffer.append("  ");
            }
            stringBuffer.append(TAB);
            stringBuffer.append(ASN1Dump.calculateAscString(byArray, i, byArray.length - i));
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private static String calculateAscString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i != n + n2; ++i) {
            if (byArray[i] < 32 || byArray[i] > 126) continue;
            stringBuffer.append((char)byArray[i]);
        }
        return stringBuffer.toString();
    }
}

