/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.x509;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1Choice;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Encodable;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1String;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1TaggedObject;
import edu.illinois.ncsa.bouncycastle.asn1.DERBMPString;
import edu.illinois.ncsa.bouncycastle.asn1.DERIA5String;
import edu.illinois.ncsa.bouncycastle.asn1.DERObject;
import edu.illinois.ncsa.bouncycastle.asn1.DERUTF8String;
import edu.illinois.ncsa.bouncycastle.asn1.DERVisibleString;

public class DisplayText
extends ASN1Encodable
implements ASN1Choice {
    public static final int CONTENT_TYPE_IA5STRING = 0;
    public static final int CONTENT_TYPE_BMPSTRING = 1;
    public static final int CONTENT_TYPE_UTF8STRING = 2;
    public static final int CONTENT_TYPE_VISIBLESTRING = 3;
    public static final int DISPLAY_TEXT_MAXIMUM_SIZE = 200;
    int contentType;
    ASN1String contents;

    public DisplayText(int n, String string) {
        if (string.length() > 200) {
            string = string.substring(0, 200);
        }
        this.contentType = n;
        switch (n) {
            case 0: {
                this.contents = new DERIA5String(string);
                break;
            }
            case 2: {
                this.contents = new DERUTF8String(string);
                break;
            }
            case 3: {
                this.contents = new DERVisibleString(string);
                break;
            }
            case 1: {
                this.contents = new DERBMPString(string);
                break;
            }
            default: {
                this.contents = new DERUTF8String(string);
            }
        }
    }

    public DisplayText(String string) {
        if (string.length() > 200) {
            string = string.substring(0, 200);
        }
        this.contentType = 2;
        this.contents = new DERUTF8String(string);
    }

    private DisplayText(ASN1String aSN1String) {
        this.contents = aSN1String;
    }

    public static DisplayText getInstance(Object object) {
        if (object instanceof ASN1String) {
            return new DisplayText((ASN1String)object);
        }
        if (object instanceof DisplayText) {
            return (DisplayText)object;
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DisplayText getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DisplayText.getInstance(aSN1TaggedObject.getObject());
    }

    public DERObject toASN1Object() {
        return (DERObject)((Object)this.contents);
    }

    public String getString() {
        return this.contents.getString();
    }
}

