/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.bcpg;

import edu.illinois.ncsa.bouncycastle.bcpg.BCPGInputStream;
import edu.illinois.ncsa.bouncycastle.bcpg.InputStreamPacket;
import edu.illinois.ncsa.bouncycastle.util.Strings;
import java.io.IOException;

public class LiteralDataPacket
extends InputStreamPacket {
    int format;
    byte[] fileName;
    long modDate;

    LiteralDataPacket(BCPGInputStream bCPGInputStream) throws IOException {
        super(bCPGInputStream);
        this.format = bCPGInputStream.read();
        int n = bCPGInputStream.read();
        this.fileName = new byte[n];
        for (int i = 0; i != this.fileName.length; ++i) {
            this.fileName[i] = (byte)bCPGInputStream.read();
        }
        this.modDate = (long)bCPGInputStream.read() << 24 | (long)(bCPGInputStream.read() << 16) | (long)(bCPGInputStream.read() << 8) | (long)bCPGInputStream.read();
    }

    public int getFormat() {
        return this.format;
    }

    public long getModificationTime() {
        return this.modDate * 1000L;
    }

    public String getFileName() {
        return Strings.fromUTF8ByteArray(this.fileName);
    }

    public byte[] getRawFileName() {
        byte[] byArray = new byte[this.fileName.length];
        for (int i = 0; i != byArray.length; ++i) {
            byArray[i] = this.fileName[i];
        }
        return byArray;
    }
}

